/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.json.JSONException;
import org.json.JSONObject;

class Dictionary {
    static final String JSON_IS_CONTAINER = "isContainer";
    static final String JSON_DESCRIPTION = "description";
    static final String JSON_TITLE = "title";
    static final String JSON_PROPERTIES = "properties";
    static final String JSON_DEFAULT_ASPECTS = "defaultAspects";
    static final String JSON_NAME = "name";
    static final String JSON_PARENT = "parent";
    static final String JSON_DATATYPE = "dataType";
    static final String JSON_DEFAULTVALUE = "defaultValue";
    static final String JSON_MULTIVALUED = "multiValued";
    static final String JSON_MANDATORY = "mandatory";
    static final String JSON_ENFORCED = "enforced";
    static final String JSON_PROTECTED = "protected";
    static final String JSON_INDEXED = "indexed";
    static final String JSON_ASSOCIATIONS = "associations";
    static final String JSON_CHILDASSOCIATIONS = "childassociations";
    static final String JSON_SOURCE = "source";
    static final String JSON_TARGET = "target";
    static final String JSON_CLASS = "class";
    static final String JSON_ROLE = "role";
    static final String JSON_MANY = "many";
    private final Map<String, DictionaryItem> types;
    private final Map<String, DictionaryItem> aspects;

    Dictionary(Map<String, DictionaryItem> types, Map<String, DictionaryItem> aspects) {
        this.types = types;
        this.aspects = aspects;
    }

    public DictionaryItem getType(String type) {
        return this.types.get(type);
    }

    public DictionaryItem getAspect(String aspect) {
        return this.aspects.get(aspect);
    }

    public DictionaryItem getTypeOrAspect(String ddclass) {
        DictionaryItem item = this.types.get(ddclass);
        if (item == null) {
            item = this.aspects.get(ddclass);
        }
        return item;
    }

    public boolean isSubType(String type, String isType) {
        boolean isSubType = false;
        try {
            DictionaryItem ddtype = this.getType(type);
            while (!isSubType && ddtype != null) {
                JSONObject parent = ddtype.data.getJSONObject(JSON_PARENT);
                if (parent.has(JSON_NAME)) {
                    String parentName = parent.getString(JSON_NAME);
                    ddtype = this.types.get(parentName);
                    if (ddtype == null) continue;
                    isSubType = isType.equals(ddtype.data.getString(JSON_NAME));
                    continue;
                }
                ddtype = null;
            }
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving subtype/parent information for: " + type, (Throwable)jsonErr);
        }
        return isSubType;
    }

    public boolean hasDefaultAspect(String type, String aspect) {
        boolean hasAspect = false;
        try {
            DictionaryItem ddtype = this.getType(type);
            if (ddtype != null) {
                JSONObject aspects = ddtype.data.getJSONObject(JSON_DEFAULT_ASPECTS);
                Iterator keys = aspects.keys();
                while (!hasAspect && keys.hasNext()) {
                    hasAspect = aspect.equals(keys.next());
                }
            }
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'defaultAspects' information for: " + type, (Throwable)jsonErr);
        }
        return hasAspect;
    }

    public String[] getDefaultAspects(String type) {
        String[] defaultAspects = null;
        try {
            DictionaryItem ddtype = this.getType(type);
            if (ddtype != null) {
                JSONObject aspects = ddtype.data.getJSONObject(JSON_DEFAULT_ASPECTS);
                defaultAspects = new String[aspects.length()];
                int count = 0;
                Iterator keys = aspects.keys();
                while (keys.hasNext()) {
                    defaultAspects[count++] = (String)keys.next();
                }
            }
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'defaultAspects' information for: " + type, (Throwable)jsonErr);
        }
        return defaultAspects != null ? defaultAspects : new String[]{};
    }

    public boolean hasProperty(String ddclass, String property, boolean checkDefaultAspects) {
        boolean hasProperty = false;
        try {
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            if (dditem != null) {
                JSONObject properties = dditem.data.getJSONObject(JSON_PROPERTIES);
                Iterator props = properties.keys();
                while (!hasProperty && props.hasNext()) {
                    hasProperty = property.equals(props.next());
                }
                if (checkDefaultAspects && !hasProperty) {
                    JSONObject aspects = dditem.data.getJSONObject(JSON_DEFAULT_ASPECTS);
                    Iterator keys = aspects.keys();
                    while (!hasProperty && keys.hasNext()) {
                        DictionaryItem aspect = this.getAspect((String)keys.next());
                        if (aspect == null) continue;
                        props = aspect.data.getJSONObject(JSON_PROPERTIES).keys();
                        while (!hasProperty && props.hasNext()) {
                            hasProperty = property.equals(props.next());
                        }
                    }
                }
            }
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'properties' information for: " + ddclass, (Throwable)jsonErr);
        }
        return hasProperty;
    }

    public String getTitle(String ddclass) {
        try {
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            return dditem != null ? dditem.data.getString(JSON_TITLE) : null;
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'title' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public String getDescription(String ddclass) {
        try {
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            return dditem != null ? dditem.data.getString(JSON_DESCRIPTION) : null;
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'description' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public String getParent(String ddclass) {
        try {
            String parentType = null;
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            if (dditem != null) {
                JSONObject parent = dditem.data.getJSONObject(JSON_PARENT);
                parentType = parent.optString(JSON_NAME);
            }
            return parentType;
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'parent' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public boolean isContainer(String type) {
        try {
            DictionaryItem ddtype = this.getType(type);
            return ddtype != null ? ddtype.data.getBoolean(JSON_IS_CONTAINER) : false;
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'isContainer' information for: " + type, (Throwable)jsonErr);
        }
    }

    public DictionaryProperty getProperty(String ddclass, String property, boolean checkDefaultAspects) {
        try {
            DictionaryProperty ddprop = null;
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            if (dditem != null) {
                JSONObject properties = dditem.data.getJSONObject(JSON_PROPERTIES);
                if (properties.has(property)) {
                    ddprop = new DictionaryProperty(property, properties.getJSONObject(property));
                } else if (checkDefaultAspects) {
                    JSONObject aspects = dditem.data.getJSONObject(JSON_DEFAULT_ASPECTS);
                    Iterator keys = aspects.keys();
                    while (ddprop == null && keys.hasNext()) {
                        DictionaryItem aspect = this.getAspect((String)keys.next());
                        if (aspect == null || !(properties = aspect.data.getJSONObject(JSON_PROPERTIES)).has(property)) continue;
                        ddprop = new DictionaryProperty(property, properties.getJSONObject(property));
                    }
                }
            }
            return ddprop;
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'properties' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public DictionaryProperty[] getProperties(String ddclass, boolean checkDefaultAspects) {
        try {
            DictionaryProperty[] ddprops = null;
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            if (dditem != null) {
                JSONObject properties = dditem.data.getJSONObject(JSON_PROPERTIES);
                ArrayList<DictionaryProperty> propList = new ArrayList<DictionaryProperty>(properties.length());
                Iterator props = properties.keys();
                while (props.hasNext()) {
                    String propName = (String)props.next();
                    propList.add(new DictionaryProperty(propName, properties.getJSONObject(propName)));
                }
                if (checkDefaultAspects) {
                    JSONObject aspects = dditem.data.getJSONObject(JSON_DEFAULT_ASPECTS);
                    Iterator keys = aspects.keys();
                    while (keys.hasNext()) {
                        DictionaryItem aspect = this.getAspect((String)keys.next());
                        if (aspect == null) continue;
                        properties = aspect.data.getJSONObject(JSON_PROPERTIES);
                        props = properties.keys();
                        while (props.hasNext()) {
                            String propName = (String)props.next();
                            propList.add(new DictionaryProperty(propName, properties.getJSONObject(propName)));
                        }
                    }
                }
                ddprops = new DictionaryProperty[propList.size()];
                propList.toArray(ddprops);
            }
            return ddprops != null ? ddprops : new DictionaryProperty[]{};
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'properties' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public DictionaryAssoc[] getAssociations(String ddclass) {
        try {
            DictionaryAssoc[] ddassocs = null;
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            if (dditem != null) {
                JSONObject assocs = dditem.data.getJSONObject(JSON_ASSOCIATIONS);
                ddassocs = new DictionaryAssoc[assocs.length()];
                int count = 0;
                Iterator assocNames = assocs.keys();
                while (assocNames.hasNext()) {
                    String assocName = (String)assocNames.next();
                    ddassocs[count++] = new DictionaryAssoc(assocName, assocs.getJSONObject(assocName));
                }
            }
            return ddassocs != null ? ddassocs : new DictionaryAssoc[]{};
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'associations' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public DictionaryAssoc[] getChildAssociations(String ddclass) {
        try {
            DictionaryAssoc[] ddassocs = null;
            DictionaryItem dditem = this.getTypeOrAspect(ddclass);
            if (dditem != null) {
                JSONObject assocs = dditem.data.getJSONObject(JSON_CHILDASSOCIATIONS);
                ddassocs = new DictionaryAssoc[assocs.length()];
                int count = 0;
                Iterator assocNames = assocs.keys();
                while (assocNames.hasNext()) {
                    String assocName = (String)assocNames.next();
                    ddassocs[count++] = new DictionaryAssoc(assocName, assocs.getJSONObject(assocName));
                }
            }
            return ddassocs != null ? ddassocs : new DictionaryAssoc[]{};
        }
        catch (JSONException jsonErr) {
            throw new AlfrescoRuntimeException("Error retrieving 'childassociations' information for: " + ddclass, (Throwable)jsonErr);
        }
    }

    public String toString() {
        return "Dictionary contains " + this.types.size() + " types and " + this.aspects.size() + " aspects.";
    }

    public static class DictionaryAssoc
    extends DictionaryMetaBase {
        DictionaryAssoc(String name, JSONObject assoc) {
            super(name, assoc);
        }

        public String getTitle() {
            return this.getStringValue(Dictionary.JSON_TITLE);
        }

        public String getSourceClass() {
            return this.getStringValue(Dictionary.JSON_SOURCE, Dictionary.JSON_CLASS);
        }

        public String getSourceRole() {
            return this.getStringValue(Dictionary.JSON_SOURCE, Dictionary.JSON_ROLE);
        }

        public boolean getSourceIsMandatory() {
            return this.getBooleanValue(Dictionary.JSON_SOURCE, Dictionary.JSON_MANDATORY);
        }

        public boolean getSourceIsMany() {
            return this.getBooleanValue(Dictionary.JSON_SOURCE, Dictionary.JSON_MANY);
        }

        public String getTargetClass() {
            return this.getStringValue(Dictionary.JSON_TARGET, Dictionary.JSON_CLASS);
        }

        public String getTargetRole() {
            return this.getStringValue(Dictionary.JSON_TARGET, Dictionary.JSON_ROLE);
        }

        public boolean getTargetIsMandatory() {
            return this.getBooleanValue(Dictionary.JSON_TARGET, Dictionary.JSON_MANDATORY);
        }

        public boolean getTargetIsMany() {
            return this.getBooleanValue(Dictionary.JSON_TARGET, Dictionary.JSON_MANY);
        }
    }

    public static class DictionaryProperty
    extends DictionaryMetaBase {
        DictionaryProperty(String name, JSONObject property) {
            super(name, property);
        }

        public String getTitle() {
            return this.getStringValue(Dictionary.JSON_TITLE);
        }

        public String getDescription() {
            return this.getStringValue(Dictionary.JSON_DESCRIPTION);
        }

        public String getDataType() {
            return this.getStringValue(Dictionary.JSON_DATATYPE);
        }

        public String getDefaultValue() {
            return this.getStringValue(Dictionary.JSON_DEFAULTVALUE);
        }

        public boolean getIsMultiValued() {
            return this.getBooleanValue(Dictionary.JSON_MULTIVALUED);
        }

        public boolean getIsMandatory() {
            return this.getBooleanValue(Dictionary.JSON_MANDATORY);
        }

        public boolean getIsEnforced() {
            return this.getBooleanValue(Dictionary.JSON_ENFORCED);
        }

        public boolean getIsProtected() {
            return this.getBooleanValue(Dictionary.JSON_PROTECTED);
        }

        public boolean getIsIndexed() {
            return this.getBooleanValue(Dictionary.JSON_INDEXED);
        }
    }

    private static abstract class DictionaryMetaBase {
        private final JSONObject meta;
        private final String name;

        DictionaryMetaBase(String name, JSONObject meta) {
            this.name = name;
            this.meta = meta;
        }

        public String getName() {
            return this.name;
        }

        protected String getStringValue(String value) {
            try {
                return this.meta.getString(value);
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException("Error retrieving '" + value + "' information for item: " + this.name, (Throwable)e);
            }
        }

        protected String getStringValue(String object, String value) {
            try {
                String result = null;
                if (this.meta.has(object)) {
                    result = this.meta.getJSONObject(object).optString(value);
                }
                return result;
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException("Error retrieving '" + value + "' information for item: " + this.name, (Throwable)e);
            }
        }

        protected boolean getBooleanValue(String value) {
            try {
                return this.meta.getBoolean(value);
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException("Error retrieving '" + value + "' information for item: " + this.name, (Throwable)e);
            }
        }

        protected boolean getBooleanValue(String object, String value) {
            try {
                boolean result = false;
                if (this.meta.has(object)) {
                    result = this.meta.getJSONObject(object).getBoolean(value);
                }
                return result;
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException("Error retrieving '" + value + "' information for item: " + this.name, (Throwable)e);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static class DictionaryItem {
        private final String type;
        private final JSONObject data;

        DictionaryItem(String type, JSONObject data) {
            this.type = type;
            this.data = data;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            return this.type.equals(obj);
        }

        public String toString() {
            return this.type.toString() + "\r\n" + this.data.toString();
        }
    }
}

