/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ParameterCheck;
import org.alfresco.web.scripts.Dictionary;
import org.alfresco.web.scripts.SingletonValueProcessorExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;

public class DictionaryQuery
extends SingletonValueProcessorExtension<Dictionary>
implements Serializable {
    private static Log logger = LogFactory.getLog(DictionaryQuery.class);

    public boolean isSubType(String type, String isType) {
        ParameterCheck.mandatoryString((String)"type", (String)type);
        ParameterCheck.mandatoryString((String)"isType", (String)isType);
        return type.equals(isType) || this.getDictionary().isSubType(type, isType);
    }

    public boolean hasDefaultAspect(String type, String aspect) {
        ParameterCheck.mandatoryString((String)"type", (String)type);
        ParameterCheck.mandatoryString((String)"aspect", (String)aspect);
        return this.getDictionary().hasDefaultAspect(type, aspect);
    }

    public String[] getDefaultAspects(String type) {
        ParameterCheck.mandatoryString((String)"type", (String)type);
        return this.getDictionary().getDefaultAspects(type);
    }

    public boolean isAspect(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getAspect(ddclass) != null;
    }

    public boolean isType(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getType(ddclass) != null;
    }

    public boolean hasProperty(String ddclass, String property) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        ParameterCheck.mandatoryString((String)"property", (String)property);
        return this.getDictionary().hasProperty(ddclass, property, false);
    }

    public boolean hasProperty(String ddclass, String property, boolean includeDefaultAspects) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        ParameterCheck.mandatoryString((String)"property", (String)property);
        return this.getDictionary().hasProperty(ddclass, property, true);
    }

    public String getTitle(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getTitle(ddclass);
    }

    public String getDescription(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getDescription(ddclass);
    }

    public String getParent(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getParent(ddclass);
    }

    public boolean isContainer(String type) {
        ParameterCheck.mandatoryString((String)"type", (String)type);
        return this.getDictionary().isContainer(type);
    }

    public Dictionary.DictionaryProperty getProperty(String ddclass, String property) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        ParameterCheck.mandatoryString((String)"property", (String)property);
        return this.getDictionary().getProperty(ddclass, property, false);
    }

    public Dictionary.DictionaryProperty getProperty(String ddclass, String property, boolean includeDefaultAspects) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        ParameterCheck.mandatoryString((String)"property", (String)property);
        return this.getDictionary().getProperty(ddclass, property, true);
    }

    public Dictionary.DictionaryProperty[] getProperties(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getProperties(ddclass, false);
    }

    public Dictionary.DictionaryProperty[] getProperties(String ddclass, boolean includeDefaultAspects) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getProperties(ddclass, true);
    }

    public Dictionary.DictionaryAssoc[] getAssociations(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getAssociations(ddclass);
    }

    public Dictionary.DictionaryAssoc[] getChildAssociations(String ddclass) {
        ParameterCheck.mandatoryString((String)"ddclass", (String)ddclass);
        return this.getDictionary().getChildAssociations(ddclass);
    }

    public String toString() {
        try {
            int idx;
            String out = "";
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            String userId = rc.getUserId();
            if (userId != null && !AuthenticationUtil.isGuest((String)userId) && (idx = userId.indexOf(64)) != -1) {
                out = "Dictionary for user domain: " + userId.substring(idx) + "\r\n";
            }
            return out + this.getDictionary().toString();
        }
        catch (Throwable e) {
            return super.toString();
        }
    }

    private Dictionary getDictionary() {
        return (Dictionary)this.getSingletonValue(true);
    }

    @Override
    protected Dictionary retrieveValue(String userId, String storeId) throws ConnectorServiceException {
        HashMap<String, Dictionary.DictionaryItem> aspects;
        HashMap<String, Dictionary.DictionaryItem> types;
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco", userId, ServletUtil.getSession());
        Response response = conn.call("/api/dictionary");
        if (response.getStatus().getCode() == 200) {
            logger.info((Object)("Successfully retrieved Data Dictionary from Alfresco." + (storeId.length() != 0 ? " - for domain: " + storeId : "")));
            types = new HashMap<String, Dictionary.DictionaryItem>(128);
            aspects = new HashMap<String, Dictionary.DictionaryItem>(128);
            try {
                JSONArray json = new JSONArray(response.getResponse());
                for (int i = 0; i < json.length(); ++i) {
                    JSONObject ddclass = json.getJSONObject(i);
                    String typeName = ddclass.getString("name");
                    if (ddclass.getBoolean("isAspect")) {
                        aspects.put(typeName, new Dictionary.DictionaryItem(typeName, ddclass));
                        continue;
                    }
                    types.put(typeName, new Dictionary.DictionaryItem(typeName, ddclass));
                }
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new AlfrescoRuntimeException("Unable to retrieve dictionary information from Alfresco: " + response.getStatus().getCode());
        }
        Dictionary dictionary = new Dictionary(types, aspects);
        return dictionary;
    }

    @Override
    protected String getValueName() {
        return "dictionary information";
    }
}

