/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.scripts.SingletonValueProcessorExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;

public class GoogleDocsStatus
extends SingletonValueProcessorExtension<Boolean> {
    private static Log logger = LogFactory.getLog(GoogleDocsStatus.class);

    public boolean getEnabled() {
        return (Boolean)this.getSingletonValue();
    }

    @Override
    protected Boolean retrieveValue(String userId, String storeId) throws ConnectorServiceException {
        boolean enabled = false;
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco", userId, ServletUtil.getSession());
        Response response = conn.call("/api/googledocs/status");
        if (response.getStatus().getCode() == 200) {
            try {
                JSONObject json = new JSONObject(response.getResponse());
                if (json.has("data") && json.getJSONObject("data").has("enabled")) {
                    enabled = json.getJSONObject("data").getBoolean("enabled");
                    logger.info((Object)("Successfully retrieved Google Docs subsystem status from Alfresco: " + enabled));
                }
                logger.error((Object)"Unexpected response from '/api/googledocs/status' - did not contain expected JSON values.");
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new AlfrescoRuntimeException("Unable to retrieve Google Docs subsystem status from Alfresco: " + response.getStatus().getCode());
        }
        return enabled;
    }

    @Override
    protected String getValueName() {
        return "Google Docs subsystem status";
    }
}

