/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.scripts.Mimetype;
import org.alfresco.web.scripts.SingletonValueProcessorExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;

public class MimetypesQuery
extends SingletonValueProcessorExtension<Map<String, Mimetype>>
implements Serializable {
    private static Log logger = LogFactory.getLog(MimetypesQuery.class);

    public Map<String, String> getDisplaysByMimetype() {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        Map<String, Mimetype> mimetypes = this.getMimetypes();
        for (Mimetype mimetype : mimetypes.values()) {
            descriptions.put(mimetype.getMimetype(), mimetype.getDescription());
        }
        return descriptions;
    }

    public Map<String, String> getMimetypesByDisplay() {
        TreeMap<String, String> types = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        Map<String, Mimetype> mimetypes = this.getMimetypes();
        for (Mimetype mimetype : mimetypes.values()) {
            types.put(mimetype.getDescription(), mimetype.getMimetype());
        }
        return types;
    }

    public String getExtension(String mimetype) {
        Mimetype mt = this.getMimetypes().get(mimetype);
        if (mt != null) {
            return mt.getDefaultExtension();
        }
        return null;
    }

    public String toString() {
        try {
            int idx;
            String out = "";
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            String userId = rc.getUserId();
            if (userId != null && !AuthenticationUtil.isGuest((String)userId) && (idx = userId.indexOf(64)) != -1) {
                out = "Mimetypes for user domain: " + userId.substring(idx) + "\r\n";
            }
            return out + this.getMimetypes().toString();
        }
        catch (Throwable e) {
            return super.toString();
        }
    }

    private Map<String, Mimetype> getMimetypes() {
        return (Map)this.getSingletonValue();
    }

    @Override
    protected Map<String, Mimetype> retrieveValue(String userId, String storeId) throws ConnectorServiceException {
        HashMap<String, Mimetype> mimetypes;
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco", userId, ServletUtil.getSession());
        Response response = conn.call("/api/mimetypes/descriptions");
        if (response.getStatus().getCode() == 200) {
            logger.info((Object)"Successfully retrieved mimetypes information from Alfresco.");
            mimetypes = new HashMap<String, Mimetype>(128);
            try {
                JSONObject json = new JSONObject(response.getResponse());
                JSONObject data = json.getJSONObject("data");
                Iterator types = data.keys();
                while (types.hasNext()) {
                    String mimetype = (String)types.next();
                    Mimetype details = new Mimetype(mimetype, data.getJSONObject(mimetype));
                    mimetypes.put(mimetype, details);
                }
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new AlfrescoRuntimeException("Unable to retrieve mimetypes information from Alfresco: " + response.getStatus().getCode());
        }
        return mimetypes;
    }

    @Override
    protected String getValueName() {
        return "mimetypes information";
    }
}

