/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class SlingshotRemoteClient
extends RemoteClient {
    private static final Pattern CONTENT_PATTERN = Pattern.compile(".*/api/(node|path)/content/workspace/SpacesStore/.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResponseStreamOutput(URL url, HttpServletResponse res, OutputStream out, org.apache.commons.httpclient.HttpMethod method, String contentType, int bufferSize) throws IOException {
        boolean process = false;
        if (res != null && this.getRequestMethod() == HttpMethod.GET && contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("application/xhtml+xml")) && CONTENT_PATTERN.matcher(url.getPath()).matches()) {
            process = true;
        }
        if (!process) {
            super.copyResponseStreamOutput(url, res, out, method, contentType, bufferSize);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(bufferSize);
            InputStream input = method.getResponseBodyAsStream();
            if (input != null) {
                try {
                    byte[] buffer = new byte[bufferSize];
                    int read = input.read(buffer);
                    while (read != -1) {
                        bos.write(buffer, 0, read);
                        read = input.read(buffer);
                    }
                }
                finally {
                    input.close();
                }
                String encoding = null;
                int csi = contentType.indexOf("charset=");
                if (csi != -1) {
                    encoding = contentType.substring(csi + "charset=".length());
                }
                String content = encoding != null ? new String(bos.toByteArray(), encoding) : new String(bos.toByteArray());
                content = StringUtils.stripUnsafeHTMLTags((String)content, (boolean)false);
                try {
                    byte[] bytes = encoding != null ? content.getBytes(encoding) : content.getBytes();
                    res.setContentLength(bytes.length);
                    out.write(bytes);
                }
                finally {
                    out.close();
                }
            }
        }
    }
}

