/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.scripts.SingletonValueProcessorExtension;
import org.alfresco.web.site.EditionInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;

public class SyncModeConfig
extends SingletonValueProcessorExtension<String>
implements Serializable {
    private static Log logger = LogFactory.getLog(SyncModeConfig.class);

    public String getValue() {
        return (String)this.getSingletonValue();
    }

    @Override
    protected String retrieveValue(String userId, String storeId) throws ConnectorServiceException {
        String syncModeConfig = "OFF";
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        String edition = ((EditionInterceptor.EditionInfo)rc.getValue("editionInfo")).getEdition();
        if ("ENTERPRISE".equals(edition)) {
            Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco");
            Response response = conn.call("/enterprise/sync/config");
            if (response.getStatus().getCode() == 200) {
                try {
                    JSONObject json = new JSONObject(response.getResponse());
                    if (json.has("syncMode")) {
                        syncModeConfig = json.getString("syncMode");
                        logger.info((Object)("Successfully retrieved Sync Mode configuration from Alfresco: " + syncModeConfig));
                    }
                    logger.error((Object)"Unexpected response from '/enterprise/sync/config' - did not contain expected 'syncMode' value.");
                }
                catch (JSONException e) {
                    throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new AlfrescoRuntimeException("Unable to retrieve Sync Mode configuration from Alfresco: " + response.getStatus().getCode());
            }
        }
        return syncModeConfig;
    }

    @Override
    protected String getValueName() {
        return "Sync Mode configuration";
    }
}

