/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.util.GUID;
import org.alfresco.web.site.ClusterAwareRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.PathStoreObjectPersister;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class ClusterAwarePathStoreObjectPersister
extends PathStoreObjectPersister
implements MessageListener<String> {
    private static Log logger = LogFactory.getLog(ClusterAwarePathStoreObjectPersister.class);
    private HazelcastInstance hazelcastInstance;
    private String hazelcastTopicName;
    private ITopic<String> clusterTopic = null;
    private static final String clusterNodeId = GUID.generate();

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void setHazelcastTopicName(String hazelcastTopicName) {
        this.hazelcastTopicName = hazelcastTopicName;
    }

    public void init(ModelPersistenceContext context) {
        super.init(context);
        if (this.hazelcastInstance == null) {
            throw new IllegalArgumentException("The hazelcastInstance property (HazelcastInstance) is mandatory.");
        }
        if (this.hazelcastTopicName == null || this.hazelcastTopicName.length() == 0) {
            throw new IllegalArgumentException("The hazelcastTopicName property (String) is mandatory.");
        }
        ITopic topic = this.hazelcastInstance.getTopic(this.hazelcastTopicName);
        if (topic == null) {
            throw new IllegalArgumentException("Did not find Hazelcast topic with name: '" + this.hazelcastTopicName + "' - cannot init.");
        }
        this.clusterTopic = topic;
        this.clusterTopic.addMessageListener((MessageListener)this);
    }

    public boolean saveObject(ModelPersistenceContext context, ModelObject modelObject) throws ModelObjectPersisterException {
        boolean saved = super.saveObject(context, modelObject);
        if (saved) {
            this.addInvalidCachePath(this.generatePath(modelObject.getTypeId(), modelObject.getId()));
        }
        return saved;
    }

    public boolean removeObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean removed = super.removeObject(context, objectTypeId, objectId);
        if (removed) {
            this.addInvalidCachePath(this.generatePath(objectTypeId, objectId));
        }
        return removed;
    }

    protected ModelObject newObject(ModelPersistenceContext context, String objectTypeId, String objectId, boolean addToCache) throws ModelObjectPersisterException {
        ModelObject modelObject = super.newObject(context, objectTypeId, objectId, addToCache);
        if (modelObject != null) {
            this.addInvalidCachePath(this.generatePath(objectTypeId, objectId));
        }
        return modelObject;
    }

    private void addInvalidCachePath(String path) {
        RequestContext rc;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding invalid cache path: " + path));
        }
        if (!((rc = ThreadLocalRequestContext.getRequestContext()) instanceof ClusterAwareRequestContext)) {
            throw new IllegalStateException("Incorrect Share cluster configuration detected - ClusterAwareRequestContextFactory is required.");
        }
        ((ClusterAwareRequestContext)rc).addInvalidCachePath(path);
    }

    public void pushMessage(ClusterMessage message) {
        String msg = message.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pushing message:\r\n" + msg));
        }
        this.clusterTopic.publish((Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        boolean debug = logger.isDebugEnabled();
        MessageProcessor proc = new MessageProcessor(message);
        if (!proc.isSender()) {
            if (debug) {
                logger.debug((Object)("Received message:\r\n" + message));
            }
            if ("cache-invalidation".equals(proc.getMessageType())) {
                List paths;
                if (debug) {
                    logger.debug((Object)("Processing message of type: " + proc.getMessageType()));
                }
                if ((paths = (List)proc.getMessagePayload().get("paths")) != null) {
                    this.cacheLock.writeLock().lock();
                    try {
                        for (String path : paths) {
                            if (debug) {
                                logger.debug((Object)("...invalidating cache for path: " + path));
                            }
                            this.objectCache.remove(path);
                            if (this.caches.size() == 0) continue;
                            for (Map.Entry entry : this.caches.entrySet()) {
                                ((ContentCache)entry.getValue()).remove(path);
                            }
                        }
                    }
                    finally {
                        this.cacheLock.writeLock().unlock();
                    }
                }
            } else {
                logger.warn((Object)("Received message of unknown type: " + proc.getMessageType()));
            }
        }
    }

    static class MessageProcessor {
        private final String sender;
        private final String type;
        private final Map<String, Object> payload;

        MessageProcessor(String msg) {
            try {
                Map json = (Map)new JSONParser().parse(msg, new ContainerFactory(){

                    public Map createObjectContainer() {
                        return new HashMap();
                    }

                    public List creatArrayContainer() {
                        return new ArrayList();
                    }
                });
                this.sender = (String)json.get("sender");
                Map message = (Map)json.get("message");
                this.type = (String)message.get("type");
                this.payload = (Map)message.get("payload");
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to parse cluster JSON message: " + e.getMessage() + "\r\n" + msg);
            }
        }

        boolean isSender() {
            return clusterNodeId.equals(this.sender);
        }

        String getMessageType() {
            return this.type;
        }

        Map<String, Object> getMessagePayload() {
            return this.payload;
        }
    }

    static class PathInvalidationMessage
    extends BaseMessage {
        static final String TYPE = "cache-invalidation";
        static final String PAYLOAD_PATHS = "paths";

        PathInvalidationMessage(List<String> paths) {
            super(TYPE, Collections.singletonMap(PAYLOAD_PATHS, paths));
        }
    }

    static abstract class BaseMessage
    implements ClusterMessage {
        private final String type;
        final Map<String, Object> payload;

        BaseMessage(String type, Map<String, Object> payload) {
            this.type = type;
            this.payload = payload;
        }

        @Override
        public Map<String, Object> getPayload() {
            return this.payload;
        }

        @Override
        public String getSender() {
            return clusterNodeId;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            try {
                StringBuilderWriter buffer = new StringBuilderWriter(512);
                JSONWriter writer = new JSONWriter((Writer)buffer);
                writer.startObject();
                writer.writeValue("sender", this.getSender());
                writer.startValue("message");
                writer.startObject();
                writer.writeValue("type", this.getType());
                writer.startValue("payload");
                BaseMessage.serialiseMessageObjects(writer, null, this.payload);
                writer.endValue();
                writer.endObject();
                writer.endValue();
                writer.endObject();
                return buffer.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to output cluster message: " + e.getMessage(), e);
            }
        }

        static void serialiseMessageObjects(JSONWriter writer, String name, Object obj) throws IOException {
            if (obj instanceof Map) {
                if (name != null) {
                    writer.startValue(name);
                }
                writer.startObject();
                Map map = (Map)obj;
                for (String key : map.keySet()) {
                    BaseMessage.serialiseMessageObjects(writer, key, map.get(key));
                }
                writer.endObject();
                if (name != null) {
                    writer.endValue();
                }
            } else if (obj instanceof List) {
                if (name != null) {
                    writer.startValue(name);
                }
                writer.startArray();
                for (Object item : (List)obj) {
                    BaseMessage.serialiseMessageObjects(writer, null, item);
                }
                writer.endArray();
                if (name != null) {
                    writer.endValue();
                }
            } else if (obj instanceof Integer) {
                if (name != null) {
                    writer.writeValue(name, ((Integer)obj).intValue());
                } else {
                    writer.writeValue(((Integer)obj).intValue());
                }
            } else if (obj instanceof Boolean) {
                if (name != null) {
                    writer.writeValue(name, ((Boolean)obj).booleanValue());
                } else {
                    writer.writeValue(((Boolean)obj).booleanValue());
                }
            } else if (obj instanceof Date) {
                if (name != null) {
                    writer.writeValue(name, ISO8601DateFormat.format((Date)((Date)obj)));
                } else {
                    writer.writeValue(ISO8601DateFormat.format((Date)((Date)obj)));
                }
            } else if (obj == null) {
                if (name != null) {
                    writer.writeNullValue(name);
                } else {
                    writer.writeNullValue();
                }
            } else if (name != null) {
                writer.writeValue(name, obj.toString());
            } else {
                writer.writeValue(obj.toString());
            }
        }
    }

    static interface ClusterMessage {
        public static final String JSON_SENDER = "sender";
        public static final String JSON_MESSAGE = "message";
        public static final String JSON_TYPE = "type";
        public static final String JSON_PAYLOAD = "payload";

        public String getSender();

        public String getType();

        public Map<String, Object> getPayload();
    }
}

