/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.web.site.ClusterAwarePathStoreObjectPersister;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.LinkBuilder;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.support.ServletRequestContext;

public class ClusterAwareRequestContext
extends ServletRequestContext {
    private List<String> invalidCachePaths = new ArrayList<String>();
    private ClusterAwarePathStoreObjectPersister clusterObjectPersister;

    public ClusterAwareRequestContext(ClusterAwarePathStoreObjectPersister clusterObjectPersister, WebFrameworkServiceRegistry serviceRegistry, FrameworkBean frameworkBean, LinkBuilder linkBuilder) {
        super(serviceRegistry, frameworkBean, linkBuilder);
        this.clusterObjectPersister = clusterObjectPersister;
    }

    void addInvalidCachePath(String path) {
        this.invalidCachePaths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            if (this.invalidCachePaths.size() != 0) {
                ClusterAwarePathStoreObjectPersister.PathInvalidationMessage msg = new ClusterAwarePathStoreObjectPersister.PathInvalidationMessage(this.invalidCachePaths);
                this.clusterObjectPersister.pushMessage(msg);
            }
        }
        finally {
            super.release();
        }
    }
}

