/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpSession;
import org.alfresco.web.site.servlet.MTAuthenticationFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.config.ConfigBootstrap;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.WebFrameworkServiceException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkInterceptor;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;

public class EditionInterceptor
extends AbstractWebFrameworkInterceptor {
    public static final String EDITION_INFO = "editionInfo";
    public static final String ENTERPRISE_EDITION = "ENTERPRISE";
    public static final String TEAM_EDITION = "TEAM";
    public static final String UNKNOWN_EDITION = "UNKNOWN";
    private static Log logger = LogFactory.getLog(EditionInterceptor.class);
    private static EditionInfo EDITIONINFO = null;
    private static volatile boolean outputInfo = false;
    private static final ReadWriteLock editionLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preHandle(WebRequest request) throws Exception {
        editionLock.readLock().lock();
        try {
            if (EDITIONINFO == null) {
                editionLock.readLock().unlock();
                editionLock.writeLock().lock();
                try {
                    if (EDITIONINFO == null) {
                        HttpSession session;
                        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
                        Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco");
                        ConnectorContext ctx = new ConnectorContext();
                        ctx.setExceptionOnError(false);
                        Response response = conn.call("/api/admin/restrictions?guest=true", ctx);
                        if (response.getStatus().getCode() == 401 && MTAuthenticationFilter.getCurrentServletRequest() != null && (session = MTAuthenticationFilter.getCurrentServletRequest().getSession(false)) != null) {
                            conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco", (String)session.getAttribute("_alf_USER_ID"), session);
                            response = conn.call("/api/admin/restrictions");
                        }
                        if (response.getStatus().getCode() == 200) {
                            logger.info((Object)"Successfully retrieved license information from Alfresco.");
                            EDITIONINFO = new EditionInfo(response.getResponse());
                            String runtimeConfig = null;
                            if (TEAM_EDITION.equals(EDITIONINFO.getEdition())) {
                                runtimeConfig = "classpath:alfresco/team-config.xml";
                            } else if (ENTERPRISE_EDITION.equals(EDITIONINFO.getEdition())) {
                                runtimeConfig = "classpath:alfresco/enterprise-config.xml";
                            }
                            if (runtimeConfig != null) {
                                ArrayList<String> configs = new ArrayList<String>(1);
                                configs.add(runtimeConfig);
                                ConfigService configservice = rc.getServiceRegistry().getConfigService();
                                ConfigBootstrap cb = new ConfigBootstrap();
                                cb.setBeanName("share-edition-config");
                                cb.setConfigService(configservice);
                                cb.setConfigs(configs);
                                cb.register();
                                configservice.reset();
                            }
                        } else {
                            if (!outputInfo) {
                                logger.info((Object)("Unable to retrieve License information from Alfresco: " + response.getStatus().getCode()));
                                outputInfo = true;
                            }
                            ThreadLocalRequestContext.getRequestContext().setValue(EDITION_INFO, (Serializable)new EditionInfo());
                        }
                    }
                }
                catch (JSONException err) {
                    throw new WebFrameworkServiceException("Unable to process response: " + err.getMessage(), (Exception)((Object)err));
                }
                finally {
                    editionLock.readLock().lock();
                    editionLock.writeLock().unlock();
                }
            }
            if (EDITIONINFO != null) {
                ThreadLocalRequestContext.getRequestContext().setValue(EDITION_INFO, (Serializable)EDITIONINFO);
            }
        }
        finally {
            editionLock.readLock().unlock();
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
    }

    public static class EditionInfo
    implements Serializable {
        private final long users;
        private final long documents;
        private final String edition;

        EditionInfo() {
            this.users = -1L;
            this.documents = -1L;
            this.edition = EditionInterceptor.UNKNOWN_EDITION;
        }

        EditionInfo(String response) throws JSONException {
            JSONObject json = new JSONObject(response);
            this.users = json.optLong("users", -1L);
            this.documents = json.optLong("documents", -1L);
            this.edition = json.getString("licenseMode");
        }

        public long getUsers() {
            return this.users;
        }

        public long getDocuments() {
            return this.documents;
        }

        public String getEdition() {
            return this.edition;
        }

        public String toString() {
            return "Users: " + this.users + "  Documents: " + this.documents + "  Edition: " + this.edition;
        }
    }
}

