/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.exception.CredentialVaultProviderException;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.mvc.PageView;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.webscripts.connector.User;

public class SlingshotPageView
extends PageView {
    private RemoteConfigElement config;

    public SlingshotPageView(WebFrameworkConfigElement webFrameworkConfiguration, ModelObjectService modelObjectService, ResourceService resourceService, RenderService renderService, TemplatesContainer templatesContainer) {
        super(webFrameworkConfiguration, modelObjectService, resourceService, renderService, templatesContainer);
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
    }

    protected void validateRequestContext(RequestContext rc, HttpServletRequest req) throws Exception {
        Theme theme;
        super.validateRequestContext(rc, req);
        String themeId = null;
        String siteId = (String)rc.getUriTokens().get("site");
        if (siteId != null) {
            Page dashboard = this.getObjectService().getPage("site/" + siteId + "/dashboard");
            if (dashboard != null) {
                themeId = dashboard.getProperty("theme");
            }
        } else {
            themeId = rc.getPage().getProperty("theme");
        }
        if (themeId != null && themeId.length() != 0 && !rc.getThemeId().equals(themeId) && (theme = this.getObjectService().getTheme(themeId)) != null) {
            rc.setTheme(theme);
        }
    }

    protected boolean loginRequiredForPage(RequestContext context, HttpServletRequest request, Page page) {
        boolean externalAuth = false;
        RemoteConfigElement.EndpointDescriptor descriptor = this.getRemoteConfig(context).getEndpointDescriptor("alfresco");
        if (descriptor != null) {
            externalAuth = descriptor.getExternalAuth();
        }
        boolean login = false;
        User user = context.getUser();
        switch (page.getAuthentication()) {
            case guest: {
                login = user == null;
                break;
            }
            case user: {
                try {
                    login = user == null || AuthenticationUtil.isGuest((String)user.getId()) || !context.getServiceRegistry().getConnectorService().getCredentialVault(request.getSession(), user.getId()).hasCredentials("alfresco") && !externalAuth;
                    break;
                }
                catch (CredentialVaultProviderException err) {
                    throw new PlatformRuntimeException("Unable to retrieve credentials for current user.", (Throwable)err);
                }
            }
            case admin: {
                try {
                    login = user == null || !user.isAdmin() || !context.getServiceRegistry().getConnectorService().getCredentialVault(request.getSession(), user.getId()).hasCredentials("alfresco") && !externalAuth;
                }
                catch (CredentialVaultProviderException err) {
                    throw new PlatformRuntimeException("Unable to retrieve credentials for current user.", (Throwable)err);
                }
                if (!login) break;
                AuthenticationUtil.clearUserContext((HttpServletRequest)request);
            }
        }
        return login;
    }

    private RemoteConfigElement getRemoteConfig(RequestContext context) {
        if (this.config == null) {
            this.config = (RemoteConfigElement)context.getServiceRegistry().getConfigService().getConfig((Object)"Remote").getConfigElement("remote");
        }
        return this.config;
    }
}

