/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import java.util.HashMap;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.webscripts.connector.AlfrescoConnector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.RemoteClient;

public class SlingshotAlfrescoConnector
extends AlfrescoConnector {
    private static final String CD_USER_HEADER = "userHeader";
    public static final String CS_PARAM_USER_HEADER = "userHeader";

    public SlingshotAlfrescoConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String endpoint) {
        super(descriptor, endpoint);
    }

    private String getUserHeader() {
        String userHeader = this.descriptor.getStringProperty("userHeader");
        if (userHeader != null && userHeader.trim().length() == 0) {
            userHeader = null;
        }
        return userHeader;
    }

    public void setConnectorSession(ConnectorSession connectorSession) {
        super.setConnectorSession(connectorSession);
        connectorSession.setParameter("userHeader", this.getUserHeader());
    }

    protected void applyRequestHeaders(RemoteClient remoteClient, ConnectorContext context) {
        super.applyRequestHeaders(remoteClient, context);
        HashMap<String, String> headers = new HashMap<String, String>(8);
        if (context != null) {
            headers.putAll(context.getHeaders());
        }
        if (this.getCredentials() != null) {
            String userHeader;
            String user = (String)this.getCredentials().getProperty("cleartextUsername");
            String pass = (String)this.getCredentials().getProperty("cleartextPassword");
            if (pass == null) {
                headers.put("X-Alfresco-Remote-User", user);
            }
            if ((userHeader = this.getUserHeader()) != null) {
                headers.put(userHeader, user);
            }
        }
        if (headers.size() != 0) {
            remoteClient.setRequestProperties(headers);
        }
    }
}

