/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.ClientProperties;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.AbstractXmlConfigHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private static class SpringXmlBuilder
    extends AbstractXmlConfigHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;
        private ManagedList members;
        private BeanDefinitionBuilder propertiesBuilder;

        public SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class);
            this.builder.setFactoryMethod("newHazelcastClient");
            this.builder.setDestroyMethodName("shutdown");
            this.members = new ManagedList();
            this.propertiesBuilder = BeanDefinitionBuilder.rootBeanDefinition(ClientProperties.class);
            AbstractBeanDefinition beanDefinition = this.propertiesBuilder.getBeanDefinition();
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, "client-properties");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handle(Element element) {
            ManagedMap properties = new ManagedMap();
            NamedNodeMap atts = element.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("group-name".equals(name)) {
                        name = ClientProperties.ClientPropertyName.GROUP_NAME.getName();
                    } else {
                        if (!"group-password".equals(name)) continue;
                        name = ClientProperties.ClientPropertyName.GROUP_PASSWORD.getName();
                    }
                    properties.put((Object)name, (Object)value);
                }
            }
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList((Node)element, 1)) {
                String nodeName = SpringXmlBuilder.cleanNodeName((String)node.getNodeName());
                if ("members".equals(nodeName)) {
                    this.members.add((Object)this.getValue(node));
                    continue;
                }
                if (!"client-properties".equals(nodeName)) continue;
                for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                    String name = SpringXmlBuilder.cleanNodeName((String)n.getNodeName());
                    if (!"client-property".equals(name)) continue;
                    String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                    String value = this.getValue(n);
                    properties.put((Object)propertyName, (Object)value);
                }
            }
            this.propertiesBuilder.addPropertyValue("properties", (Object)properties);
            this.builder.addConstructorArgValue((Object)this.propertiesBuilder.getBeanDefinition());
            this.builder.addConstructorArgValue((Object)this.members);
        }
    }
}

