/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.abdera.ext.CMISAccessControlEntry;
import org.apache.chemistry.abdera.ext.CMISConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISAccessControlList
extends ExtensibleElementWrapper {
    public CMISAccessControlList(Element internal) {
        super(internal);
    }

    public CMISAccessControlList(Factory factory) {
        super(factory, CMISConstants.ACCESS_CONTROL_LIST);
    }

    public List<CMISAccessControlEntry> getEntries() {
        List children = this.getElements();
        ArrayList<CMISAccessControlEntry> entries = new ArrayList<CMISAccessControlEntry>(children.size());
        for (Element child : children) {
            if (!(child instanceof CMISAccessControlEntry)) continue;
            entries.add((CMISAccessControlEntry)child);
        }
        return entries;
    }

    public Set<List<Object>> getHashedEntries() {
        List<CMISAccessControlEntry> entries = this.getEntries();
        HashSet<List<Object>> hashSet = new HashSet<List<Object>>(entries.size() * 2);
        for (CMISAccessControlEntry accessControlEntry : entries) {
            String principalId = accessControlEntry.getPrincipalId();
            Boolean direct = accessControlEntry.isDirect();
            for (String permission : accessControlEntry.getPermissions()) {
                ArrayList<Object> comparable = new ArrayList<Object>(3);
                comparable.add(principalId);
                comparable.add(direct);
                comparable.add(permission);
                hashSet.add(comparable);
            }
        }
        return hashSet;
    }
}

