/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.net;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.util.common.net.UriEncoder;
import com.google.gdata.util.httputil.FormUrlDecoder;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class UriParameterMap
extends ForwardingMultimap<String, String>
implements ListMultimap<String, String>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3053773769157973706L;
    public static final UriParameterMap EMPTY_MAP = new UriParameterMap((ListMultimap<String, String>)ImmutableMultimap.of());
    private final ListMultimap<String, String> delegate;

    private UriParameterMap(ListMultimap<String, String> delegate) {
        this.delegate = delegate;
    }

    public UriParameterMap() {
        this((ListMultimap<String, String>)LinkedListMultimap.create());
    }

    public static UriParameterMap parse(String query) {
        return UriParameterMap.parse(query, UriEncoder.DEFAULT_ENCODING);
    }

    public static UriParameterMap parse(String query, Charset encoding) {
        Preconditions.checkNotNull(query);
        UriParameterMap map = new UriParameterMap();
        map.merge(query, encoding);
        return map;
    }

    public static UriParameterMap unmodifiableMap(UriParameterMap map) {
        return new UriParameterMap((ListMultimap<String, String>)Multimaps.unmodifiableListMultimap(map.delegate()));
    }

    protected ListMultimap<String, String> delegate() {
        return this.delegate;
    }

    void merge(String query, Charset encoding) {
        Preconditions.checkNotNull(query);
        Preconditions.checkNotNull(encoding);
        FormUrlDecoder.parseWithCallback(query, encoding.name(), new FormUrlDecoder.Callback(){

            @Override
            public void handleParameter(String name, String value) {
                UriParameterMap.this.put(name, value);
            }
        });
    }

    public String getFirst(String key) {
        Preconditions.checkNotNull(key);
        List<String> values = this.get(key);
        return values.isEmpty() ? null : values.get(0);
    }

    public void appendTo(StringBuilder out, Charset encoding) {
        try {
            this.appendTo((Appendable)out, encoding);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void appendTo(Appendable out, Charset encoding) throws IOException {
        Preconditions.checkNotNull(out);
        Iterator i = this.entries().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            out.append(UriEncoder.encode((String)entry.getKey(), encoding));
            if (!"".equals(entry.getValue())) {
                out.append("=");
                out.append(UriEncoder.encode((String)entry.getValue(), encoding));
            }
            if (!i.hasNext()) continue;
            out.append("&");
        }
    }

    public UriParameterMap clone() {
        LinkedListMultimap multimap = LinkedListMultimap.create(this.delegate());
        return new UriParameterMap((ListMultimap<String, String>)multimap);
    }

    public String toString(Charset encoding) {
        StringBuilder out = new StringBuilder();
        this.appendTo(out, encoding);
        return out.toString();
    }

    public Map<String, String[]> copyToArrayMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map delegateMap = this.delegate().asMap();
        for (Map.Entry entry : delegateMap.entrySet()) {
            Collection values = (Collection)entry.getValue();
            builder.put(entry.getKey(), (Object)values.toArray(new String[values.size()]));
        }
        return builder.build();
    }

    public String toString() {
        return this.toString(UriEncoder.DEFAULT_ENCODING);
    }

    public List<String> get(String key) {
        return this.delegate().get((Object)key);
    }

    public List<String> removeAll(Object key) {
        return this.delegate().removeAll(key);
    }

    public List<String> replaceValues(String key, Iterable<? extends String> values) {
        return this.delegate().replaceValues((Object)key, values);
    }
}

