/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.Adjustments;
import com.google.api.gbase.client.GoogleBaseAttributeId;
import com.google.api.gbase.client.GoogleBaseAttributeType;
import com.google.api.gbase.client.Thumbnail;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GoogleBaseAttribute {
    private final GoogleBaseAttributeId attributeId;
    private String textValue;
    private Multimap<String, String> subElements;
    private List<GoogleBaseAttribute> subAttributes;
    private boolean privateAccess;
    private Adjustments adjustments;
    private List<Thumbnail> thumbnails;

    public GoogleBaseAttribute(String name) {
        this(new GoogleBaseAttributeId(name, null), null);
    }

    public GoogleBaseAttribute(String name, GoogleBaseAttributeType type) {
        this(name, type, null);
    }

    public GoogleBaseAttribute(String name, GoogleBaseAttributeType type, String textValue) {
        this(new GoogleBaseAttributeId(name, type), textValue);
    }

    public GoogleBaseAttribute(String name, GoogleBaseAttributeType type, boolean privateAccess) {
        this(name, type, privateAccess, null);
    }

    public GoogleBaseAttribute(String name, GoogleBaseAttributeType type, boolean privateAccess, String textValue) {
        this(new GoogleBaseAttributeId(name, type), textValue);
        this.setPrivate(privateAccess);
    }

    public GoogleBaseAttribute(GoogleBaseAttributeId attributeId, String textValue) {
        this.attributeId = attributeId;
        this.textValue = textValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.attributeId);
        buf.append(": ");
        if (this.hasValue()) {
            buf.append(this.textValue);
        }
        if (this.hasSubElements()) {
            buf.append(this.subElements.toString());
        }
        if (this.hasSubAttributes()) {
            buf.append(this.subAttributes.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public String getName() {
        return this.attributeId.getName();
    }

    public GoogleBaseAttributeType getType() {
        return this.attributeId.getType();
    }

    public GoogleBaseAttributeId getAttributeId() {
        return this.attributeId;
    }

    public String getValueAsString() {
        return this.textValue;
    }

    public boolean isPrivate() {
        return this.privateAccess;
    }

    public void setPrivate(boolean privateAccess) {
        this.privateAccess = privateAccess;
    }

    public void setValue(String value) {
        this.textValue = value;
    }

    public boolean hasValue() {
        return this.textValue != null;
    }

    public boolean hasSubElements() {
        return this.subElements != null && !this.subElements.isEmpty();
    }

    public void setSubElement(String name, String value) {
        this.removeSubElement(name);
        if (this.subElements == null) {
            this.subElements = HashMultimap.create();
        }
        this.subElements.put((Object)name, (Object)value);
    }

    public void appendSubElement(String name, String value) {
        if (value != null) {
            if (this.subElements == null) {
                this.subElements = HashMultimap.create();
            }
            this.subElements.put((Object)name, (Object)value);
        }
    }

    public String getSubElementValue(String name) {
        Collection elements;
        if (this.subElements != null && !(elements = this.subElements.get((Object)name)).isEmpty()) {
            return (String)elements.iterator().next();
        }
        return null;
    }

    public Collection<String> getSubElementValues(String name) {
        if (this.subElements == null) {
            return Collections.emptySet();
        }
        return this.subElements.get((Object)name);
    }

    public boolean hasSubElement(String name) {
        if (this.subElements == null) {
            return false;
        }
        return this.subElements.containsKey((Object)name);
    }

    public void removeSubElement(String name) {
        if (this.subElements != null) {
            this.subElements.removeAll((Object)name);
        }
    }

    public Collection<? extends String> getSubElementNames() {
        if (this.subElements == null) {
            return Collections.emptyList();
        }
        return this.subElements.keySet();
    }

    public boolean hasSubAttributes() {
        return this.subAttributes != null && !this.subAttributes.isEmpty();
    }

    public List<GoogleBaseAttribute> getSubAttributes() {
        if (this.subAttributes == null) {
            this.subAttributes = new ArrayList<GoogleBaseAttribute>();
        }
        return this.subAttributes;
    }

    public void addSubAttribute(GoogleBaseAttribute value) {
        this.getSubAttributes().add(value);
    }

    public boolean hasAdjustments() {
        return this.adjustments != null && !this.adjustments.isEmpty();
    }

    public Adjustments getAdjustments() {
        if (this.adjustments == null) {
            this.adjustments = new Adjustments();
        }
        return this.adjustments;
    }

    public boolean hasThumbnails() {
        return this.thumbnails != null && this.thumbnails.size() > 0;
    }

    public List<Thumbnail> getThumbnails() {
        if (this.thumbnails == null) {
            this.thumbnails = new ArrayList<Thumbnail>();
        }
        return this.thumbnails;
    }

    public int hashCode() {
        int retval = 27 + this.attributeId.hashCode();
        if (this.textValue != null) {
            retval += 49 * this.textValue.hashCode();
        }
        if (this.subElements != null) {
            retval += this.subElements.hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GoogleBaseAttribute)) {
            return false;
        }
        GoogleBaseAttribute other = (GoogleBaseAttribute)o;
        return this.attributeId.equals(other.attributeId) && this.privateAccess == other.privateAccess && GoogleBaseAttribute.equalsMaybeNull(this.textValue, other.textValue) && GoogleBaseAttribute.equalsMaybeNull(this.subElements, other.subElements);
    }

    private static boolean equalsMaybeNull(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

