/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.Adjustments;
import com.google.api.gbase.client.ConversionUtil;
import com.google.api.gbase.client.DateTimeRange;
import com.google.api.gbase.client.GoogleBaseAttribute;
import com.google.api.gbase.client.GoogleBaseAttributeType;
import com.google.api.gbase.client.GoogleBaseNamespaces;
import com.google.api.gbase.client.Group;
import com.google.api.gbase.client.Location;
import com.google.api.gbase.client.NumberUnit;
import com.google.api.gbase.client.Shipping;
import com.google.api.gbase.client.Tax;
import com.google.api.gbase.client.Thumbnail;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;

public class GoogleBaseAttributesExtension
implements Extension {
    public static final ExtensionDescription DESCRIPTION;
    public static final String LABEL_ATTRIBUTE = "label";
    public static final String ITEM_TYPE_ATTRIBUTE = "item type";
    public static final String EXPIRATION_DATE_ATTRIBUTE = "expiration date";
    public static final String IMAGE_LINK_ATTRIBUTE = "image link";
    public static final String PAYMENT_METHOD_ATTRIBUTE = "payment accepted";
    public static final String PRICE_ATTRIBUTE = "price";
    public static final String LOCATION_ATTRIBUTE = "location";
    public static final String PRICE_TYPE_ATTRIBUTE = "price type";
    public static final String QUANTITY_ATTRIBUTE = "quantity";
    public static final String PRICE_UNITS_ATTRIBUTE = "price units";
    public static final String SHIPPING_ATTRIBUTE = "shipping";
    public static final String TAX_ATTRIBUTE = "tax";
    @Deprecated
    public static final String TAX_PERCENT_ATTRIBUTE = "tax percent";
    @Deprecated
    public static final String TAX_REGION_ATTRIBUTE = "tax region";
    public static final String DELIVERY_RADIUS_ATTRIBUTE = "delivery radius";
    public static final String PICKUP_ATTRIBUTE = "pickup";
    public static final String DELIVERY_NOTES_ATTRIBUTE = "delivery notes";
    public static final String PAYMENT_NOTES_ATTRIBUTE = "payment notes";
    public static final String APPLICATION_ATTRIBUTE = "application";
    public static final String CUSTOMER_ID = "customer id";
    static final String GM_ADJUSTED_NAME_ATTRIBUTE = "adjusted_name";
    static final String GM_ADJUSTED_VALUE_ATTRIBUTE = "adjusted_value";
    static final String GM_THUMBNAIL_ATTRIBUTE = "thumbnail";
    private final List<GoogleBaseAttribute> attributes = new ArrayList<GoogleBaseAttribute>();

    public Collection<? extends String> getLabels() {
        return this.getTextAttributeValues(LABEL_ATTRIBUTE);
    }

    public void addLabel(String value) {
        this.addTextAttribute(LABEL_ATTRIBUTE, value);
    }

    public String getItemType() {
        return this.getTextAttribute(ITEM_TYPE_ATTRIBUTE);
    }

    public void setItemType(String value) {
        this.removeAttributes(ITEM_TYPE_ATTRIBUTE, GoogleBaseAttributeType.TEXT);
        this.addTextAttribute(ITEM_TYPE_ATTRIBUTE, value);
    }

    public DateTime getExpirationDate() {
        return this.getDateTimeAttribute(EXPIRATION_DATE_ATTRIBUTE);
    }

    public void setExpirationDate(DateTime date) {
        this.removeAttributes(EXPIRATION_DATE_ATTRIBUTE, GoogleBaseAttributeType.DATE_TIME);
        this.addDateTimeAttribute(EXPIRATION_DATE_ATTRIBUTE, date);
    }

    public String getImageLink() {
        return this.getUrlAttribute(IMAGE_LINK_ATTRIBUTE);
    }

    public List<? extends String> getImageLinks() {
        return this.getAttributeValuesAsString(IMAGE_LINK_ATTRIBUTE, GoogleBaseAttributeType.URL);
    }

    public void addImageLink(String link) {
        this.addUrlAttribute(IMAGE_LINK_ATTRIBUTE, link);
    }

    public Collection<? extends String> getPaymentMethods() {
        return this.getTextAttributeValues(PAYMENT_METHOD_ATTRIBUTE);
    }

    public void addPaymentMethod(String method) {
        this.addTextAttribute(PAYMENT_METHOD_ATTRIBUTE, method);
    }

    public NumberUnit<Float> getPrice() {
        return this.getFloatUnitAttribute(PRICE_ATTRIBUTE);
    }

    public void setPrice(NumberUnit<Float> value) {
        this.removeAttributes(PRICE_ATTRIBUTE);
        this.addFloatUnitAttribute(PRICE_ATTRIBUTE, value);
    }

    public void setPrice(float value, String currency) {
        this.setPrice(new NumberUnit<Float>(Float.valueOf(value), currency));
    }

    public String getLocation() {
        return this.getLocationAttribute(LOCATION_ATTRIBUTE);
    }

    public void setLocation(String value) {
        this.removeAttributes(LOCATION_ATTRIBUTE);
        this.addLocationAttribute(LOCATION_ATTRIBUTE, value);
    }

    public void setPriceType(String type) {
        this.removeAttributes(PRICE_TYPE_ATTRIBUTE);
        this.addTextAttribute(PRICE_TYPE_ATTRIBUTE, type);
    }

    public String getPriceType() {
        return this.getTextAttribute(PRICE_TYPE_ATTRIBUTE);
    }

    public void setQuantity(int value) {
        this.removeAttributes(QUANTITY_ATTRIBUTE);
        this.addIntAttribute(QUANTITY_ATTRIBUTE, value);
    }

    public Integer getQuantity() {
        return this.getIntAttribute(QUANTITY_ATTRIBUTE);
    }

    public void setPriceUnits(String value) {
        this.removeAttributes(PRICE_UNITS_ATTRIBUTE);
        this.addTextAttribute(PRICE_UNITS_ATTRIBUTE, value);
    }

    public String getPriceUnits() {
        return this.getTextAttribute(PRICE_UNITS_ATTRIBUTE);
    }

    public void addShipping(Shipping shipping) {
        this.addShippingAttribute(SHIPPING_ATTRIBUTE, shipping);
    }

    public Collection<? extends Shipping> getShipping() {
        return this.getShippingAttributes(SHIPPING_ATTRIBUTE);
    }

    public void addTax(Tax tax) {
        this.addTaxAttribute(TAX_ATTRIBUTE, tax);
    }

    public Collection<? extends Tax> getTax() {
        return this.getTaxAttributes(TAX_ATTRIBUTE);
    }

    @Deprecated
    public void setTaxPercent(float taxPercent) {
        this.removeAttributes(TAX_PERCENT_ATTRIBUTE);
        this.addFloatAttribute(TAX_PERCENT_ATTRIBUTE, taxPercent);
    }

    @Deprecated
    public Float getTaxPercent() {
        return this.getFloatAttribute(TAX_PERCENT_ATTRIBUTE);
    }

    @Deprecated
    public void setTaxRegion(String region) {
        this.removeAttributes(TAX_REGION_ATTRIBUTE);
        this.addTextAttribute(TAX_REGION_ATTRIBUTE, region);
    }

    @Deprecated
    public String getTaxRegion() {
        return this.getTextAttribute(TAX_REGION_ATTRIBUTE);
    }

    public void setDeliveryRadius(float value, String unit) {
        this.setDeliveryRadius(new NumberUnit<Float>(Float.valueOf(value), unit));
    }

    public void setDeliveryRadius(NumberUnit<Float> value) {
        this.removeAttributes(DELIVERY_RADIUS_ATTRIBUTE);
        this.addFloatUnitAttribute(DELIVERY_RADIUS_ATTRIBUTE, value);
    }

    public NumberUnit<Float> getDeliveryRadius() {
        return this.getFloatUnitAttribute(DELIVERY_RADIUS_ATTRIBUTE);
    }

    public void setPickup(boolean pickup) {
        this.removeAttributes(PICKUP_ATTRIBUTE, GoogleBaseAttributeType.BOOLEAN);
        this.addBooleanAttribute(PICKUP_ATTRIBUTE, pickup);
    }

    public Boolean getPickup() {
        return this.getBooleanAttribute(PICKUP_ATTRIBUTE);
    }

    public void setDeliveryNotes(String notes) {
        this.removeAttributes(DELIVERY_NOTES_ATTRIBUTE, GoogleBaseAttributeType.TEXT);
        this.addTextAttribute(DELIVERY_NOTES_ATTRIBUTE, notes);
    }

    public String getDeliveryNotes() {
        return this.getTextAttribute(DELIVERY_NOTES_ATTRIBUTE);
    }

    public void setPaymentNotes(String notes) {
        this.removeAttributes(PAYMENT_NOTES_ATTRIBUTE, GoogleBaseAttributeType.TEXT);
        this.addTextAttribute(PAYMENT_NOTES_ATTRIBUTE, notes);
    }

    public String getPaymentNotes() {
        return this.getTextAttribute(PAYMENT_NOTES_ATTRIBUTE);
    }

    public Integer getCustomerId() {
        return this.getIntAttribute(CUSTOMER_ID);
    }

    public List<? extends GoogleBaseAttribute> getAttributes() {
        return this.attributes;
    }

    public GoogleBaseAttribute getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public GoogleBaseAttribute getAttribute(String name, GoogleBaseAttributeType type) {
        for (GoogleBaseAttribute attr : this.attributes) {
            if (!this.hasNameAndType(attr, name, type)) continue;
            return attr;
        }
        return null;
    }

    private boolean hasNameAndType(GoogleBaseAttribute attr, String name, GoogleBaseAttributeType type) {
        GoogleBaseAttributeType subtype = attr.getAttributeId().getType();
        return name.equals(attr.getAttributeId().getName()) && (type == null || subtype != null && type.isSupertypeOf(subtype));
    }

    public List<? extends GoogleBaseAttribute> getAttributes(String name, GoogleBaseAttributeType type) {
        ArrayList<GoogleBaseAttribute> retval = new ArrayList<GoogleBaseAttribute>();
        for (GoogleBaseAttribute attr : this.attributes) {
            if (!this.hasNameAndType(attr, name, type)) continue;
            retval.add(attr);
        }
        return retval;
    }

    public List<? extends GoogleBaseAttribute> getAttributes(String name) {
        return this.getAttributes(name, null);
    }

    public GoogleBaseAttribute addAttribute(GoogleBaseAttribute attribute) {
        this.attributes.add(attribute);
        return attribute;
    }

    public void removeAttribute(GoogleBaseAttribute value) {
        this.attributes.remove(value);
    }

    public void removeAttributes(String name) {
        this.removeAttributes(name, null);
    }

    public void removeAttributes(String name, GoogleBaseAttributeType type) {
        Iterator<GoogleBaseAttribute> iter = this.attributes.iterator();
        while (iter.hasNext()) {
            GoogleBaseAttribute attribute = iter.next();
            if (!this.hasNameAndType(attribute, name, type)) continue;
            iter.remove();
        }
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public String getTextAttribute(String name) {
        return this.getAttributeAsString(name, GoogleBaseAttributeType.TEXT);
    }

    public String getReferenceAttribute(String name) {
        return this.getAttributeAsString(name, GoogleBaseAttributeType.REFERENCE);
    }

    private String getAttributeAsString(String name, GoogleBaseAttributeType type) {
        GoogleBaseAttribute attribute = this.getAttribute(name, type);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsString();
    }

    public List<String> getTextAttributeValues(String attributeName) {
        return this.getAttributeValuesAsString(attributeName, GoogleBaseAttributeType.TEXT);
    }

    private List<String> getAttributeValuesAsString(String name, GoogleBaseAttributeType type) {
        List<? extends GoogleBaseAttribute> labels = this.getAttributes(name, type);
        ArrayList<String> retval = new ArrayList<String>(labels.size());
        for (GoogleBaseAttribute googleBaseAttribute : labels) {
            retval.add(googleBaseAttribute.getValueAsString());
        }
        return retval;
    }

    public Float getFloatAttribute(String name) {
        return ConversionUtil.toFloat(this.getAttributeAsString(name, GoogleBaseAttributeType.FLOAT));
    }

    public Integer getIntAttribute(String name) {
        return ConversionUtil.toInteger(this.getAttributeAsString(name, GoogleBaseAttributeType.INT));
    }

    public Number getNumberAttribute(String name) {
        GoogleBaseAttribute attr = this.getAttribute(name, GoogleBaseAttributeType.NUMBER);
        return ConversionUtil.extractNumber(attr);
    }

    public Boolean getBooleanAttribute(String name) {
        return ConversionUtil.toBoolean(this.getAttributeAsString(name, GoogleBaseAttributeType.BOOLEAN));
    }

    public DateTime getDateTimeAttribute(String name) {
        return ConversionUtil.toDateOrDateTime(this.getAttributeAsString(name, GoogleBaseAttributeType.DATE_TIME));
    }

    public DateTime getDateAttribute(String name) {
        return ConversionUtil.toDateOrDateTime(this.getAttributeAsString(name, GoogleBaseAttributeType.DATE));
    }

    public DateTimeRange getDateRangeAttribute(String name) {
        GoogleBaseAttribute attribute = this.getAttribute(name, GoogleBaseAttributeType.DATE_TIME_RANGE);
        return ConversionUtil.extractDateTimeRange(attribute);
    }

    public String getUrlAttribute(String name) {
        return this.getAttributeAsString(name, GoogleBaseAttributeType.URL);
    }

    public NumberUnit<Integer> getIntUnitAttribute(String name) {
        return ConversionUtil.toIntUnit(this.getAttributeAsString(name, GoogleBaseAttributeType.INT_UNIT));
    }

    public NumberUnit<Float> getFloatUnitAttribute(String name) {
        return ConversionUtil.toFloatUnit(this.getAttributeAsString(name, GoogleBaseAttributeType.FLOAT_UNIT));
    }

    public NumberUnit<? extends Number> getNumberUnitAttribute(String name) {
        return ConversionUtil.extractNumberUnit(this.getAttribute(name, GoogleBaseAttributeType.NUMBER_UNIT));
    }

    public GoogleBaseAttribute addTextAttribute(String name, String value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.TEXT, value));
    }

    public GoogleBaseAttribute addReferenceAttribute(String name, String value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.REFERENCE, value));
    }

    public GoogleBaseAttribute addIntAttribute(String name, int value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.INT, Integer.toString(value)));
    }

    public GoogleBaseAttribute addFloatAttribute(String name, float value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.FLOAT, Float.toString(value)));
    }

    public GoogleBaseAttribute addNumberAttribute(String name, Number value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.NUMBER, value.toString()));
    }

    public GoogleBaseAttribute addIntUnitAttribute(String name, int value, String unit) {
        return this.addIntUnitAttribute(name, new NumberUnit<Integer>(value, unit));
    }

    public GoogleBaseAttribute addIntUnitAttribute(String name, NumberUnit<Integer> value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.INT_UNIT, value.toString()));
    }

    public GoogleBaseAttribute addFloatUnitAttribute(String name, float value, String unit) {
        return this.addFloatUnitAttribute(name, new NumberUnit<Float>(Float.valueOf(value), unit));
    }

    public GoogleBaseAttribute addFloatUnitAttribute(String name, NumberUnit<Float> value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.FLOAT_UNIT, value.toString()));
    }

    public GoogleBaseAttribute addNumberUnitAttribute(String name, Number value, String unit) {
        return this.addNumberUnitAttribute(name, new NumberUnit<Number>(value, unit));
    }

    public GoogleBaseAttribute addNumberUnitAttribute(String name, NumberUnit<Number> value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.NUMBER_UNIT, value.toString()));
    }

    public GoogleBaseAttribute addDateAttribute(String name, DateTime date) {
        if (!date.isDateOnly()) {
            throw new IllegalArgumentException("DateTime should be only a date, NOT a date and a time. Call addDateTimeAttribute() instead.");
        }
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.DATE, date.toString()));
    }

    public GoogleBaseAttribute addDateTimeAttribute(String name, DateTime dateTime) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.DATE_TIME, dateTime.toString()));
    }

    public GoogleBaseAttribute addUrlAttribute(String name, String value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.URL, value));
    }

    public GoogleBaseAttribute addBooleanAttribute(String name, boolean value) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.BOOLEAN, Boolean.toString(value)));
    }

    public void addGroupAttribute(String groupName, Group group) {
        this.addAttribute(ConversionUtil.createAttribute(groupName, group));
    }

    public Group getGroupAttribute(String name) {
        GoogleBaseAttribute value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        return ConversionUtil.extractGroup(value);
    }

    public Collection<? extends Group> getGroupAttributes(String groupName) {
        ArrayList<Group> retval = new ArrayList<Group>();
        for (GoogleBaseAttribute attr : this.attributes) {
            if (!this.hasNameAndType(attr, groupName, GoogleBaseAttributeType.GROUP)) continue;
            retval.add(ConversionUtil.extractGroup(attr));
        }
        return retval;
    }

    public Shipping getShippingAttribute(String name) {
        GoogleBaseAttribute value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        return ConversionUtil.extractShipping(value);
    }

    public List<? extends Shipping> getShippingAttributes(String name) {
        ArrayList<Shipping> retval = new ArrayList<Shipping>();
        for (GoogleBaseAttribute attr : this.attributes) {
            if (!this.hasNameAndType(attr, name, GoogleBaseAttributeType.SHIPPING)) continue;
            retval.add(ConversionUtil.extractShipping(attr));
        }
        return retval;
    }

    public void addShippingAttribute(String name, Shipping shipping) {
        this.addAttribute(ConversionUtil.createAttribute(name, shipping));
    }

    public Tax getTaxAttribute(String name) {
        GoogleBaseAttribute value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        return ConversionUtil.extractTax(value);
    }

    public List<? extends Tax> getTaxAttributes(String name) {
        ArrayList<Tax> retval = new ArrayList<Tax>();
        for (GoogleBaseAttribute attr : this.attributes) {
            if (!this.hasNameAndType(attr, name, GoogleBaseAttributeType.TAX)) continue;
            retval.add(ConversionUtil.extractTax(attr));
        }
        return retval;
    }

    public void addTaxAttribute(String name, Tax tax) {
        this.addAttribute(ConversionUtil.createAttribute(name, tax));
    }

    public String getLocationAttribute(String name) {
        return this.getAttributeAsString(name, GoogleBaseAttributeType.LOCATION);
    }

    public Location getLocationAttributeAsObject(String name) {
        GoogleBaseAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        return ConversionUtil.extractLocation(attribute);
    }

    public List<? extends String> getLocationAttributes(String name) {
        return this.getAttributeValuesAsString(name, GoogleBaseAttributeType.LOCATION);
    }

    public List<Location> getLocationAttributesAsObjects(String name) {
        List<? extends GoogleBaseAttribute> attributes = this.getAttributes(name, GoogleBaseAttributeType.LOCATION);
        ArrayList<Location> retval = new ArrayList<Location>(attributes.size());
        for (GoogleBaseAttribute googleBaseAttribute : attributes) {
            retval.add(ConversionUtil.extractLocation(googleBaseAttribute));
        }
        return retval;
    }

    public GoogleBaseAttribute addLocationAttribute(String name, String location) {
        return this.addAttribute(new GoogleBaseAttribute(name, GoogleBaseAttributeType.LOCATION, location));
    }

    public GoogleBaseAttribute addLocationAttribute(String name, Location location) {
        return this.addAttribute(ConversionUtil.createAttribute(name, location));
    }

    public DateTimeRange getDateTimeRangeAttribute(String name) {
        GoogleBaseAttribute value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        return ConversionUtil.extractDateTimeRange(value);
    }

    public List<? extends DateTimeRange> getDateTimeRangeAttributes(String name) {
        ArrayList<DateTimeRange> retval = new ArrayList<DateTimeRange>();
        for (GoogleBaseAttribute attr : this.attributes) {
            if (!this.hasNameAndType(attr, name, GoogleBaseAttributeType.DATE_TIME_RANGE)) continue;
            retval.add(ConversionUtil.extractDateTimeRange(attr));
        }
        return retval;
    }

    public GoogleBaseAttribute addDateTimeRangeAttribute(String name, DateTimeRange dateTimeRange) {
        if (dateTimeRange.isDateTimeOnly()) {
            throw new IllegalArgumentException("Empty DateTimeRange. Add it as a single DateTime using addDateTimeAttribute() instead.");
        }
        return this.addAttribute(ConversionUtil.createAttribute(name, dateTimeRange));
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        for (GoogleBaseAttribute attribute : this.attributes) {
            this.generateAttribute(attribute, xmlWriter);
        }
    }

    private void generateAttribute(GoogleBaseAttribute attribute, XmlWriter xmlWriter) throws IOException {
        String elementName = this.convertToElementName(attribute.getAttributeId().getName());
        xmlWriter.startElement((XmlNamespace)GoogleBaseNamespaces.G, elementName, this.getXmlAttributes(attribute), null);
        this.generateValue(attribute, xmlWriter);
        this.generateSubElements(attribute, xmlWriter);
        this.generateAdjustments(attribute, xmlWriter);
        this.generateSubAttributes(attribute, xmlWriter);
        xmlWriter.endElement();
    }

    private void generateValue(GoogleBaseAttribute attribute, XmlWriter xmlWriter) throws IOException {
        if (attribute.hasValue()) {
            xmlWriter.characters(attribute.getValueAsString());
        }
    }

    private void generateSubElements(GoogleBaseAttribute attribute, XmlWriter xmlWriter) throws IOException {
        if (attribute.hasSubElements()) {
            for (String string : attribute.getSubElementNames()) {
                for (String element : attribute.getSubElementValues(string)) {
                    this.writeXmlNameValue(xmlWriter, GoogleBaseNamespaces.G, string, element);
                }
            }
        }
    }

    private void generateSubAttributes(GoogleBaseAttribute attribute, XmlWriter xmlWriter) throws IOException {
        if (attribute.hasSubAttributes()) {
            for (GoogleBaseAttribute element : attribute.getSubAttributes()) {
                this.generateAttribute(element, xmlWriter);
            }
        }
    }

    private void generateAdjustments(GoogleBaseAttribute attribute, XmlWriter xmlWriter) throws IOException {
        if (attribute.hasAdjustments()) {
            Adjustments adjustments = attribute.getAdjustments();
            if (adjustments.getName() != null) {
                this.writeXmlNameValue(xmlWriter, GoogleBaseNamespaces.GM, GM_ADJUSTED_NAME_ATTRIBUTE, adjustments.getName());
            }
            if (adjustments.getValue() != null) {
                this.writeXmlNameValue(xmlWriter, GoogleBaseNamespaces.GM, GM_ADJUSTED_VALUE_ATTRIBUTE, adjustments.getValue());
            }
        }
    }

    private void writeXmlNameValue(XmlWriter xmlWriter, XmlWriter.Namespace namespace, String name, String value) throws IOException {
        xmlWriter.startElement((XmlNamespace)namespace, this.convertToElementName(name), null, null);
        xmlWriter.characters(value);
        xmlWriter.endElement();
    }

    private String convertToElementName(String attributeName) {
        return attributeName.replace(' ', '_');
    }

    private String convertToAttributeName(String localName) {
        return localName.replace('_', ' ');
    }

    private Collection<XmlWriter.Attribute> getXmlAttributes(GoogleBaseAttribute attribute) {
        GoogleBaseAttributeType type = attribute.getAttributeId().getType();
        if (type == null) {
            return null;
        }
        ArrayList<XmlWriter.Attribute> attributes = new ArrayList<XmlWriter.Attribute>();
        attributes.add(new XmlWriter.Attribute("type", type.toString()));
        if (attribute.isPrivate()) {
            attributes.add(new XmlWriter.Attribute("access", "private"));
        }
        return attributes;
    }

    private GoogleBaseAttribute createExtensionAttribute(String attributeName, Attributes xmlAttributes) {
        String type = xmlAttributes.getValue("type");
        String access = xmlAttributes.getValue("access");
        boolean privateAccess = "private".equals(access);
        return new GoogleBaseAttribute(attributeName, GoogleBaseAttributeType.getInstance(type), privateAccess);
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String uri, String localName, Attributes attributes) throws ParseException, IOException {
        return new Handler(localName, attributes);
    }

    public String getApplication() {
        return this.getTextAttribute(APPLICATION_ATTRIBUTE);
    }

    public void setApplication(String name) {
        this.removeAttributes(APPLICATION_ATTRIBUTE, GoogleBaseAttributeType.TEXT);
        this.addTextAttribute(APPLICATION_ATTRIBUTE, name);
    }

    static {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(GoogleBaseAttributesExtension.class);
        desc.setNamespace((XmlNamespace)GoogleBaseNamespaces.G);
        desc.setLocalName("*");
        desc.setRepeatable(false);
        desc.setAggregate(true);
        DESCRIPTION = desc;
    }

    private class GroupSubAttrHandler
    extends XmlParser.ElementHandler {
        private final GoogleBaseAttribute attribute;

        GroupSubAttrHandler(String localName, Attributes xmlAttributes) {
            String attributeName = GoogleBaseAttributesExtension.this.convertToAttributeName(localName);
            this.attribute = GoogleBaseAttributesExtension.this.createExtensionAttribute(attributeName, xmlAttributes);
            ((GoogleBaseAttribute)GoogleBaseAttributesExtension.this.attributes.get(GoogleBaseAttributesExtension.this.attributes.size() - 1)).addSubAttribute(this.attribute);
        }

        public void processEndElement() {
            if (this.value != null) {
                this.attribute.setValue(this.value);
            }
        }

        public XmlParser.ElementHandler getChildHandler(final String uri, final String localName, Attributes attrs) {
            return new XmlParser.ElementHandler(){

                public void processEndElement() {
                    if ("http://base.google.com/ns-metadata/1.0".equals(uri)) {
                        if (GoogleBaseAttributesExtension.GM_ADJUSTED_VALUE_ATTRIBUTE.equals(localName)) {
                            GroupSubAttrHandler.this.attribute.getAdjustments().setValue(this.value);
                        } else if (GoogleBaseAttributesExtension.GM_ADJUSTED_NAME_ATTRIBUTE.equals(localName)) {
                            GroupSubAttrHandler.this.attribute.getAdjustments().setName(this.value);
                        }
                    } else {
                        GroupSubAttrHandler.this.attribute.appendSubElement(localName, this.value);
                    }
                }
            };
        }
    }

    private class Handler
    extends XmlParser.ElementHandler {
        private final GoogleBaseAttribute attribute;

        Handler(String localName, Attributes xmlAttributes) {
            String attributeName = GoogleBaseAttributesExtension.this.convertToAttributeName(localName);
            this.attribute = GoogleBaseAttributesExtension.this.createExtensionAttribute(attributeName, xmlAttributes);
            GoogleBaseAttributesExtension.this.attributes.add(this.attribute);
        }

        public void processEndElement() throws ParseException {
            if (this.value != null) {
                this.attribute.setValue(this.value);
            }
        }

        public XmlParser.ElementHandler getChildHandler(final String uri, final String localName, Attributes attrs) {
            GoogleBaseAttributeType type = this.attribute.getType();
            if (type != null && GoogleBaseAttributeType.GROUP.isSupertypeOf(type)) {
                return new GroupSubAttrHandler(localName, attrs);
            }
            return new XmlParser.ElementHandler(){
                private int width = -1;
                private int height = -1;

                public void processEndElement() {
                    if ("http://base.google.com/ns-metadata/1.0".equals(uri)) {
                        if (GoogleBaseAttributesExtension.GM_ADJUSTED_VALUE_ATTRIBUTE.equals(localName)) {
                            Handler.this.attribute.getAdjustments().setValue(this.value);
                        } else if (GoogleBaseAttributesExtension.GM_ADJUSTED_NAME_ATTRIBUTE.equals(localName)) {
                            Handler.this.attribute.getAdjustments().setName(this.value);
                        } else if (GoogleBaseAttributesExtension.GM_THUMBNAIL_ATTRIBUTE.equals(localName)) {
                            Thumbnail thumbnail = new Thumbnail();
                            thumbnail.setUrl(this.value.trim());
                            if (this.width > 0 && this.height > 0) {
                                thumbnail.setSize(this.width, this.height);
                            }
                            Handler.this.attribute.getThumbnails().add(thumbnail);
                        }
                    } else {
                        Handler.this.attribute.appendSubElement(localName, this.value);
                    }
                }

                public void processAttribute(String namespace, String localName2, String value) throws ParseException {
                    if ("width".equals(localName2)) {
                        this.width = this.parseInteger(value);
                    } else if ("height".equals(localName2)) {
                        this.height = this.parseInteger(value);
                    }
                }

                private int parseInteger(String value) throws ParseException {
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("Invalid size value '" + value + "'", (Throwable)nfe);
                    }
                }
            };
        }
    }
}

