/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.GoogleBaseAttribute;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;

public class Group {
    private Multimap<String, GoogleBaseAttribute> subAttributes = HashMultimap.create();

    public Group(Collection<GoogleBaseAttribute> subAttributes) {
        for (GoogleBaseAttribute attr : subAttributes) {
            this.subAttributes.put((Object)attr.getName(), (Object)attr);
        }
    }

    public GoogleBaseAttribute getSubAttribute(String name) {
        Collection attrs;
        if (this.subAttributes.containsKey((Object)name) && !(attrs = this.subAttributes.get((Object)name)).isEmpty()) {
            return (GoogleBaseAttribute)this.subAttributes.get((Object)name).iterator().next();
        }
        return null;
    }

    public Collection<? extends GoogleBaseAttribute> getSubAttributes(String name) {
        if (this.subAttributes.containsKey((Object)name)) {
            return this.subAttributes.get((Object)name);
        }
        return Collections.emptySet();
    }

    public Multimap<String, GoogleBaseAttribute> getAllSubAttributes() {
        return HashMultimap.create(this.subAttributes);
    }

    public int subAttributesSize() {
        return this.subAttributes.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (String key : this.subAttributes.keySet()) {
            Collection attrs = this.subAttributes.get((Object)key);
            for (GoogleBaseAttribute attr : attrs) {
                builder.append(key).append("(").append(attr.getType()).append("): ").append(attr.getValueAsString()).append(", ");
            }
        }
        builder.delete(builder.length() - 2, builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }
}

