/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.GoogleBaseNamespaces;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

@ExtensionDescription.Default(nsAlias="gm", nsUri="http://base.google.com/ns-metadata/1.0", localName="stats")
public class Stats
implements Extension {
    private final Statistics impressions = new Statistics();
    private final Statistics clicks = new Statistics();
    private final Statistics pageViews = new Statistics();

    public Statistics getImpressions() {
        return this.impressions;
    }

    public Statistics getClicks() {
        return this.clicks;
    }

    public Statistics getPageViews() {
        return this.pageViews;
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        if (this.impressions.getTotal() == 0 && this.clicks.getTotal() == 0 && this.pageViews.getTotal() == 0) {
            return;
        }
        w.startElement((XmlNamespace)GoogleBaseNamespaces.GM, "stats", null, null);
        this.impressions.generate(w, "impressions");
        this.clicks.generate(w, "clicks");
        this.pageViews.generate(w, "page_views");
        w.endElement();
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException, IOException {
        this.impressions.clear();
        this.pageViews.clear();
        this.clicks.clear();
        return new XmlParser.ElementHandler(){

            public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
                if (localName.equals("impressions")) {
                    return new StatsSubElementHandler(Stats.this.impressions, attrs);
                }
                if (localName.equals("page_views")) {
                    return new StatsSubElementHandler(Stats.this.pageViews, attrs);
                }
                if (localName.equals("clicks")) {
                    return new StatsSubElementHandler(Stats.this.clicks, attrs);
                }
                return super.getChildHandler(namespace, localName, attrs);
            }
        };
    }

    private static class StatsSubElementHandler
    extends XmlParser.ElementHandler {
        private final Statistics stat;

        public StatsSubElementHandler(Statistics stat, Attributes attrs) throws ParseException {
            this.stat = stat;
            AttributeHelper helper = new AttributeHelper(attrs);
            stat.setTotal(helper.consumeInteger("total", false, 0));
            helper.assertAllConsumed();
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if ("http://base.google.com/ns-metadata/1.0".equals(namespace) && "source".equals(localName)) {
                AttributeHelper helper = new AttributeHelper(attrs);
                this.stat.setCountBySource(helper.consume("name", true), helper.consumeInteger("count", true));
                helper.assertAllConsumed();
            }
            return new XmlParser.ElementHandler();
        }
    }

    public static class Statistics {
        private int total;
        private Map<String, Integer> countBySource;

        void clear() {
            this.total = 0;
            this.countBySource = null;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public Set<String> getSources() {
            if (this.countBySource == null) {
                return Collections.emptySet();
            }
            return this.countBySource.keySet();
        }

        public int getCountBySource(String source) {
            if (this.countBySource == null) {
                return -1;
            }
            Integer value = this.countBySource.get(source);
            if (value == null) {
                return -1;
            }
            return value;
        }

        public void setCountBySource(String source, int count) {
            if (count == -1) {
                if (this.countBySource != null) {
                    this.countBySource.remove(source);
                }
            } else {
                if (this.countBySource == null) {
                    this.countBySource = new HashMap<String, Integer>();
                }
                this.countBySource.put(source, count);
            }
        }

        private void generate(XmlWriter w, String name) throws IOException {
            if (this.total == 0) {
                return;
            }
            w.startElement((XmlNamespace)GoogleBaseNamespaces.GM, name, Collections.singletonList(new XmlWriter.Attribute("total", Integer.toString(this.total))), null);
            if (this.countBySource != null && !this.countBySource.isEmpty()) {
                w.startRepeatingElement();
                for (Map.Entry<String, Integer> entry : this.countBySource.entrySet()) {
                    ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(2);
                    attrs.add(new XmlWriter.Attribute("name", entry.getKey()));
                    attrs.add(new XmlWriter.Attribute("count", entry.getValue().toString()));
                    w.simpleElement((XmlNamespace)GoogleBaseNamespaces.GM, "source", attrs, null);
                }
                w.endRepeatingElement();
            }
            w.endElement();
        }
    }
}

