/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import com.sun.pdfview.FullScreenWindow;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FullScreenWindow {
    private static GraphicsDevice defaultScreen;
    private GraphicsDevice screen;
    private JFrame jf;
    private boolean dead = false;
    private Flag flag = new Flag();
    private GraphicsDevice pickedDevice;

    public FullScreenWindow(JComponent part, boolean forcechoice) {
        this.init(part, forcechoice);
    }

    public FullScreenWindow(JComponent part) {
        this.init(part, false);
    }

    public void close() {
        this.dead = true;
        this.flag.set();
        this.screen.setFullScreenWindow(null);
        if (this.jf != null) {
            this.jf.dispose();
        }
    }

    private void init(JComponent part, boolean forcechoice) {
        if (forcechoice) {
            defaultScreen = null;
        }
        this.screen = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        if (defaultScreen != null) {
            for (int i = 0; i < screens.length; ++i) {
                if (screens[i] != defaultScreen) continue;
                this.screen = defaultScreen;
            }
        }
        if (screens.length == 1) {
            this.screen = screens[0];
        }
        if (this.screen == null) {
            this.screen = this.pickScreen(screens);
        }
        if (this.dead) {
            return;
        }
        defaultScreen = this.screen;
        DisplayMode dm = this.screen.getDisplayMode();
        GraphicsConfiguration gc = this.screen.getDefaultConfiguration();
        this.jf = new JFrame(gc);
        this.jf.setUndecorated(true);
        this.jf.setBounds(gc.getBounds());
        this.jf.getContentPane().add(part);
        this.jf.setVisible(true);
        this.screen.setFullScreenWindow(this.jf);
    }

    private void pickDevice(GraphicsDevice gd) {
        this.pickedDevice = gd;
        this.flag.set();
    }

    private GraphicsDevice pickScreen(GraphicsDevice[] scrns) {
        int i;
        this.flag.clear();
        int count = 0;
        PickMe[] pickers = new PickMe[scrns.length];
        for (i = 0; i < scrns.length; ++i) {
            if (scrns[i].isFullScreenSupported()) {
                ++count;
            }
            pickers[i] = new PickMe(this, scrns[i]);
        }
        this.flag.waitForFlag();
        for (i = 0; i < pickers.length; ++i) {
            if (pickers[i] == null) continue;
            pickers[i].dispose();
        }
        return this.pickedDevice;
    }

    static /* synthetic */ void access$000(FullScreenWindow x0, GraphicsDevice x1) {
        x0.pickDevice(x1);
    }
}

