/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class PDFPrintPage
implements Printable {
    private PDFFile file;
    private PrinterJob pjob;
    private JDialog pd;
    private JLabel pagenumlabel;
    private JButton cancel;

    public PDFPrintPage(PDFFile file) {
        this.file = file;
    }

    public void printFile(String filename, boolean setupPaper) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        PDFFile pdfFile = new PDFFile(bb);
        PDFPrintPage pages = new PDFPrintPage(pdfFile);
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pfDefault = PrinterJob.getPrinterJob().defaultPage();
        Paper defaultPaper = new Paper();
        defaultPaper.setImageableArea(0.0, 0.0, defaultPaper.getWidth(), defaultPaper.getHeight());
        pfDefault.setPaper(defaultPaper);
        if (setupPaper) {
            pfDefault = PrinterJob.getPrinterJob().pageDialog(pfDefault);
        }
        pjob.setJobName(file.getName());
        if (pjob.printDialog()) {
            pfDefault = pjob.validatePage(pfDefault);
            Book book = new Book();
            book.append((Printable)pages, pfDefault, pdfFile.getNumPages());
            pjob.setPageable(book);
            try {
                pjob.print();
            }
            catch (PrinterException exc) {
                System.out.println(exc);
            }
        }
    }

    private void createPrintDialog() {
        this.pd = new JDialog((Frame)null, "Printing...", false);
        Container top = this.pd.getContentPane();
        Box lines = Box.createVerticalBox();
        Box line = Box.createHorizontalBox();
        line.add(new JLabel("Now printing: "));
        JLabel title = new JLabel("file.pdf");
        line.add(title);
        lines.add(line);
        line = Box.createHorizontalBox();
        line.add(Box.createHorizontalStrut(10));
        line.add(new JLabel("page "));
        this.pagenumlabel = new JLabel("1");
        line.add(this.pagenumlabel);
        line.add(new JLabel(" of "));
        JLabel totalpages = new JLabel(String.valueOf(this.file.getNumPages()));
        line.add(totalpages);
        lines.add(line);
        top.add((Component)lines, "Center");
        Box cancelbox = Box.createHorizontalBox();
        cancelbox.add(Box.createHorizontalGlue());
        this.cancel = new JButton((Action)new /* Unavailable Anonymous Inner Class!! */);
        cancelbox.add(this.cancel);
        top.add((Component)cancelbox, "South");
    }

    public void show(PrinterJob pjob) {
        this.pjob = pjob;
        if (this.pd == null) {
            this.createPrintDialog();
        }
        this.pd.pack();
        this.pd.setVisible(true);
    }

    public void hide() {
        this.pd.dispose();
    }

    public void doCancel() {
        this.cancel.setEnabled(false);
        this.pjob.cancel();
    }

    public int print(Graphics g, PageFormat format, int index) throws PrinterException {
        int pagenum = index + 1;
        if (pagenum >= 1 && pagenum <= this.file.getNumPages()) {
            int width;
            int height;
            if (this.pagenumlabel != null) {
                this.pagenumlabel.setText(String.valueOf(pagenum));
            }
            Graphics2D g2 = (Graphics2D)g;
            PDFPage page = this.file.getPage(pagenum);
            double pwidth = format.getImageableWidth();
            double pheight = format.getImageableHeight();
            double aspect = page.getAspectRatio();
            double paperaspect = pwidth / pheight;
            if (paperaspect < 1.0) {
                switch (format.getOrientation()) {
                    case 0: 
                    case 2: {
                        format.setOrientation(1);
                        break;
                    }
                    case 1: {
                        format.setOrientation(0);
                    }
                }
                pwidth = format.getImageableWidth();
                pheight = format.getImageableHeight();
                paperaspect = pwidth / pheight;
            }
            if (aspect > paperaspect) {
                height = (int)(pwidth / aspect);
                width = (int)pwidth;
            } else {
                width = (int)(pheight * aspect);
                height = (int)pheight;
            }
            Rectangle imgbounds = new Rectangle((int)format.getImageableX(), (int)format.getImageableY(), width, height);
            PDFRenderer pgs = new PDFRenderer(page, g2, imgbounds, null, null);
            try {
                page.waitForFinish();
                pgs.run();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return 0;
        }
        return 1;
    }
}

