/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import com.sun.pdfview.FullScreenWindow;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPrintPage;
import com.sun.pdfview.PDFViewer;
import com.sun.pdfview.PageChangeListener;
import com.sun.pdfview.PagePanel;
import com.sun.pdfview.ThumbPanel;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class PDFViewer
extends JFrame
implements KeyListener,
TreeSelectionListener,
PageChangeListener {
    public static final String TITLE = "SwingLabs PDF Viewer";
    PDFFile curFile;
    String docName;
    JSplitPane split;
    JScrollPane thumbscroll;
    ThumbPanel thumbs;
    PagePanel page;
    PagePanel fspp;
    int curpage = -1;
    JToggleButton fullScreenButton;
    JTextField pageField;
    FullScreenWindow fullScreen;
    OutlineNode outline = null;
    PageFormat pformat = PrinterJob.getPrinterJob().defaultPage();
    boolean doThumb = true;
    Flag docWaiter;
    PagePreparer pagePrep;
    JDialog olf;
    JMenu docMenu;
    Action openAction = new /* Unavailable Anonymous Inner Class!! */;
    Action pageSetupAction = new /* Unavailable Anonymous Inner Class!! */;
    Action printAction = new /* Unavailable Anonymous Inner Class!! */;
    Action closeAction = new /* Unavailable Anonymous Inner Class!! */;
    Action quitAction = new /* Unavailable Anonymous Inner Class!! */;
    ZoomAction zoomInAction = new ZoomAction(this, "Zoom in", this.getIcon("gfx/zoomin.gif"), 2.0);
    ZoomAction zoomOutAction = new ZoomAction(this, "Zoom out", this.getIcon("gfx/zoomout.gif"), 0.5);
    Action zoomToolAction = new /* Unavailable Anonymous Inner Class!! */;
    Action fitInWindowAction = new /* Unavailable Anonymous Inner Class!! */;
    ThumbAction thumbAction = new ThumbAction(this);
    Action fullScreenAction = new /* Unavailable Anonymous Inner Class!! */;
    Action nextAction = new /* Unavailable Anonymous Inner Class!! */;
    Action firstAction = new /* Unavailable Anonymous Inner Class!! */;
    Action lastAction = new /* Unavailable Anonymous Inner Class!! */;
    Action prevAction = new /* Unavailable Anonymous Inner Class!! */;
    FileFilter pdfFilter = new /* Unavailable Anonymous Inner Class!! */;
    private File prevDirChoice;
    PageBuilder pb = new PageBuilder(this);

    public Icon getIcon(String name) {
        ImageIcon icon = null;
        URL url = null;
        try {
            url = this.getClass().getResource(name);
            icon = new ImageIcon(url);
            if (icon == null) {
                System.out.println("Couldn't find " + url);
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't find " + this.getClass().getName() + "/" + name);
            e.printStackTrace();
        }
        return icon;
    }

    public PDFViewer(boolean useThumbs) {
        super(TITLE);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.doThumb = useThumbs;
        this.init();
    }

    protected void init() {
        this.page = new PagePanel();
        this.page.addKeyListener((KeyListener)this);
        if (this.doThumb) {
            this.split = new JSplitPane(1);
            this.split.addPropertyChangeListener("dividerLocation", (PropertyChangeListener)this.thumbAction);
            this.split.setOneTouchExpandable(true);
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll = new JScrollPane((Component)this.thumbs, 22, 31);
            this.split.setLeftComponent(this.thumbscroll);
            this.split.setRightComponent((Component)this.page);
            this.getContentPane().add((Component)this.split, "Center");
        } else {
            this.getContentPane().add((Component)this.page, "Center");
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton jb = new JButton(this.firstAction);
        jb.setText("");
        toolbar.add(jb);
        jb = new JButton(this.prevAction);
        jb.setText("");
        toolbar.add(jb);
        this.pageField = new JTextField("-", 3);
        this.pageField.setMaximumSize(new Dimension(45, 32));
        this.pageField.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.add(this.pageField);
        jb = new JButton(this.nextAction);
        jb.setText("");
        toolbar.add(jb);
        jb = new JButton(this.lastAction);
        jb.setText("");
        toolbar.add(jb);
        toolbar.add(Box.createHorizontalGlue());
        this.fullScreenButton = new JToggleButton(this.fullScreenAction);
        this.fullScreenButton.setText("");
        toolbar.add(this.fullScreenButton);
        this.fullScreenButton.setEnabled(true);
        toolbar.add(Box.createHorizontalGlue());
        ButtonGroup bg = new ButtonGroup();
        JToggleButton jtb = new JToggleButton(this.zoomToolAction);
        jtb.setText("");
        bg.add(jtb);
        toolbar.add(jtb);
        jtb = new JToggleButton(this.fitInWindowAction);
        jtb.setText("");
        bg.add(jtb);
        jtb.setSelected(true);
        toolbar.add(jtb);
        toolbar.add(Box.createHorizontalGlue());
        jb = new JButton(this.printAction);
        jb.setText("");
        toolbar.add(jb);
        this.getContentPane().add((Component)toolbar, "North");
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(this.openAction);
        file.add(this.closeAction);
        file.addSeparator();
        file.add(this.pageSetupAction);
        file.add(this.printAction);
        file.addSeparator();
        file.add(this.quitAction);
        mb.add(file);
        JMenu view = new JMenu("View");
        JMenu zoom = new JMenu("Zoom");
        zoom.add((Action)this.zoomInAction);
        zoom.add((Action)this.zoomOutAction);
        zoom.add(this.fitInWindowAction);
        zoom.setEnabled(false);
        view.add(zoom);
        view.add(this.fullScreenAction);
        if (this.doThumb) {
            view.addSeparator();
            view.add((Action)this.thumbAction);
        }
        mb.add(view);
        this.setJMenuBar(mb);
        this.setEnabling();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - this.getWidth()) / 2;
        int y = (screen.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InvocationTargetException ie) {
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public void gotoPage(int pagenum) {
        if (pagenum < 0) {
            pagenum = 0;
        } else if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        this.forceGotoPage(pagenum);
    }

    public void forceGotoPage(int pagenum) {
        if (pagenum <= 0) {
            pagenum = 0;
        } else if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        this.curpage = pagenum;
        this.pageField.setText(String.valueOf(this.curpage + 1));
        PDFPage pg = this.curFile.getPage(pagenum + 1);
        if (this.fspp != null) {
            this.fspp.showPage(pg);
            this.fspp.requestFocus();
        } else {
            this.page.showPage(pg);
            this.page.requestFocus();
        }
        if (this.doThumb) {
            this.thumbs.pageShown(pagenum);
        }
        if (this.pagePrep != null) {
            this.pagePrep.quit();
        }
        this.pagePrep = new PagePreparer(this, pagenum);
        this.pagePrep.start();
        this.setEnabling();
    }

    public void setEnabling() {
        boolean fileavailable;
        boolean bl = fileavailable = this.curFile != null;
        boolean pageshown = this.fspp != null ? this.fspp.getPage() != null : this.page.getPage() != null;
        boolean printable = fileavailable && this.curFile.isPrintable();
        this.pageField.setEnabled(fileavailable);
        this.printAction.setEnabled(printable);
        this.closeAction.setEnabled(fileavailable);
        this.fullScreenAction.setEnabled(pageshown);
        this.prevAction.setEnabled(pageshown);
        this.nextAction.setEnabled(pageshown);
        this.firstAction.setEnabled(fileavailable);
        this.lastAction.setEnabled(fileavailable);
        this.zoomToolAction.setEnabled(pageshown);
        this.fitInWindowAction.setEnabled(pageshown);
        this.zoomInAction.setEnabled(pageshown);
        this.zoomOutAction.setEnabled(pageshown);
    }

    public void openFile(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        int contentLength = urlConnection.getContentLength();
        InputStream istr = urlConnection.getInputStream();
        byte[] byteBuf = new byte[contentLength];
        int offset = 0;
        int read = 0;
        while (read >= 0) {
            read = istr.read(byteBuf, offset, contentLength - offset);
            if (read <= 0) continue;
            offset += read;
        }
        if (offset != contentLength) {
            throw new IOException("Could not read all of URL file.");
        }
        ByteBuffer buf = ByteBuffer.allocate(contentLength);
        buf.put(byteBuf);
        this.openPDFByteBuffer(buf, url.toString(), url.getFile());
    }

    public void openFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        this.openPDFByteBuffer((ByteBuffer)buf, file.getPath(), file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFileUnMapped(File file) throws IOException {
        FilterInputStream istr = null;
        try {
            istr = new DataInputStream(new FileInputStream(file));
            long len = file.length();
            if (len > Integer.MAX_VALUE) {
                throw new IOException("File too long to decode: " + file.getName());
            }
            int contentLength = (int)len;
            byte[] byteBuf = new byte[contentLength];
            int offset = 0;
            int read = 0;
            while (read >= 0) {
                read = ((DataInputStream)istr).read(byteBuf, offset, contentLength - offset);
                if (read <= 0) continue;
                offset += read;
            }
            ByteBuffer buf = ByteBuffer.allocate(contentLength);
            buf.put(byteBuf);
            this.openPDFByteBuffer(buf, file.getPath(), file.getName());
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (istr != null) {
                try {
                    istr.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void openPDFByteBuffer(ByteBuffer buf, String path, String name) {
        PDFFile newfile = null;
        try {
            newfile = new PDFFile(buf);
        }
        catch (IOException ioe) {
            this.openError(path + " doesn't appear to be a PDF file." + "\n: " + ioe.getMessage());
            return;
        }
        this.doClose();
        this.curFile = newfile;
        this.docName = name;
        this.setTitle("SwingLabs PDF Viewer: " + this.docName);
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(this.curFile);
            this.thumbs.addPageChangeListener((PageChangeListener)this);
            this.thumbscroll.getViewport().setView((Component)this.thumbs);
            this.thumbscroll.getViewport().setBackground(Color.gray);
        }
        this.setEnabling();
        this.forceGotoPage(0);
        try {
            this.outline = this.curFile.getOutline();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.outline != null) {
            if (this.outline.getChildCount() > 0) {
                this.olf = new JDialog((Frame)this, "Outline");
                this.olf.setDefaultCloseOperation(0);
                this.olf.setLocation(this.getLocation());
                JTree jt = new JTree(this.outline);
                jt.setRootVisible(false);
                jt.addTreeSelectionListener((TreeSelectionListener)this);
                JScrollPane jsp = new JScrollPane(jt);
                this.olf.getContentPane().add(jsp);
                this.olf.pack();
                this.olf.setVisible(true);
            } else if (this.olf != null) {
                this.olf.setVisible(false);
                this.olf = null;
            }
        }
    }

    public void openError(String message) {
        JOptionPane.showMessageDialog(this.split, message, "Error opening file", 0);
    }

    public void doOpen() {
        try {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(this.prevDirChoice);
            fc.setFileFilter(this.pdfFilter);
            fc.setMultiSelectionEnabled(false);
            int returnVal = fc.showOpenDialog((Component)this);
            if (returnVal == 0) {
                try {
                    this.prevDirChoice = fc.getSelectedFile();
                    this.openFile(fc.getSelectedFile());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.split, "Opening files from your local disk is not available\nfrom the Java Web Start version of this program.\n", "Error opening directory", 0);
            e.printStackTrace();
        }
    }

    public void doOpen(String name) {
        try {
            URL url = new URL(name);
            this.openFile(new URL(name));
        }
        catch (IOException ioe) {
            try {
                this.openFile(new File(name));
            }
            catch (IOException ex) {
                Logger.getLogger(PDFViewer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void doPageSetup() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        this.pformat = pjob.pageDialog(this.pformat);
    }

    public void doPrint() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        pjob.setJobName(this.docName);
        Book book = new Book();
        PDFPrintPage pages = new PDFPrintPage(this.curFile);
        book.append((Printable)pages, this.pformat, this.curFile.getNumPages());
        pjob.setPageable(book);
        if (pjob.printDialog()) {
            new PrintThread(this, pages, pjob).start();
        }
    }

    public void doClose() {
        if (this.thumbs != null) {
            this.thumbs.stop();
        }
        if (this.olf != null) {
            this.olf.setVisible(false);
            this.olf = null;
        }
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll.getViewport().setView((Component)this.thumbs);
        }
        this.setFullScreenMode(false, false);
        this.page.showPage(null);
        this.curFile = null;
        this.setTitle(TITLE);
        this.setEnabling();
    }

    public void doQuit() {
        this.doClose();
        this.dispose();
        System.exit(0);
    }

    public void doZoomTool() {
        if (this.fspp == null) {
            this.page.useZoomTool(true);
        }
    }

    public void doFitInWindow() {
        if (this.fspp == null) {
            this.page.useZoomTool(false);
            this.page.setClip(null);
        }
    }

    public void doThumbs(boolean show) {
        if (show) {
            this.split.setDividerLocation(this.thumbs.getPreferredSize().width + this.thumbscroll.getVerticalScrollBar().getWidth() + 4);
        } else {
            this.split.setDividerLocation(0);
        }
    }

    public void doFullScreen(boolean force) {
        this.setFullScreenMode(this.fullScreen == null, force);
    }

    public void doZoom(double factor) {
    }

    public void doNext() {
        this.gotoPage(this.curpage + 1);
    }

    public void doPrev() {
        this.gotoPage(this.curpage - 1);
    }

    public void doFirst() {
        this.gotoPage(0);
    }

    public void doLast() {
        this.gotoPage(this.curFile.getNumPages() - 1);
    }

    public void doPageTyped() {
        int pagenum = -1;
        try {
            pagenum = Integer.parseInt(this.pageField.getText()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        if (pagenum >= 0) {
            if (pagenum != this.curpage) {
                this.gotoPage(pagenum);
            }
        } else {
            this.pageField.setText(String.valueOf(this.curpage));
        }
    }

    public void setFullScreenMode(boolean full, boolean force) {
        if (full && this.fullScreen == null) {
            this.fullScreenAction.setEnabled(false);
            new Thread((Runnable)new PerformFullScreenMode(this, force), this.getClass().getName() + ".setFullScreenMode").start();
            this.fullScreenButton.setSelected(true);
        } else if (!full && this.fullScreen != null) {
            this.fullScreen.close();
            this.fspp = null;
            this.fullScreen = null;
            this.gotoPage(this.curpage);
            this.fullScreenButton.setSelected(false);
        }
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean useThumbs = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-noThumb")) {
                useThumbs = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("-?")) {
                System.out.println("java com.sun.awc.PDFViewer [flags] [file]");
                System.out.println("flags: [-noThumb] [-help or -h or -?]");
                System.exit(0);
                continue;
            }
            fileName = args[i];
        }
        PDFViewer viewer = new PDFViewer(useThumbs);
        if (fileName != null) {
            viewer.doOpen(fileName);
        }
    }

    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 37) {
            this.doPrev();
        } else if (code == 39) {
            this.doNext();
        } else if (code == 38) {
            this.doPrev();
        } else if (code == 40) {
            this.doNext();
        } else if (code == 36) {
            this.doFirst();
        } else if (code == 35) {
            this.doLast();
        } else if (code == 33) {
            this.doPrev();
        } else if (code == 34) {
            this.doNext();
        } else if (code == 32) {
            this.doNext();
        } else if (code == 27) {
            this.setFullScreenMode(false, false);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (key >= '0' && key <= '9') {
            int val = key - 48;
            this.pb.keyTyped(val);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.isAddedPath()) {
            OutlineNode node = (OutlineNode)e.getPath().getLastPathComponent();
            if (node == null) {
                return;
            }
            try {
                PDFAction action = node.getAction();
                if (action == null) {
                    return;
                }
                if (action instanceof GoToAction) {
                    PDFDestination dest = ((GoToAction)action).getDestination();
                    if (dest == null) {
                        return;
                    }
                    PDFObject page = dest.getPage();
                    if (page == null) {
                        return;
                    }
                    int pageNum = this.curFile.getPageNumber(page);
                    if (pageNum >= 0) {
                        this.gotoPage(pageNum);
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

