/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.ASCII85Decode;
import com.sun.pdfview.decode.ASCIIHexDecode;
import com.sun.pdfview.decode.CCITTFaxDecode;
import com.sun.pdfview.decode.DCTDecode;
import com.sun.pdfview.decode.FlateDecode;
import com.sun.pdfview.decode.LZWDecode;
import com.sun.pdfview.decode.RunLengthDecode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PDFDecoder {
    private static final String FILTER_DCT = "DCT";
    private static final String FILTER_DCTDECODE = "DCTDecode";
    public static final Set<String> DCT_FILTERS = new HashSet<String>(Arrays.asList("DCT", "DCTDecode"));

    private PDFDecoder() {
    }

    public static boolean isLastFilter(PDFObject dict, Set<String> filters) throws IOException {
        PDFObject filter = dict.getDictRef("Filter");
        if (filter == null) {
            return false;
        }
        if (filter.getType() == 4) {
            return filters.contains(filter.getStringValue());
        }
        PDFObject[] ary = filter.getArray();
        return filters.contains(ary[ary.length - 1].getStringValue());
    }

    public static ByteBuffer decodeStream(PDFObject dict, ByteBuffer streamBuf, Set<String> filterLimits) throws IOException {
        boolean specificCryptFilter;
        PDFObject filter = dict.getDictRef("Filter");
        if (filter == null) {
            return dict.getDecrypter().decryptBuffer(null, dict, streamBuf);
        }
        FilterSpec spec = new FilterSpec(dict, filter);
        boolean bl = specificCryptFilter = spec.ary.length != 0 && spec.ary[0].getStringValue().equals("Crypt");
        if (!specificCryptFilter) {
            streamBuf = dict.getDecrypter().decryptBuffer(null, dict, streamBuf);
        }
        int i = 0;
        while (i < spec.ary.length) {
            String enctype = spec.ary[i].getStringValue();
            if (filterLimits.contains(enctype)) break;
            if (enctype != null) {
                if (enctype.equals("FlateDecode") || enctype.equals("Fl")) {
                    streamBuf = FlateDecode.decode(dict, streamBuf, spec.params[i]);
                } else if (enctype.equals("LZWDecode") || enctype.equals("LZW")) {
                    streamBuf = LZWDecode.decode(streamBuf, spec.params[i]);
                } else if (enctype.equals("ASCII85Decode") || enctype.equals("A85")) {
                    streamBuf = ASCII85Decode.decode(streamBuf, spec.params[i]);
                } else if (enctype.equals("ASCIIHexDecode") || enctype.equals("AHx")) {
                    streamBuf = ASCIIHexDecode.decode(streamBuf, spec.params[i]);
                } else if (enctype.equals("RunLengthDecode") || enctype.equals("RL")) {
                    streamBuf = RunLengthDecode.decode(streamBuf, spec.params[i]);
                } else if (enctype.equals(FILTER_DCTDECODE) || enctype.equals(FILTER_DCT)) {
                    streamBuf = DCTDecode.decode(dict, streamBuf, spec.params[i]);
                } else if (enctype.equals("CCITTFaxDecode") || enctype.equals("CCF")) {
                    streamBuf = CCITTFaxDecode.decode(dict, streamBuf, spec.params[i]);
                } else if (enctype.equals("Crypt")) {
                    String cfName = PDFDecoder.getCryptFilterName(spec.params[i]);
                    streamBuf = dict.getDecrypter().decryptBuffer(cfName, null, streamBuf);
                } else {
                    throw new PDFParseException("Unknown coding method:" + spec.ary[i].getStringValue());
                }
            }
            ++i;
        }
        return streamBuf;
    }

    private static String getCryptFilterName(PDFObject param) throws IOException {
        PDFObject nameObj;
        String cfName = "Identity";
        if (param != null && (nameObj = param.getDictRef("Name")) != null && nameObj.getType() == 4) {
            cfName = nameObj.getStringValue();
        }
        return cfName;
    }

    public static boolean isEncrypted(PDFObject dict) throws IOException {
        boolean specificCryptFilter;
        PDFObject filter = dict.getDictRef("Filter");
        if (filter == null) {
            return dict.getDecrypter().isEncryptionPresent();
        }
        FilterSpec spec = new FilterSpec(dict, filter);
        boolean bl = specificCryptFilter = spec.ary.length != 0 && spec.ary[0].getStringValue().equals("Crypt");
        if (!specificCryptFilter) {
            return dict.getDecrypter().isEncryptionPresent();
        }
        String cfName = PDFDecoder.getCryptFilterName(spec.params[0]);
        return dict.getDecrypter().isEncryptionPresent(cfName);
    }

    private static class FilterSpec {
        PDFObject[] ary;
        PDFObject[] params;

        private FilterSpec(PDFObject dict, PDFObject filter) throws IOException {
            if (filter.getType() == 4) {
                this.ary = new PDFObject[1];
                this.ary[0] = filter;
                this.params = new PDFObject[1];
                this.params[0] = dict.getDictRef("DecodeParms");
            } else {
                this.ary = filter.getArray();
                PDFObject parmsobj = dict.getDictRef("DecodeParms");
                this.params = parmsobj != null ? parmsobj.getArray() : new PDFObject[this.ary.length];
            }
        }
    }
}

