/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.decode.Predictor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TIFFPredictor
extends Predictor {
    public TIFFPredictor() {
        super(0);
    }

    @Override
    public ByteBuffer unpredict(ByteBuffer imageData) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(imageData.limit());
        int numComponents = this.getColors();
        int pixelBits = numComponents * this.getBitsPerComponent();
        int bytePerRow = (this.getColumns() * pixelBits + 7) / 8;
        byte[] row = new byte[bytePerRow];
        while (imageData.remaining() > 0) {
            int pos;
            imageData.get(row);
            if (this.getBitsPerComponent() == 8) {
                int i = numComponents;
                while (i < row.length) {
                    int c = 0;
                    while (c < numComponents) {
                        int n = pos = i + c;
                        row[n] = (byte)(row[n] + row[pos - numComponents]);
                        ++c;
                    }
                    i += numComponents;
                }
            } else if (this.getBitsPerComponent() == 16) {
                short[] prev = new short[numComponents];
                int c = 0;
                while (c < numComponents) {
                    pos = c * 2;
                    prev[c] = (short)(row[pos] << 8 | row[pos + 1] & 0xFFFF);
                    ++c;
                }
                int i = numComponents * 2;
                while (i < row.length) {
                    int c2 = 0;
                    while (c2 < numComponents) {
                        int pos2 = i + c2 * 2;
                        short cur = (short)(row[pos2] << 8 | row[pos2 + 1] & 0xFFFF);
                        cur = (short)(cur + prev[c2]);
                        row[pos2] = (byte)(cur >>> 8 & 0xFF);
                        row[pos2 + 1] = (byte)(cur & 0xFF);
                        prev[c2] = cur;
                        ++c2;
                    }
                    i += numComponents * 2;
                }
            } else {
                assert (this.getBitsPerComponent() == 1 || this.getBitsPerComponent() == 2 || this.getBitsPerComponent() == 4) : "we don't want to grab components across pixel boundaries";
                int bitsOnRow = pixelBits * this.getColumns();
                byte[] prev = new byte[numComponents];
                int shiftWhenAligned = 8 - this.getBitsPerComponent();
                int mask = (1 << this.getBitsPerComponent()) - 1;
                int c = 0;
                while (c < numComponents) {
                    prev[c] = TIFFPredictor.getbits(row, c * this.getBitsPerComponent(), shiftWhenAligned, mask);
                    ++c;
                }
                int i = pixelBits;
                while (i < bitsOnRow) {
                    int c3 = 0;
                    while (c3 < numComponents) {
                        byte cur = TIFFPredictor.getbits(row, i + c3 * this.getBitsPerComponent(), shiftWhenAligned, mask);
                        prev[c3] = cur = (byte)(cur + prev[c3]);
                        TIFFPredictor.setbits(row, i + c3 * this.getBitsPerComponent(), shiftWhenAligned, mask, cur);
                        ++c3;
                    }
                    i += pixelBits;
                }
            }
            out.put(row);
        }
        out.flip();
        return out;
    }

    private static byte getbits(byte[] data, int bitIndex, int shiftWhenByteAligned, int mask) {
        byte b = data[bitIndex >> 3];
        int bitIndexInB = bitIndex & 7;
        int shift = shiftWhenByteAligned - bitIndexInB;
        return (byte)(b >>> shift & mask);
    }

    private static void setbits(byte[] data, int bitIndex, int shiftWhenByteAligned, int mask, byte bits) {
        byte b = data[bitIndex >> 3];
        int bitIndexInB = bitIndex & 7;
        int shift = shiftWhenByteAligned - bitIndexInB;
        data[bitIndex >> 3] = (byte)(b & ~(mask << shift) | bits << shift);
    }
}

