/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.Glyf;
import java.nio.ByteBuffer;

public class GlyfSimple
extends Glyf {
    private short[] contourEndPts;
    private byte[] instructions;
    private byte[] flags;
    private short[] xCoords;
    private short[] yCoords;

    protected GlyfSimple() {
    }

    @Override
    public void setData(ByteBuffer data) {
        short[] contourEndPts = new short[this.getNumContours()];
        int i = 0;
        while (i < contourEndPts.length) {
            contourEndPts[i] = data.getShort();
            ++i;
        }
        this.setContourEndPoints(contourEndPts);
        int numPoints = this.getContourEndPoint(this.getNumContours() - 1) + 1;
        short numInstructions = data.getShort();
        byte[] instructions = new byte[numInstructions];
        int i2 = 0;
        while (i2 < instructions.length) {
            instructions[i2] = data.get();
            ++i2;
        }
        this.setInstructions(instructions);
        byte[] flags = new byte[numPoints];
        int i3 = 0;
        while (i3 < flags.length) {
            flags[i3] = data.get();
            if ((flags[i3] & 8) != 0) {
                byte f = flags[i3];
                int n = data.get() & 0xFF;
                int c = 0;
                while (c < n) {
                    flags[++i3] = f;
                    ++c;
                }
            }
            ++i3;
        }
        this.setFlags(flags);
        short[] xCoords = new short[numPoints];
        int i4 = 0;
        while (i4 < xCoords.length) {
            if (i4 > 0) {
                xCoords[i4] = xCoords[i4 - 1];
            }
            if (this.xIsByte(i4)) {
                int val = data.get() & 0xFF;
                if (!this.xIsSame(i4)) {
                    val = -val;
                }
                int n = i4;
                xCoords[n] = (short)(xCoords[n] + val);
            } else if (!this.xIsSame(i4)) {
                int n = i4;
                xCoords[n] = (short)(xCoords[n] + data.getShort());
            }
            ++i4;
        }
        this.setXCoords(xCoords);
        short[] yCoords = new short[numPoints];
        int i5 = 0;
        while (i5 < yCoords.length) {
            if (i5 > 0) {
                yCoords[i5] = yCoords[i5 - 1];
            }
            if (this.yIsByte(i5)) {
                int val = data.get() & 0xFF;
                if (!this.yIsSame(i5)) {
                    val = -val;
                }
                int n = i5;
                yCoords[n] = (short)(yCoords[n] + val);
            } else if (!this.yIsSame(i5)) {
                int n = i5;
                yCoords[n] = (short)(yCoords[n] + data.getShort());
            }
            ++i5;
        }
        this.setYCoords(yCoords);
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer buf = super.getData();
        int i = 0;
        while (i < this.getNumContours()) {
            buf.putShort(this.getContourEndPoint(i));
            ++i;
        }
        buf.putShort(this.getNumInstructions());
        i = 0;
        while (i < this.getNumInstructions()) {
            buf.put(this.getInstruction(i));
            ++i;
        }
        i = 0;
        while (i < this.getNumPoints()) {
            byte r = 0;
            while (i > 0 && this.getFlag(i) == this.getFlag(i - 1)) {
                r = (byte)(r + 1);
                ++i;
            }
            if (r > 0) {
                buf.put(r);
            } else {
                buf.put(this.getFlag(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.getNumPoints()) {
            if (this.xIsByte(i)) {
                buf.put((byte)this.getXCoord(i));
            } else if (!this.xIsSame(i)) {
                buf.putShort(this.getXCoord(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.getNumPoints()) {
            if (this.yIsByte(i)) {
                buf.put((byte)this.getYCoord(i));
            } else if (!this.yIsSame(i)) {
                buf.putShort(this.getYCoord(i));
            }
            ++i;
        }
        return buf;
    }

    @Override
    public short getLength() {
        short length = super.getLength();
        length = (short)(length + this.getNumContours() * 2);
        length = (short)(length + (2 + this.getNumInstructions()));
        int i = 0;
        while (i < this.getNumPoints()) {
            while (i > 0 && this.getFlag(i) == this.getFlag(i - 1)) {
            }
            length = (short)(length + 1);
            ++i;
        }
        i = 0;
        while (i < this.getNumPoints()) {
            if (this.xIsByte(i)) {
                length = (short)(length + 1);
            } else if (!this.xIsSame(i)) {
                length = (short)(length + 2);
            }
            if (this.yIsByte(i)) {
                length = (short)(length + 1);
            } else if (!this.yIsSame(i)) {
                length = (short)(length + 2);
            }
            ++i;
        }
        return length;
    }

    public short getContourEndPoint(int index) {
        return this.contourEndPts[index];
    }

    protected void setContourEndPoints(short[] contourEndPts) {
        this.contourEndPts = contourEndPts;
    }

    public short getNumInstructions() {
        return (short)this.instructions.length;
    }

    public byte getInstruction(int index) {
        return this.instructions[index];
    }

    protected void setInstructions(byte[] instructions) {
        this.instructions = instructions;
    }

    public short getNumPoints() {
        return (short)this.flags.length;
    }

    public byte getFlag(int pointIndex) {
        return this.flags[pointIndex];
    }

    public boolean onCurve(int pointIndex) {
        return (this.getFlag(pointIndex) & 1) != 0;
    }

    protected boolean xIsByte(int pointIndex) {
        return (this.getFlag(pointIndex) & 2) != 0;
    }

    protected boolean yIsByte(int pointIndex) {
        return (this.getFlag(pointIndex) & 4) != 0;
    }

    protected boolean repeat(int pointIndex) {
        return (this.getFlag(pointIndex) & 8) != 0;
    }

    protected boolean xIsSame(int pointIndex) {
        return (this.getFlag(pointIndex) & 0x10) != 0;
    }

    protected boolean yIsSame(int pointIndex) {
        return (this.getFlag(pointIndex) & 0x20) != 0;
    }

    protected void setFlags(byte[] flags) {
        this.flags = flags;
    }

    public short getXCoord(int pointIndex) {
        return this.xCoords[pointIndex];
    }

    protected void setXCoords(short[] xCoords) {
        this.xCoords = xCoords;
    }

    public short getYCoord(int pointIndex) {
        return this.yCoords[pointIndex];
    }

    protected void setYCoords(short[] yCoords) {
        this.yCoords = yCoords;
    }
}

