/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.JiBX_defaultMungeAdapter;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.M2XML;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class M2Model
implements IUnmarshallable,
IMarshallable {
    private String name = null;
    private String description = null;
    private String author = null;
    private Date published = null;
    private String version;
    private String analyserResourceBundleName = null;
    private List<M2Namespace> namespaces = new ArrayList<M2Namespace>();
    private List<M2Namespace> imports = new ArrayList<M2Namespace>();
    private List<M2DataType> dataTypes = new ArrayList<M2DataType>();
    private List<M2Type> types = new ArrayList<M2Type>();
    private List<M2Aspect> aspects = new ArrayList<M2Aspect>();
    private List<M2Constraint> constraints = new ArrayList<M2Constraint>();
    public static final String JiBX_bindingList = "|org.alfresco.repo.dictionary.JiBX_defaultFactory|";

    M2Model() {
    }

    public static M2Model createModel(String name) {
        M2Model model = new M2Model();
        model.name = name;
        return model;
    }

    public static M2Model createModel(InputStream xml) {
        return M2Model.createModel("default", xml);
    }

    public static M2Model createModel(String bindingName, InputStream xml) {
        try {
            IBindingFactory factory = BindingDirectory.getFactory((String)bindingName, M2Model.class);
            IUnmarshallingContext context = factory.createUnmarshallingContext();
            Object obj = context.unmarshalDocument(xml, null);
            return (M2Model)obj;
        }
        catch (JiBXException e) {
            throw new DictionaryException("Failed to parse model", e);
        }
    }

    public void toXML(OutputStream xml) {
        this.toXML(null, xml);
    }

    public void toXML(ModelDefinition.XMLBindingType bindingType, OutputStream xml) {
        try {
            String bindingName;
            if (bindingType == null) {
                bindingType = ModelDefinition.XMLBindingType.DEFAULT;
            }
            IBindingFactory factory = (bindingName = bindingType.toString()) != null ? BindingDirectory.getFactory((String)bindingName, M2Model.class) : BindingDirectory.getFactory((String)"default", M2Model.class);
            IMarshallingContext context = factory.createMarshallingContext();
            context.setIndent(4);
            context.marshalDocument((Object)this, "UTF-8", null, xml);
        }
        catch (JiBXException e) {
            throw new DictionaryException("Failed to create M2 Model", e);
        }
    }

    public long getChecksum(ModelDefinition.XMLBindingType bindingType) {
        final CRC32 crc = new CRC32();
        this.toXML(bindingType, new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                crc.update(b);
            }
        });
        return crc.getValue();
    }

    CompiledModel compile(DictionaryDAO dictionaryDAO, NamespaceDAO namespaceDAO, boolean enableConstraintClassLoading) {
        CompiledModel compiledModel = new CompiledModel(this, dictionaryDAO, namespaceDAO, enableConstraintClassLoading);
        return compiledModel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getPublishedDate() {
        return this.published;
    }

    public void setPublishedDate(Date published) {
        this.published = published;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public M2Type createType(String name) {
        M2Type type = new M2Type();
        type.setName(name);
        this.types.add(type);
        return type;
    }

    public void removeType(String name) {
        M2Type type = this.getType(name);
        if (type != null) {
            this.types.remove(type);
        }
    }

    public List<M2Type> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    public M2Type getType(String name) {
        for (M2Type candidate : this.types) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Aspect createAspect(String name) {
        M2Aspect aspect = new M2Aspect();
        aspect.setName(name);
        this.aspects.add(aspect);
        return aspect;
    }

    public void removeAspect(String name) {
        M2Aspect aspect = this.getAspect(name);
        if (aspect != null) {
            this.aspects.remove(aspect);
        }
    }

    public List<M2Aspect> getAspects() {
        return Collections.unmodifiableList(this.aspects);
    }

    public M2Aspect getAspect(String name) {
        for (M2Aspect candidate : this.aspects) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2DataType createPropertyType(String name) {
        M2DataType type = new M2DataType();
        type.setName(name);
        this.dataTypes.add(type);
        return type;
    }

    public void removePropertyType(String name) {
        M2DataType type = this.getPropertyType(name);
        if (type != null) {
            this.dataTypes.remove(name);
        }
    }

    public List<M2DataType> getPropertyTypes() {
        return Collections.unmodifiableList(this.dataTypes);
    }

    public M2DataType getPropertyType(String name) {
        for (M2DataType candidate : this.dataTypes) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Namespace createNamespace(String uri, String prefix) {
        M2Namespace namespace = new M2Namespace();
        namespace.setUri(uri);
        namespace.setPrefix(prefix);
        this.namespaces.add(namespace);
        return namespace;
    }

    public void removeNamespace(String uri) {
        M2Namespace namespace = this.getNamespace(uri);
        if (namespace != null) {
            this.namespaces.remove(namespace);
        }
    }

    public List<M2Namespace> getNamespaces() {
        return Collections.unmodifiableList(this.namespaces);
    }

    public M2Namespace getNamespace(String uri) {
        for (M2Namespace candidate : this.namespaces) {
            if (!candidate.getUri().equals(uri)) continue;
            return candidate;
        }
        return null;
    }

    public M2Namespace createImport(String uri, String prefix) {
        M2Namespace namespace = new M2Namespace();
        namespace.setUri(uri);
        namespace.setPrefix(prefix);
        this.imports.add(namespace);
        return namespace;
    }

    public void removeImport(String uri) {
        M2Namespace namespace = this.getImport(uri);
        if (namespace != null) {
            this.imports.remove(namespace);
        }
    }

    public List<M2Namespace> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    public M2Namespace getImport(String uri) {
        for (M2Namespace candidate : this.imports) {
            if (!candidate.getUri().equals(uri)) continue;
            return candidate;
        }
        return null;
    }

    public List<M2Constraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public M2Constraint getConstraint(String name) {
        for (M2Constraint candidate : this.constraints) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Constraint createConstraint(String name, String type) {
        M2Constraint constraint = new M2Constraint();
        constraint.setName(name);
        constraint.setType(type);
        this.constraints.add(constraint);
        return constraint;
    }

    public void removeConstraint(String name) {
        M2Constraint constraint = this.getConstraint(name);
        if (constraint != null) {
            this.constraints.remove(constraint);
        }
    }

    public static List createList() {
        return new ArrayList();
    }

    public String getAnalyserResourceBundleName() {
        return this.analyserResourceBundleName;
    }

    public void setAnalyserResourceBundleName(String analyserResourceBundleName) {
        this.analyserResourceBundleName = analyserResourceBundleName;
    }

    public static /* synthetic */ M2Model JiBX_default_newinstance_1_0(M2Model arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new M2Model();
        }
        return arg1;
    }

    public static /* synthetic */ M2Model JiBX_default_unmarshalAttr_1_0(M2Model arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject((Object)arg1);
        M2Model m2Model = arg1;
        arg1.name = arg2.attributeText(null, "name");
        arg2.popObject();
        return arg1;
    }

    public static /* synthetic */ M2Model JiBX_default_unmarshal_1_0(M2Model arg1, UnmarshallingContext arg2) throws JiBXException {
        try {
            arg2.pushObject((Object)arg1);
            M2Model m2Model = arg1;
            arg1.description = arg2.parseElementText("http://www.alfresco.org/model/dictionary/1.0", "description", null);
            arg1.author = arg2.parseElementText("http://www.alfresco.org/model/dictionary/1.0", "author", null);
            String string = arg2.parseElementText("http://www.alfresco.org/model/dictionary/1.0", "published", null);
            arg1.published = string == null ? null : M2XML.deserialiseDate(string);
            arg1.version = arg2.parseElementText("http://www.alfresco.org/model/dictionary/1.0", "version", null);
            arg1.analyserResourceBundleName = arg2.parseElementText("http://www.alfresco.org/model/dictionary/1.0", "analyserResourceBundleName", null);
            if (arg2.isAt("http://www.alfresco.org/model/dictionary/1.0", "imports")) {
                arg2.parsePastStartTag("http://www.alfresco.org/model/dictionary/1.0", "imports");
                arg1.imports = JiBX_defaultMungeAdapter.JiBX_default_unmarshal_1_0(JiBX_defaultMungeAdapter.JiBX_default_newinstance_1_0(arg1.imports, arg2), arg2);
                arg2.parsePastCurrentEndTag("http://www.alfresco.org/model/dictionary/1.0", "imports");
            } else {
                m2Model = null;
            }
            if (arg2.isAt("http://www.alfresco.org/model/dictionary/1.0", "namespaces")) {
                arg2.parsePastStartTag("http://www.alfresco.org/model/dictionary/1.0", "namespaces");
                arg1.namespaces = JiBX_defaultMungeAdapter.JiBX_default_unmarshal_1_1(JiBX_defaultMungeAdapter.JiBX_default_newinstance_1_0(arg1.namespaces, arg2), arg2);
                arg2.parsePastCurrentEndTag("http://www.alfresco.org/model/dictionary/1.0", "namespaces");
            } else {
                m2Model = null;
            }
            if (arg2.isAt("http://www.alfresco.org/model/dictionary/1.0", "data-types")) {
                arg2.parsePastStartTag("http://www.alfresco.org/model/dictionary/1.0", "data-types");
                arg1.dataTypes = JiBX_defaultMungeAdapter.JiBX_default_unmarshal_1_2(JiBX_defaultMungeAdapter.JiBX_default_newinstance_1_0(arg1.dataTypes, arg2), arg2);
                arg2.parsePastCurrentEndTag("http://www.alfresco.org/model/dictionary/1.0", "data-types");
            } else {
                m2Model = null;
            }
            if (arg2.isAt("http://www.alfresco.org/model/dictionary/1.0", "constraints")) {
                arg2.parsePastStartTag("http://www.alfresco.org/model/dictionary/1.0", "constraints");
                arg1.constraints = JiBX_defaultMungeAdapter.JiBX_default_unmarshal_1_3(JiBX_defaultMungeAdapter.JiBX_default_newinstance_1_0(arg1.constraints, arg2), arg2);
                arg2.parsePastCurrentEndTag("http://www.alfresco.org/model/dictionary/1.0", "constraints");
            } else {
                m2Model = null;
            }
            if (arg2.isAt("http://www.alfresco.org/model/dictionary/1.0", "types")) {
                arg2.parsePastStartTag("http://www.alfresco.org/model/dictionary/1.0", "types");
                arg1.types = JiBX_defaultMungeAdapter.JiBX_default_unmarshal_1_4(JiBX_defaultMungeAdapter.JiBX_default_newinstance_1_0(arg1.types, arg2), arg2);
                arg2.parsePastCurrentEndTag("http://www.alfresco.org/model/dictionary/1.0", "types");
            } else {
                m2Model = null;
            }
            if (arg2.isAt("http://www.alfresco.org/model/dictionary/1.0", "aspects")) {
                arg2.parsePastStartTag("http://www.alfresco.org/model/dictionary/1.0", "aspects");
                arg1.aspects = JiBX_defaultMungeAdapter.JiBX_default_unmarshal_1_5(JiBX_defaultMungeAdapter.JiBX_default_newinstance_1_0(arg1.aspects, arg2), arg2);
                arg2.parsePastCurrentEndTag("http://www.alfresco.org/model/dictionary/1.0", "aspects");
            } else {
                m2Model = null;
            }
            arg2.popObject();
            return arg1;
        }
        catch (ParseException parseException) {
            throw new JiBXException(new StringBuffer("Error while unmarshalling ").append(arg2.buildPositionString()).toString(), (Throwable)parseException);
        }
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.alfresco.repo.dictionary.M2Model").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.alfresco.repo.dictionary.M2Model";
    }

    public static /* synthetic */ void JiBX_default_marshalAttr_1_0(M2Model arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2.attribute(0, "name", arg1.name);
        arg2.popObject();
    }

    public static /* synthetic */ void JiBX_default_marshal_1_0(M2Model arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2;
        if (arg1.description != null) {
            marshallingContext = marshallingContext.element(3, "description", arg1.description);
        }
        if (arg1.author != null) {
            marshallingContext = marshallingContext.element(3, "author", arg1.author);
        }
        if (arg1.published != null) {
            marshallingContext = marshallingContext.element(3, "published", M2XML.serialiseDate(arg1.published));
        }
        if (arg1.version != null) {
            marshallingContext = marshallingContext.element(3, "version", arg1.version);
        }
        if (arg1.analyserResourceBundleName != null) {
            marshallingContext = marshallingContext.element(3, "analyserResourceBundleName", arg1.analyserResourceBundleName);
        }
        MarshallingContext marshallingContext2 = arg2.startTag(3, "imports");
        JiBX_defaultMungeAdapter.JiBX_default_marshal_1_5(arg1.imports, arg2);
        marshallingContext2.endTag(3, "imports");
        MarshallingContext marshallingContext3 = arg2.startTag(3, "namespaces");
        JiBX_defaultMungeAdapter.JiBX_default_marshal_1_6(arg1.namespaces, arg2);
        marshallingContext3.endTag(3, "namespaces");
        MarshallingContext marshallingContext4 = arg2.startTag(3, "data-types");
        JiBX_defaultMungeAdapter.JiBX_default_marshal_1_7(arg1.dataTypes, arg2);
        marshallingContext4.endTag(3, "data-types");
        MarshallingContext marshallingContext5 = arg2.startTag(3, "constraints");
        JiBX_defaultMungeAdapter.JiBX_default_marshal_1_8(arg1.constraints, arg2);
        marshallingContext5.endTag(3, "constraints");
        MarshallingContext marshallingContext6 = arg2.startTag(3, "types");
        JiBX_defaultMungeAdapter.JiBX_default_marshal_1_9(arg1.types, arg2);
        marshallingContext6.endTag(3, "types");
        MarshallingContext marshallingContext7 = arg2.startTag(3, "aspects");
        JiBX_defaultMungeAdapter.JiBX_default_marshal_1_10(arg1.aspects, arg2);
        marshallingContext7.endTag(3, "aspects");
        arg2.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.alfresco.repo.dictionary.M2Model").marshal((Object)this, arg1);
    }
}

