/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.ContextInvalidException;
import org.alfresco.repo.security.authentication.AlfrescoSecureContext;

public class AlfrescoSecureContextImpl
implements AlfrescoSecureContext {
    private static final long serialVersionUID = -8893133731693272549L;
    private Authentication realAuthentication;
    private Authentication effectiveAuthentication;

    public Authentication getAuthentication() {
        return this.getEffectiveAuthentication();
    }

    public void setAuthentication(Authentication newAuthentication) {
        this.setEffectiveAuthentication(newAuthentication);
    }

    public void validate() throws ContextInvalidException {
        if (this.effectiveAuthentication == null) {
            throw new ContextInvalidException("Effective authentication not set");
        }
    }

    @Override
    public Authentication getEffectiveAuthentication() {
        return this.effectiveAuthentication;
    }

    @Override
    public Authentication getRealAuthentication() {
        return this.realAuthentication;
    }

    @Override
    public void setEffectiveAuthentication(Authentication effictiveAuthentication) {
        this.effectiveAuthentication = effictiveAuthentication;
    }

    @Override
    public void setRealAuthentication(Authentication realAuthentication) {
        this.realAuthentication = realAuthentication;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.effectiveAuthentication == null ? 0 : this.effectiveAuthentication.hashCode());
        result = 31 * result + (this.realAuthentication == null ? 0 : this.realAuthentication.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlfrescoSecureContextImpl other = (AlfrescoSecureContextImpl)obj;
        if (this.effectiveAuthentication == null ? other.effectiveAuthentication != null : !this.effectiveAuthentication.equals(other.effectiveAuthentication)) {
            return false;
        }
        return !(this.realAuthentication == null ? other.realAuthentication != null : !this.realAuthentication.equals(other.realAuthentication));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.realAuthentication == null) {
            builder.append("Real authenticaion = null");
        } else {
            builder.append("Real authenticaion = " + this.realAuthentication.toString());
        }
        builder.append(", ");
        if (this.effectiveAuthentication == null) {
            builder.append("Effective authenticaion = null");
        } else {
            builder.append("Effective authenticaion = " + this.effectiveAuthentication.toString());
        }
        builder.append(", ");
        return builder.toString();
    }
}

