/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreExistsException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public interface NodeService {
    @Auditable
    public List<StoreRef> getStores();

    @Auditable(parameters={"protocol", "identifier"})
    public StoreRef createStore(String var1, String var2) throws StoreExistsException;

    @Auditable(parameters={"storeRef"})
    public void deleteStore(StoreRef var1);

    @Auditable(parameters={"storeRef"})
    public boolean exists(StoreRef var1);

    @Auditable(parameters={"nodeRef"})
    public boolean exists(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public NodeRef.Status getNodeStatus(NodeRef var1);

    @Auditable(parameters={"nodeId"})
    public NodeRef getNodeRef(Long var1);

    @Auditable(parameters={"storeRef"})
    public NodeRef getRootNode(StoreRef var1) throws InvalidStoreRefException;

    @Auditable(parameters={"storeRef"})
    public Set<NodeRef> getAllRootNodes(StoreRef var1);

    @Auditable(parameters={"parentRef", "assocTypeQName", "assocQName", "nodeTypeQName"})
    public ChildAssociationRef createNode(NodeRef var1, QName var2, QName var3, QName var4) throws InvalidNodeRefException, InvalidTypeException;

    @Auditable(parameters={"parentRef", "assocTypeQName", "assocQName", "nodeTypeQName", "properties"})
    public ChildAssociationRef createNode(NodeRef var1, QName var2, QName var3, QName var4, Map<QName, Serializable> var5) throws InvalidNodeRefException, InvalidTypeException;

    @Auditable(parameters={"nodeToMoveRef", "newParentRef", "assocTypeQName", "assocQName"})
    public ChildAssociationRef moveNode(NodeRef var1, NodeRef var2, QName var3, QName var4) throws InvalidNodeRefException;

    @Auditable(parameters={"childAssocRef", "index"})
    public void setChildAssociationIndex(ChildAssociationRef var1, int var2) throws InvalidChildAssociationRefException;

    @Auditable(parameters={"nodeRef"})
    public QName getType(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "typeQName"})
    public void setType(NodeRef var1, QName var2) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "aspectTypeQName", "aspectProperties"})
    public void addAspect(NodeRef var1, QName var2, Map<QName, Serializable> var3) throws InvalidNodeRefException, InvalidAspectException;

    @Auditable(parameters={"nodeRef", "aspectTypeQName"})
    public void removeAspect(NodeRef var1, QName var2) throws InvalidNodeRefException, InvalidAspectException;

    @Auditable(parameters={"nodeRef", "aspectTypeQName"})
    public boolean hasAspect(NodeRef var1, QName var2) throws InvalidNodeRefException, InvalidAspectException;

    @Auditable(parameters={"nodeRef"})
    public Set<QName> getAspects(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef"})
    public void deleteNode(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"parentRef", "childRef", "assocTypeQName", "qname"})
    public ChildAssociationRef addChild(NodeRef var1, NodeRef var2, QName var3, QName var4) throws InvalidNodeRefException;

    @Auditable(parameters={"parentRefs", "childRef", "assocTypeQName", "qname"})
    public List<ChildAssociationRef> addChild(Collection<NodeRef> var1, NodeRef var2, QName var3, QName var4) throws InvalidNodeRefException;

    @Auditable(parameters={"parentRef", "childRef"})
    public void removeChild(NodeRef var1, NodeRef var2) throws InvalidNodeRefException;

    @Auditable(parameters={"childAssocRef"})
    public boolean removeChildAssociation(ChildAssociationRef var1);

    @Auditable(parameters={"childAssocRef"})
    public boolean removeSeconaryChildAssociation(ChildAssociationRef var1);

    @Auditable(parameters={"childAssocRef"})
    public boolean removeSecondaryChildAssociation(ChildAssociationRef var1);

    @Auditable(parameters={"nodeRef"})
    public Map<QName, Serializable> getProperties(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef"})
    public Long getNodeAclId(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "qname"})
    public Serializable getProperty(NodeRef var1, QName var2) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "properties"})
    public void setProperties(NodeRef var1, Map<QName, Serializable> var2) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "properties"})
    public void addProperties(NodeRef var1, Map<QName, Serializable> var2) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "qname", "value"})
    public void setProperty(NodeRef var1, QName var2, Serializable var3) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "qname"})
    public void removeProperty(NodeRef var1, QName var2) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef"})
    public List<ChildAssociationRef> getParentAssocs(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "typeQNamePattern", "qnamePattern"})
    public List<ChildAssociationRef> getParentAssocs(NodeRef var1, QNamePattern var2, QNamePattern var3) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef"})
    public List<ChildAssociationRef> getChildAssocs(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "typeQNamePattern", "qnamePattern"})
    public List<ChildAssociationRef> getChildAssocs(NodeRef var1, QNamePattern var2, QNamePattern var3) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "typeQName", "qname", "maxResults", "preload"})
    public List<ChildAssociationRef> getChildAssocs(NodeRef var1, QName var2, QName var3, int var4, boolean var5) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "typeQNamePattern", "qnamePattern"})
    public List<ChildAssociationRef> getChildAssocs(NodeRef var1, QNamePattern var2, QNamePattern var3, boolean var4) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "childNodeTypes"})
    public List<ChildAssociationRef> getChildAssocs(NodeRef var1, Set<QName> var2);

    @Auditable(parameters={"nodeRef", "propertyQName", "value"})
    public List<ChildAssociationRef> getChildAssocsByPropertyValue(NodeRef var1, QName var2, Serializable var3);

    @Auditable(parameters={"nodeRef", "assocTypeQName", "childName"})
    public NodeRef getChildByName(NodeRef var1, QName var2, String var3);

    @Auditable(parameters={"nodeRef", "assocTypeQName", "childName"})
    public List<ChildAssociationRef> getChildrenByName(NodeRef var1, QName var2, Collection<String> var3);

    @Auditable(parameters={"nodeRef"})
    public ChildAssociationRef getPrimaryParent(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"parent", "assocTypeQName"})
    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(NodeRef var1, QName var2);

    @Auditable(parameters={"sourceRef", "targetRef", "assocTypeQName", "insertAfter"})
    public AssociationRef createAssociation(NodeRef var1, NodeRef var2, QName var3) throws InvalidNodeRefException, AssociationExistsException;

    @Auditable(parameters={"sourceRef", "targetRef", "assocTypeQName"})
    public void removeAssociation(NodeRef var1, NodeRef var2, QName var3) throws InvalidNodeRefException;

    @Auditable(parameters={"sourceRef", "assocTypeQName", "targetRefs"})
    public void setAssociations(NodeRef var1, QName var2, List<NodeRef> var3);

    public AssociationRef getAssoc(Long var1);

    @Auditable(parameters={"sourceRef", "qnamePattern"})
    public List<AssociationRef> getTargetAssocs(NodeRef var1, QNamePattern var2) throws InvalidNodeRefException;

    @Auditable(parameters={"targetRef", "qnamePattern"})
    public List<AssociationRef> getSourceAssocs(NodeRef var1, QNamePattern var2) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef"})
    public Path getPath(NodeRef var1) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "primaryOnly"})
    public List<Path> getPaths(NodeRef var1, boolean var2) throws InvalidNodeRefException;

    @Auditable(parameters={"storeRef"})
    public NodeRef getStoreArchiveNode(StoreRef var1);

    @Auditable(parameters={"archivedNodeRef", "destinationParentNodeRef", "assocTypeQName", "assocQName"})
    public NodeRef restoreNode(NodeRef var1, NodeRef var2, QName var3, QName var4);

    public List<NodeRef> findNodes(FindNodeParameters var1);

    @Auditable(parameters={"nodeRef", "isPrimary"})
    public int countChildAssocs(NodeRef var1, boolean var2) throws InvalidNodeRefException;

    public static class FindNodeParameters {
        private Long minNodeId;
        private Long maxNodeId;
        private List<QName> nodeTypes;
        private List<QName> nodeAspects;
        private boolean sortAscending = true;
        private int limit = 10000;

        public Long getMinNodeId() {
            return this.minNodeId;
        }

        public void setMinNodeId(Long minNodeId) {
            this.minNodeId = minNodeId;
        }

        public Long getMaxNodeId() {
            return this.maxNodeId;
        }

        public void setMaxNodeId(Long maxNodeId) {
            this.maxNodeId = maxNodeId;
        }

        public List<QName> getNodeTypes() {
            return this.nodeTypes;
        }

        public void setNodeTypes(List<QName> nodeTypes) {
            this.nodeTypes = nodeTypes;
        }

        public List<QName> getNodeAspects() {
            return this.nodeAspects;
        }

        public void setNodeAspects(List<QName> nodeAspects) {
            this.nodeAspects = nodeAspects;
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public void setSortAscending(boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }
    }
}

