/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.alfresco.encryption.CachedKey;
import org.alfresco.encryption.EncryptionKeysRegistry;
import org.alfresco.encryption.InvalidKeystoreException;
import org.alfresco.encryption.KeyMap;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.MissingKeyException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoKeyStoreImpl
implements AlfrescoKeyStore {
    private static final Log logger = LogFactory.getLog(AlfrescoKeyStoreImpl.class);
    protected KeyStoreParameters keyStoreParameters;
    protected KeyStoreParameters backupKeyStoreParameters;
    protected KeyResourceLoader keyResourceLoader;
    protected EncryptionKeysRegistry encryptionKeysRegistry;
    protected KeyMap keys;
    protected KeyMap backupKeys;
    protected final ReentrantReadWriteLock.WriteLock writeLock;
    protected final ReentrantReadWriteLock.ReadLock readLock;
    private static Set<String> keysToValidate = Collections.singleton("metadata");
    protected boolean validateKeyChanges = false;

    public AlfrescoKeyStoreImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
        this.keys = new KeyMap();
        this.backupKeys = new KeyMap();
    }

    public AlfrescoKeyStoreImpl(KeyStoreParameters keyStoreParameters, KeyResourceLoader keyResourceLoader) {
        this();
        this.keyResourceLoader = keyResourceLoader;
        this.keyStoreParameters = keyStoreParameters;
        this.safeInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.writeLock.lock();
        try {
            this.safeInit();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setEncryptionKeysRegistry(EncryptionKeysRegistry encryptionKeysRegistry) {
        this.encryptionKeysRegistry = encryptionKeysRegistry;
    }

    public void setValidateKeyChanges(boolean validateKeyChanges) {
        this.validateKeyChanges = validateKeyChanges;
    }

    public void setKeyStoreParameters(KeyStoreParameters keyStoreParameters) {
        this.keyStoreParameters = keyStoreParameters;
    }

    public void setBackupKeyStoreParameters(KeyStoreParameters backupKeyStoreParameters) {
        this.backupKeyStoreParameters = backupKeyStoreParameters;
    }

    public void setKeyResourceLoader(KeyResourceLoader keyResourceLoader) {
        this.keyResourceLoader = keyResourceLoader;
    }

    @Override
    public KeyStoreParameters getKeyStoreParameters() {
        return this.keyStoreParameters;
    }

    @Override
    public KeyStoreParameters getBackupKeyStoreParameters() {
        return this.backupKeyStoreParameters;
    }

    public KeyResourceLoader getKeyResourceLoader() {
        return this.keyResourceLoader;
    }

    @Override
    public String getName() {
        return this.keyStoreParameters.getName();
    }

    @Override
    public void validateKeys() throws InvalidKeystoreException, MissingKeyException {
        this.validateKeys(this.keys, this.backupKeys);
    }

    @Override
    public boolean exists() {
        return this.keyStoreExists(this.getKeyStoreParameters().getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws InvalidKeystoreException, MissingKeyException {
        KeyMap keys = this.loadKeyStore(this.getKeyStoreParameters());
        KeyMap backupKeys = this.loadKeyStore(this.getBackupKeyStoreParameters());
        this.validateKeys(keys, backupKeys);
        this.writeLock.lock();
        try {
            this.keys = keys;
            this.backupKeys = backupKeys;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<String> getKeyAliases() {
        return new HashSet<String>(this.keys.getKeyAliases());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup() {
        this.writeLock.lock();
        try {
            for (String keyAlias : this.keys.getKeyAliases()) {
                this.backupKeys.setKey(keyAlias, this.keys.getKey(keyAlias));
            }
            this.createKeyStore(this.backupKeyStoreParameters, this.backupKeys);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void create() {
        this.createKeyStore(this.keyStoreParameters, this.keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getKey(String keyAlias) {
        this.readLock.lock();
        try {
            Key key = this.keys.getCachedKey(keyAlias).getKey();
            return key;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getKeyTimestamp(String keyAlias) {
        this.readLock.lock();
        try {
            CachedKey cachedKey = this.keys.getCachedKey(keyAlias);
            long l = cachedKey.getTimestamp();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getBackupKey(String keyAlias) {
        this.readLock.lock();
        try {
            Key key = this.backupKeys.getCachedKey(keyAlias).getKey();
            return key;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public KeyManager[] createKeyManagers() {
        KeyInfoManager keyInfoManager = null;
        try {
            keyInfoManager = this.getKeyInfoManager(this.getKeyMetaDataFileLocation());
            KeyStore ks = this.loadKeyStore(this.keyStoreParameters, keyInfoManager);
            logger.debug((Object)"Initializing key managers");
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyStorePassword = keyInfoManager.getKeyStorePassword();
            kmfactory.init(ks, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
            KeyManager[] keyManagerArray = kmfactory.getKeyManagers();
            return keyManagerArray;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to create key manager", e);
        }
        finally {
            if (keyInfoManager != null) {
                keyInfoManager.clear();
            }
        }
    }

    @Override
    public TrustManager[] createTrustManagers() {
        KeyInfoManager keyInfoManager = null;
        try {
            keyInfoManager = this.getKeyInfoManager(this.getKeyMetaDataFileLocation());
            KeyStore ks = this.loadKeyStore(this.getKeyStoreParameters(), keyInfoManager);
            logger.debug((Object)"Initializing trust managers");
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(ks);
            TrustManager[] trustManagerArray = tmfactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to create key manager", e);
        }
        finally {
            if (keyInfoManager != null) {
                keyInfoManager.clear();
            }
        }
    }

    protected String getKeyMetaDataFileLocation() {
        return this.keyStoreParameters.getKeyMetaDataFileLocation();
    }

    protected InputStream getKeyStoreStream(String location) throws FileNotFoundException {
        if (location == null) {
            return null;
        }
        return this.keyResourceLoader.getKeyStore(location);
    }

    protected KeyInfoManager getKeyInfoManager(String metadataFileLocation) throws FileNotFoundException, IOException {
        return new KeyInfoManager(metadataFileLocation, this.keyResourceLoader);
    }

    protected KeyMap cacheKeys(KeyStore ks, KeyInfoManager keyInfoManager) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        KeyMap keys = new KeyMap();
        for (Map.Entry<String, KeyInformation> keyEntry : keyInfoManager.getKeyInfo().entrySet()) {
            String keyAlias = keyEntry.getKey();
            KeyInformation keyInfo = keyInfoManager.getKeyInformation(keyAlias);
            String passwordStr = keyInfo != null ? keyInfo.getPassword() : null;
            Key key = null;
            key = ks.getKey(keyAlias, passwordStr == null ? null : passwordStr.toCharArray());
            if (key != null) {
                keys.setKey(keyAlias, key);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Retrieved key from keystore: \n   Location: " + this.getKeyStoreParameters().getLocation() + "\n" + "   Provider: " + this.getKeyStoreParameters().getProvider() + "\n" + "   Type:     " + this.getKeyStoreParameters().getType() + "\n" + "   Alias:    " + keyAlias + "\n" + "   Password?: " + (passwordStr != null)));
            Certificate[] certs = ks.getCertificateChain(keyAlias);
            if (certs == null) continue;
            logger.debug((Object)("Certificate chain '" + keyAlias + "':"));
            for (int c = 0; c < certs.length; ++c) {
                if (!(certs[c] instanceof X509Certificate)) continue;
                X509Certificate cert = (X509Certificate)certs[c];
                logger.debug((Object)(" Certificate " + (c + 1) + ":"));
                logger.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                logger.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                logger.debug((Object)("  Valid from: " + cert.getNotBefore()));
                logger.debug((Object)("  Valid until: " + cert.getNotAfter()));
                logger.debug((Object)("  Issuer: " + cert.getIssuerDN()));
            }
        }
        return keys;
    }

    protected KeyStore initialiseKeyStore(String type, String provider) {
        KeyStore ks = null;
        try {
            ks = provider == null || provider.equals("") ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            ks.load(null, null);
            return ks;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to intialise key store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore loadKeyStore(KeyStoreParameters keyStoreParameters, KeyInfoManager keyInfoManager) {
        String pwdKeyStore = null;
        try {
            KeyStore ks = this.initialiseKeyStore(keyStoreParameters.getType(), keyStoreParameters.getProvider());
            InputStream is = this.getKeyStoreStream(keyStoreParameters.getLocation());
            if (is != null) {
                try {
                    pwdKeyStore = keyInfoManager.getKeyStorePassword();
                    ks.load(is, pwdKeyStore == null ? null : pwdKeyStore.toCharArray());
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Throwable e) {}
                }
            }
            logger.warn((Object)("Keystore file doesn't exist: " + keyStoreParameters.getLocation()));
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to load key store: " + keyStoreParameters.getLocation(), e);
        }
        finally {
            pwdKeyStore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeInit() {
        PropertyCheck.mandatory(this, "location", this.getKeyStoreParameters().getLocation());
        if (this.getKeyStoreParameters().getType() == null) {
            this.keyStoreParameters.setType(KeyStore.getDefaultType());
        }
        this.writeLock.lock();
        try {
            this.keys = this.loadKeyStore(this.keyStoreParameters);
            this.backupKeys = this.loadKeyStore(this.backupKeyStoreParameters);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private KeyMap loadKeyStore(KeyStoreParameters keyStoreParameters) {
        InputStream is = null;
        KeyInfoManager keyInfoManager = null;
        KeyStore ks = null;
        if (keyStoreParameters == null) {
            return new KeyMap();
        }
        try {
            keyInfoManager = this.getKeyInfoManager(keyStoreParameters.getKeyMetaDataFileLocation());
            ks = this.loadKeyStore(keyStoreParameters, keyInfoManager);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to initialize keystore: \n   Location: " + this.getKeyStoreParameters().getLocation() + "\n" + "   Provider: " + this.getKeyStoreParameters().getProvider() + "\n" + "   Type:     " + this.getKeyStoreParameters().getType(), e);
        }
        finally {
            if (keyInfoManager != null) {
                keyInfoManager.clearKeyStorePassword();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        try {
            KeyMap keys = this.cacheKeys(ks, keyInfoManager);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initialized keystore: \n   Location: " + this.getKeyStoreParameters().getLocation() + "\n" + "   Provider: " + this.getKeyStoreParameters().getProvider() + "\n" + "   Type:     " + this.getKeyStoreParameters().getType() + "\n" + keys.numKeys() + " keys found"));
            }
            KeyMap keyMap = keys;
            return keyMap;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to retrieve keys from keystore: \n   Location: " + this.getKeyStoreParameters().getLocation() + "\n" + "   Provider: " + this.getKeyStoreParameters().getProvider() + "\n" + "   Type:     " + this.getKeyStoreParameters().getType() + "\n", e);
        }
        finally {
            keyInfoManager.clear();
        }
    }

    protected void createKey(String keyAlias) {
        KeyInfoManager keyInfoManager = null;
        try {
            keyInfoManager = this.getKeyInfoManager(this.getKeyMetaDataFileLocation());
            Key key = this.getSecretKey(keyInfoManager.getKeyInformation(keyAlias));
            this.encryptionKeysRegistry.registerKey(keyAlias, key);
            this.keys.setKey(keyAlias, key);
            logger.info((Object)("Created key: " + keyAlias + "\n in key store: \n" + "   Location: " + this.getKeyStoreParameters().getLocation() + "\n" + "   Provider: " + this.getKeyStoreParameters().getProvider() + "\n" + "   Type:     " + this.getKeyStoreParameters().getType()));
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to create key: " + keyAlias + "\n in key store: \n" + "   Location: " + this.getKeyStoreParameters().getLocation() + "\n" + "   Provider: " + this.getKeyStoreParameters().getProvider() + "\n" + "   Type:     " + this.getKeyStoreParameters().getType(), e);
        }
        finally {
            if (keyInfoManager != null) {
                keyInfoManager.clear();
            }
        }
    }

    protected void createKeyStore(KeyStoreParameters keyStoreParameters, KeyMap keys) {
        KeyInfoManager keyInfoManager = null;
        try {
            if (!this.keyStoreExists(keyStoreParameters.getLocation())) {
                keyInfoManager = this.getKeyInfoManager(keyStoreParameters.getKeyMetaDataFileLocation());
                KeyStore ks = this.initialiseKeyStore(keyStoreParameters.getType(), keyStoreParameters.getProvider());
                String keyStorePassword = keyInfoManager.getKeyStorePassword();
                if (keyStorePassword == null) {
                    throw new AlfrescoRuntimeException("Key store password is null for keystore at location " + this.getKeyStoreParameters().getLocation() + ", key store meta data location" + this.getKeyMetaDataFileLocation());
                }
                for (String keyAlias : keys.getKeyAliases()) {
                    KeyInformation keyInfo = keyInfoManager.getKeyInformation(keyAlias);
                    Key key = keys.getKey(keyAlias);
                    if (key == null) {
                        logger.warn((Object)("Key with alias " + keyAlias + " is null when creating keystore at location " + keyStoreParameters.getLocation()));
                        continue;
                    }
                    ks.setKeyEntry(keyAlias, key, keyInfo.getPassword().toCharArray(), null);
                }
                ks.store(new FileOutputStream(keyStoreParameters.getLocation()), keyStorePassword.toCharArray());
            } else {
                logger.warn((Object)("Can't create key store " + keyStoreParameters.getLocation() + ", already exists."));
            }
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to create keystore: \n   Location: " + keyStoreParameters.getLocation() + "\n" + "   Provider: " + keyStoreParameters.getProvider() + "\n" + "   Type:     " + keyStoreParameters.getType(), e);
        }
        finally {
            if (keyInfoManager != null) {
                keyInfoManager.clear();
            }
        }
    }

    private byte[] generateKeyData() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(System.currentTimeMillis());
            byte[] bytes = new byte[24];
            random.nextBytes(bytes);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate secret key", e);
        }
    }

    protected Key getSecretKey(KeyInformation keyInformation) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        byte[] keyData = keyInformation.getKeyData();
        if (keyData == null) {
            if (keyInformation.getKeyAlgorithm().equals("DESede")) {
                keyData = this.generateKeyData();
            } else {
                throw new AlfrescoRuntimeException("Unable to generate secret key: key algorithm is not DESede and no keyData provided");
            }
        }
        DESedeKeySpec keySpec = new DESedeKeySpec(keyData);
        SecretKeyFactory kf = SecretKeyFactory.getInstance(keyInformation.getKeyAlgorithm());
        SecretKey secretKey = kf.generateSecret(keySpec);
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importPrivateKey(String keyAlias, String keyPassword, InputStream fl, InputStream certstream) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, CertificateException, KeyStoreException {
        KeyInfoManager keyInfoManager = null;
        this.writeLock.lock();
        try {
            keyInfoManager = this.getKeyInfoManager(this.getKeyMetaDataFileLocation());
            KeyStore ks = this.loadKeyStore(this.getKeyStoreParameters(), keyInfoManager);
            byte[] keyBytes = new byte[fl.available()];
            KeyFactory kf = KeyFactory.getInstance("RSA");
            fl.read(keyBytes, 0, fl.available());
            fl.close();
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey key = kf.generatePrivate(keysp);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(certstream);
            Certificate[] certs = new Certificate[c.toArray().length];
            certs = c.toArray(new Certificate[0]);
            ks.setKeyEntry(keyAlias, key, keyPassword.toCharArray(), certs);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Key and certificate stored.");
                logger.debug((Object)("Alias:" + keyAlias));
            }
            ks.store(new FileOutputStream(this.getKeyStoreParameters().getLocation()), keyPassword.toCharArray());
        }
        finally {
            if (keyInfoManager != null) {
                keyInfoManager.clear();
            }
            this.writeLock.unlock();
        }
    }

    public boolean backupExists() {
        return this.keyStoreExists(this.getBackupKeyStoreParameters().getLocation());
    }

    protected boolean keyStoreExists(String location) {
        try {
            InputStream is = this.getKeyStoreStream(location);
            if (is == null) {
                return false;
            }
            try {
                is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateKeys(KeyMap keys, KeyMap backupKeys) throws InvalidKeystoreException, MissingKeyException {
        if (!this.validateKeyChanges) {
            return;
        }
        this.writeLock.lock();
        try {
            for (String keyAlias : keysToValidate) {
                if (keys.getKey(keyAlias) == null) {
                    if (backupKeys.getKey(keyAlias) != null) continue;
                    if (this.encryptionKeysRegistry.isKeyRegistered(keyAlias)) {
                        throw new MissingKeyException(keyAlias, this.getKeyStoreParameters().getLocation());
                    }
                    this.createKey(keyAlias);
                    continue;
                }
                if (!this.encryptionKeysRegistry.isKeyRegistered(keyAlias)) {
                    this.encryptionKeysRegistry.registerKey(keyAlias, keys.getKey(keyAlias));
                    continue;
                }
                if (backupKeys.getKey(keyAlias) == null && this.encryptionKeysRegistry.checkKey(keyAlias, keys.getKey(keyAlias)) == EncryptionKeysRegistry.KEY_STATUS.CHANGED) {
                    throw new InvalidKeystoreException("The key with alias " + keyAlias + " has been changed, re-instate the previous keystore");
                }
                if (backupKeys.getKey(keyAlias) == null || !this.encryptionKeysRegistry.isKeyRegistered(keyAlias) || this.encryptionKeysRegistry.checkKey(keyAlias, backupKeys.getKey(keyAlias)) != EncryptionKeysRegistry.KEY_STATUS.OK) continue;
                this.encryptionKeysRegistry.unregisterKey(keyAlias);
                this.encryptionKeysRegistry.registerKey(keyAlias, keys.getKey(keyAlias));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static class KeyInfoManager {
        private KeyResourceLoader keyResourceLoader;
        private String metadataFileLocation;
        private Properties keyProps;
        private String keyStorePassword = null;
        private Map<String, KeyInformation> keyInfo;

        KeyInfoManager(Map<String, String> passwords, KeyResourceLoader keyResourceLoader) {
            this.keyResourceLoader = keyResourceLoader;
            this.keyInfo = new HashMap<String, KeyInformation>(2);
            for (Map.Entry<String, String> password : passwords.entrySet()) {
                this.keyInfo.put(password.getKey(), new KeyInformation(password.getKey(), null, password.getValue(), null));
            }
        }

        KeyInfoManager(String metadataFileLocation, KeyResourceLoader keyResourceLoader) throws IOException, FileNotFoundException {
            this.keyResourceLoader = keyResourceLoader;
            this.metadataFileLocation = metadataFileLocation;
            this.keyInfo = new HashMap<String, KeyInformation>(2);
            this.loadKeyMetaData();
        }

        public Map<String, KeyInformation> getKeyInfo() {
            return this.keyInfo;
        }

        protected void loadKeyMetaData() throws IOException, FileNotFoundException {
            this.keyProps = this.keyResourceLoader.loadKeyMetaData(this.metadataFileLocation);
            if (this.keyProps != null) {
                String aliases = this.keyProps.getProperty("aliases");
                if (aliases == null) {
                    throw new AlfrescoRuntimeException("Passwords file must contain an aliases key");
                }
                this.keyStorePassword = this.keyProps.getProperty("keystore.password");
                StringTokenizer st = new StringTokenizer(aliases, ",");
                while (st.hasMoreTokens()) {
                    String keyAlias = st.nextToken();
                    this.keyInfo.put(keyAlias, this.loadKeyInformation(keyAlias));
                }
            }
        }

        public void clear() {
            this.keyStorePassword = null;
            if (this.keyProps != null) {
                this.keyProps.clear();
            }
        }

        public void removeKeyInformation(String keyAlias) {
            this.keyProps.remove(keyAlias);
        }

        protected KeyInformation loadKeyInformation(String keyAlias) {
            String keyPassword = this.keyProps.getProperty(keyAlias + ".password");
            String keyData = this.keyProps.getProperty(keyAlias + ".keyData");
            String keyAlgorithm = this.keyProps.getProperty(keyAlias + ".algorithm");
            byte[] keyDataBytes = null;
            if (keyData != null && !keyData.equals("")) {
                keyDataBytes = Base64.decodeBase64((String)keyData);
            }
            KeyInformation keyInfo = new KeyInformation(keyAlias, keyDataBytes, keyPassword, keyAlgorithm);
            return keyInfo;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void clearKeyStorePassword() {
            this.keyStorePassword = null;
        }

        public KeyInformation getKeyInformation(String keyAlias) {
            return this.keyInfo.get(keyAlias);
        }
    }

    public static class KeyInformation {
        protected String alias;
        protected byte[] keyData;
        protected String password;
        protected String keyAlgorithm;

        public KeyInformation(String alias, byte[] keyData, String password, String keyAlgorithm) {
            this.alias = alias;
            this.keyData = keyData;
            this.password = password;
            this.keyAlgorithm = keyAlgorithm;
        }

        public String getAlias() {
            return this.alias;
        }

        public byte[] getKeyData() {
            return this.keyData;
        }

        public String getPassword() {
            return this.password;
        }

        public String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }
    }
}

