/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ISO8601DateFormat;

public class ISO8601DateFormatTest
extends TestCase {
    public void testConversion() {
        String test = "2005-09-16T17:01:03.456+01:00";
        Date date = ISO8601DateFormat.parse(test);
        String strDate = ISO8601DateFormat.format(date);
        Date dateAfter = ISO8601DateFormat.parse(strDate);
        ISO8601DateFormatTest.assertEquals((Object)date, (Object)dateAfter);
    }

    public void testMiliseconds() {
        String testA = "2005-09-16T17:01:03.456+01:00";
        String testB = "2005-09-16T17:01:03+01:00";
        String testBms = "2005-09-16T17:01:03.000+01:00";
        Date dateA = ISO8601DateFormat.parse(testA);
        Date dateB = ISO8601DateFormat.parse(testB);
        ISO8601DateFormatTest.assertEquals((String)testA, (String)ISO8601DateFormat.format(dateA));
        ISO8601DateFormatTest.assertEquals((String)testBms, (String)ISO8601DateFormat.format(dateB));
        String testCms3 = "2005-09-16T17:01:03.123+01:00";
        String testCms4 = "2005-09-16T17:01:03.1234+01:00";
        String testCms5 = "2005-09-16T17:01:03.12345+01:00";
        String testCms6 = "2005-09-16T17:01:03.123456+01:00";
        String testCms7 = "2005-09-16T17:01:03.1234567+01:00";
        Date testC = ISO8601DateFormat.parse(testCms3);
        ISO8601DateFormatTest.assertEquals((Object)testC, (Object)ISO8601DateFormat.parse(testCms4));
        ISO8601DateFormatTest.assertEquals((Object)testC, (Object)ISO8601DateFormat.parse(testCms5));
        ISO8601DateFormatTest.assertEquals((Object)testC, (Object)ISO8601DateFormat.parse(testCms6));
        ISO8601DateFormatTest.assertEquals((Object)testC, (Object)ISO8601DateFormat.parse(testCms7));
    }

    public void testTimezones() {
        Date date = null;
        date = ISO8601DateFormat.parse("2011-02-04T12:13:14Z");
        try {
            ISO8601DateFormat.parse("2011-02-04T12:13:14");
            ISO8601DateFormatTest.fail((String)"TimeZones are required");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        TimeZone tz = TimeZone.getTimeZone("Europe/London");
        date = ISO8601DateFormat.parse("2011-02-04T12:13:14", tz);
        tz = TimeZone.getTimeZone("Australia/Sydney");
        String testSydney = "2011-02-04T16:13:14";
        String testUTC = "2011-02-04T05:13:14.000Z";
        date = ISO8601DateFormat.parse(testSydney, tz);
        ISO8601DateFormatTest.assertEquals((String)testUTC, (String)ISO8601DateFormat.format(date));
        date = ISO8601DateFormat.parse(testSydney + ".000", tz);
        ISO8601DateFormatTest.assertEquals((String)testUTC, (String)ISO8601DateFormat.format(date));
    }

    public void testDayOnly() {
        Date date = null;
        TimeZone tz = TimeZone.getTimeZone("Europe/London");
        date = ISO8601DateFormat.parseDayOnly("2012-05-21", tz);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(date);
        ISO8601DateFormatTest.assertEquals((int)2012, (int)cal.get(1));
        ISO8601DateFormatTest.assertEquals((int)4, (int)cal.get(2));
        ISO8601DateFormatTest.assertEquals((int)21, (int)cal.get(5));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(10));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(12));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(13));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(14));
        date = ISO8601DateFormat.parseDayOnly("2012-05-21T12:13:14Z", tz);
        cal = Calendar.getInstance(tz);
        cal.setTime(date);
        ISO8601DateFormatTest.assertEquals((int)2012, (int)cal.get(1));
        ISO8601DateFormatTest.assertEquals((int)4, (int)cal.get(2));
        ISO8601DateFormatTest.assertEquals((int)21, (int)cal.get(5));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(10));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(12));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(13));
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(14));
        date = ISO8601DateFormat.parseDayOnly("+2012-05-21", tz);
        cal = Calendar.getInstance(tz);
        cal.setTime(date);
        ISO8601DateFormatTest.assertEquals((int)1, (int)cal.get(0));
        date = ISO8601DateFormat.parseDayOnly("-2012-05-21", tz);
        cal = Calendar.getInstance(tz);
        cal.setTime(date);
        ISO8601DateFormatTest.assertEquals((int)0, (int)cal.get(0));
        try {
            ISO8601DateFormat.parseDayOnly("2011-02-0", tz);
            ISO8601DateFormatTest.fail((String)"Exception expected on illegal format");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        try {
            ISO8601DateFormat.parseDayOnly("201a-02-02", tz);
            ISO8601DateFormatTest.fail((String)"Exception expected on illegal format");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
    }
}

