/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import junit.framework.TestCase;
import org.alfresco.util.TempFileProvider;

public class TempFileProviderTest
extends TestCase {
    public void testTempDir() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        TempFileProviderTest.assertTrue((String)"Not a directory", (boolean)tempDir.isDirectory());
        File tempDirParent = tempDir.getParentFile();
        File tempFile = File.createTempFile("AAAA", ".tmp");
        File tempFileParent = tempFile.getParentFile();
        TempFileProviderTest.assertEquals((String)"Our temp dir not subdirectory system temp directory", (Object)tempFileParent, (Object)tempDirParent);
    }

    public void testTempFile() throws Exception {
        File tempFile = TempFileProvider.createTempFile("AAAA", ".tmp");
        File tempFileParent = tempFile.getParentFile();
        File tempDir = TempFileProvider.getTempDir();
        TempFileProviderTest.assertEquals((String)"Temp file not located in our temp directory", (Object)tempDir, (Object)tempFileParent);
        File tempFile2 = TempFileProvider.createTempFile("AAAA", ".tmp");
        tempFile2.delete();
    }

    public void testTempFileWithDir() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        File tempFile = TempFileProvider.createTempFile("AAAA", ".tmp", tempDir);
        File tempFileParent = tempFile.getParentFile();
        TempFileProviderTest.assertEquals((String)"Temp file not located in our temp directory", (Object)tempDir, (Object)tempFileParent);
        File tempFile2 = TempFileProvider.createTempFile("AAAA", ".tmp", tempDir);
        tempFile2.delete();
    }
}

