/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.bean;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HierarchicalBeanLoaderTest
extends TestCase {
    private ClassPathXmlApplicationContext ctx;

    private String getBean(Class<?> clazz, boolean setBeforeInit) throws Exception {
        if (setBeforeInit) {
            System.setProperty("hierarchy-test.dialect", clazz.getName());
        }
        this.ctx = new ClassPathXmlApplicationContext("bean-loader/hierarchical-bean-loader-test-context.xml");
        if (!setBeforeInit) {
            System.setProperty("hierarchy-test.dialect", clazz.getName());
        }
        return (String)this.ctx.getBean("test.someString");
    }

    public void tearDown() {
        try {
            this.ctx.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testSuccess1() throws Throwable {
        String str = this.getBean(TreeSet.class, true);
        HierarchicalBeanLoaderTest.assertEquals((String)"Bean value incorrect", (String)"TreeSet", (String)str);
    }

    public void testSuccess2() throws Throwable {
        String str = this.getBean(AbstractList.class, true);
        HierarchicalBeanLoaderTest.assertEquals((String)"Bean value incorrect", (String)"AbstractList", (String)str);
    }

    public void testSuccess3() throws Throwable {
        String str = this.getBean(AbstractCollection.class, true);
        HierarchicalBeanLoaderTest.assertEquals((String)"Bean value incorrect", (String)"AbstractCollection", (String)str);
    }

    public void testFailure1() throws Throwable {
        try {
            this.getBean(Collection.class, true);
            HierarchicalBeanLoaderTest.fail((String)("Should not be able to retrieve bean using class " + Collection.class));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

