/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.xmlbeans.XmlBeansDataBinding;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlByte;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlFloat;
import org.apache.xmlbeans.XmlInt;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlLong;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlShort;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

class XmlBeansSchemaInitializer
extends ServiceModelVisitor {
    private static final Logger LOG = LogUtils.getLogger(XmlBeansSchemaInitializer.class);
    private static final Map<Class<?>, Class<? extends XmlAnySimpleType>> CLASS_MAP = new HashMap();
    private SchemaCollection schemas;
    private XmlBeansDataBinding dataBinding;
    private Map<String, XmlSchema> schemaMap = new HashMap<String, XmlSchema>();

    public XmlBeansSchemaInitializer(ServiceInfo serviceInfo, SchemaCollection col, XmlBeansDataBinding db) {
        super(serviceInfo);
        this.schemas = col;
        this.dataBinding = db;
    }

    XmlSchema getSchema(SchemaTypeSystem sts, String file) {
        if (this.schemaMap.containsKey(file)) {
            return this.schemaMap.get(file);
        }
        InputStream ins = sts.getSourceAsStream(file);
        try {
            this.schemaMap.put(file, null);
            Document doc = XMLUtils.parse(ins);
            Element elem = DOMUtils.getFirstElement(doc.getDocumentElement());
            while (elem != null) {
                String loc;
                if (elem.getLocalName().equals("import") && !StringUtils.isEmpty(loc = elem.getAttribute("schemaLocation"))) {
                    this.getSchema(sts, loc);
                }
                elem = DOMUtils.getNextElement(elem);
            }
            XmlSchema schema = this.dataBinding.addSchemaDocument(this.serviceInfo, this.schemas, doc, file);
            this.schemaMap.put(file, schema);
            return schema;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find schema for: " + file, e);
        }
    }

    public void begin(MessagePartInfo part) {
        LOG.finest(part.getName().toString());
        if (part.getTypeQName() != null || part.getElementQName() != null) {
            this.checkForExistence(part);
            return;
        }
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
        if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
        }
        this.mapClass(part, clazz);
    }

    private void mapClass(MessagePartInfo part, Class clazz) {
        if (!XmlObject.class.isAssignableFrom(clazz)) {
            Class<? extends XmlAnySimpleType> type = CLASS_MAP.get(clazz);
            if (type == null) {
                LOG.log(Level.SEVERE, clazz.getName() + " was not found in class map");
                return;
            }
            SchemaTypeSystem sts = BuiltinSchemaTypeSystem.get();
            SchemaType st2 = sts.typeForClassname(type.getName());
            part.setProperty(SchemaType.class.getName(), st2);
            part.setProperty(XmlAnySimpleType.class.getName(), type);
            part.setTypeQName(st2.getName());
            XmlSchemaType xmlSchema = this.schemas.getTypeByQName(st2.getName());
            part.setXmlSchema((XmlSchemaAnnotated)xmlSchema);
            return;
        }
        try {
            Field field = clazz.getField("type");
            SchemaType st = (SchemaType)field.get(null);
            part.setProperty(SchemaType.class.getName(), st);
            SchemaTypeSystem sts = st.getTypeSystem();
            this.schemas.getXmlSchemaCollection().setSchemaResolver((URIResolver)new XMLSchemaResolver(sts));
            XmlSchema schema = this.getSchema(sts, st.getSourceName());
            if (st.isDocumentType()) {
                XmlSchemaElement sct = schema.getElementByName(st.getDocumentElementName());
                part.setXmlSchema((XmlSchemaAnnotated)sct);
                part.setElement(true);
                part.setElementQName(st.getDocumentElementName());
                part.setConcreteName(st.getDocumentElementName());
            } else if (st.getComponentType() == 1) {
                XmlSchemaElement sct = schema.getElementByName(st.getName());
                part.setXmlSchema((XmlSchemaAnnotated)sct);
                part.setElement(true);
            } else {
                XmlSchemaType sct = schema.getTypeByName(st.getName());
                part.setTypeQName(st.getName());
                part.setXmlSchema((XmlSchemaAnnotated)sct);
                part.setElement(false);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void checkForExistence(MessagePartInfo part) {
        XmlSchemaElement el;
        QName qn = part.getElementQName();
        if (qn != null && (el = this.schemas.getElementByQName(qn)) == null) {
            Class<?> clazz = part.getTypeClass();
            if (clazz == null) {
                return;
            }
            boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
            if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
                clazz = clazz.getComponentType();
            }
            this.mapClass(part, clazz);
        }
    }

    static {
        CLASS_MAP.put(String.class, XmlString.class);
        CLASS_MAP.put(Integer.class, XmlInt.class);
        CLASS_MAP.put(Integer.TYPE, XmlInt.class);
        CLASS_MAP.put(Short.class, XmlShort.class);
        CLASS_MAP.put(Short.TYPE, XmlShort.class);
        CLASS_MAP.put(Byte.class, XmlByte.class);
        CLASS_MAP.put(Byte.TYPE, XmlByte.class);
        CLASS_MAP.put(Float.class, XmlFloat.class);
        CLASS_MAP.put(Float.TYPE, XmlFloat.class);
        CLASS_MAP.put(Double.class, XmlDouble.class);
        CLASS_MAP.put(Double.TYPE, XmlDouble.class);
        CLASS_MAP.put(Long.class, XmlLong.class);
        CLASS_MAP.put(Long.TYPE, XmlLong.class);
        CLASS_MAP.put(Boolean.class, XmlBoolean.class);
        CLASS_MAP.put(Boolean.TYPE, XmlBoolean.class);
        CLASS_MAP.put(BigDecimal.class, XmlDecimal.class);
        CLASS_MAP.put(BigInteger.class, XmlInteger.class);
        CLASS_MAP.put(Date.class, XmlDate.class);
        CLASS_MAP.put(Calendar.class, XmlDate.class);
        CLASS_MAP.put(byte[].class, XmlBase64Binary.class);
    }

    public class XMLSchemaResolver
    implements URIResolver {
        final SchemaTypeSystem sts;

        public XMLSchemaResolver(SchemaTypeSystem sts) {
            this.sts = sts;
        }

        public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
            InputStream ins = this.sts.getSourceAsStream(schemaLocation);
            if (ins != null) {
                return new InputSource(ins);
            }
            return null;
        }
    }
}

