/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.youtube;

import com.google.gdata.client.Query;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YouTubeQuery
extends Query {
    private static final String VQ = "vq";
    private static final String TIME = "time";
    private static final String FORMAT = "format";
    private static final String ORDERBY = "orderby";
    private static final String RACY = "racy";
    private static final String RACY_INCLUDE = "include";
    private static final String RACY_EXCLUDE = "exclude";
    private static final String LANGUAGE_RESTRICT = "lr";
    private static final String RESTRICTION = "restriction";
    private static final String LOCATION = "location";
    private static final String LOCATION_RADIUS = "location-radius";
    private static final String SAFE_SEARCH = "safeSearch";
    private static final String UPLOADER = "uploader";
    private static final Pattern COUNTRY_CODE_PATTERN = Pattern.compile("[a-zA-Z]{2}");
    private static final Pattern IP_V4_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern LOCATION_RADIUS_PATTERN = Pattern.compile("\\d+(ft|mi|m|km)");
    private static final Pattern RELEVANCE_LANGUAGE_PATTERN = Pattern.compile("_lang_([^_]+)");

    public YouTubeQuery(URL feedUrl) {
        super(feedUrl);
    }

    @Deprecated
    public String getVideoQuery() {
        return this.getCustomParameterValue(VQ);
    }

    @Deprecated
    public void setVideoQuery(String query) {
        this.overwriteCustomParameter(VQ, query);
    }

    public Time getTime() {
        return Time.fromParameterValue(this.getCustomParameterValue(TIME));
    }

    public void setTime(Time time) {
        this.overwriteCustomParameter(TIME, time == null ? null : time.toParameterValue());
    }

    public Set<Integer> getFormats() {
        String[] formats;
        String value = this.getCustomParameterValue(FORMAT);
        if (value == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Integer> retval = new LinkedHashSet<Integer>();
        for (String format : formats = value.trim().split(" *, *")) {
            retval.add(new Integer(format));
        }
        return retval;
    }

    public void setFormats(int ... formats) {
        LinkedHashSet<Integer> formatSet = new LinkedHashSet<Integer>();
        for (int format : formats) {
            formatSet.add(format);
        }
        this.setFormats(formatSet);
    }

    public void setFormats(Set<Integer> formats) {
        if (formats == null || formats.isEmpty()) {
            this.overwriteCustomParameter(FORMAT, null);
            return;
        }
        StringBuilder stringValue = new StringBuilder();
        boolean isFirst = true;
        for (int format : formats) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringValue.append(',');
            }
            stringValue.append(format);
        }
        this.overwriteCustomParameter(FORMAT, stringValue.toString());
    }

    public void setLanguageRestrict(String languageCode) {
        this.overwriteCustomParameter(LANGUAGE_RESTRICT, languageCode);
    }

    public String getLanguageRestrict() {
        return this.getCustomParameterValue(LANGUAGE_RESTRICT);
    }

    public OrderBy getOrderby() {
        String stringValue = this.getCustomParameterValue(ORDERBY);
        if (stringValue != null && stringValue.startsWith("relevance_")) {
            return OrderBy.RELEVANCE;
        }
        return OrderBy.fromParameterValue(stringValue);
    }

    public void setOrderBy(OrderBy orderBy) {
        this.overwriteCustomParameter(ORDERBY, orderBy == null ? null : orderBy.toParameterValue());
    }

    public void setOrderByRelevanceForLanguage(String languageCode) {
        this.overwriteCustomParameter(ORDERBY, languageCode == null ? OrderBy.RELEVANCE.toParameterValue() : "relevance_lang_" + languageCode);
    }

    public String getOrderByRelevanceForLanguage() {
        String stringValue = this.getCustomParameterValue(ORDERBY);
        if (stringValue == null) {
            return null;
        }
        if (this.getOrderby() != OrderBy.RELEVANCE) {
            throw new IllegalStateException("Not ordering by relevance. Please check with getOrderBy() first");
        }
        if (stringValue == null) {
            return null;
        }
        Matcher matcher = RELEVANCE_LANGUAGE_PATTERN.matcher(stringValue);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public SafeSearch getSafeSearch() {
        String stringValue = this.getCustomParameterValue(SAFE_SEARCH);
        return SafeSearch.fromParameterValue(stringValue);
    }

    public void setSafeSearch(SafeSearch safeSearch) {
        this.overwriteCustomParameter(SAFE_SEARCH, safeSearch == null ? null : safeSearch.toParameterValue());
    }

    @Deprecated
    public boolean getIncludeRacy() {
        return RACY_INCLUDE.equals(this.getCustomParameterValue(RACY));
    }

    @Deprecated
    public void setIncludeRacy(Boolean includeRacy) {
        String stringValue = includeRacy == null ? null : (includeRacy != false ? RACY_INCLUDE : RACY_EXCLUDE);
        this.overwriteCustomParameter(RACY, stringValue);
    }

    public void setLocation(GeoRssWhere where) {
        StringBuilder location = new StringBuilder();
        if (where != null) {
            location.append(where.getLatitude()).append(",").append(where.getLongitude());
        }
        if (this.hasRestrictLocation()) {
            location.append("!");
        }
        this.overwriteCustomParameter(LOCATION, location.toString().equals("") ? null : location.toString());
    }

    public GeoRssWhere getLocation() {
        String location = this.getCustomParameterValue(LOCATION);
        location = location.replaceAll("!", "");
        String[] parts = location.split(",");
        return new GeoRssWhere(Double.valueOf(Double.parseDouble(parts[0])), Double.valueOf(Double.parseDouble(parts[1])));
    }

    public void setLocationRadius(String locationRadius) {
        if (locationRadius != null && !LOCATION_RADIUS_PATTERN.matcher(locationRadius).matches()) {
            throw new IllegalArgumentException("Invalid location radius: " + locationRadius);
        }
        this.overwriteCustomParameter(LOCATION_RADIUS, locationRadius);
    }

    public String getLocationRadius() {
        return this.getCustomParameterValue(LOCATION_RADIUS);
    }

    public void setRestrictLocation(boolean isRestrictLocation) {
        String location = this.getCustomParameterValue(LOCATION);
        if (location == null) {
            location = "";
        }
        if (isRestrictLocation) {
            if (!location.endsWith("!")) {
                this.overwriteCustomParameter(LOCATION, location + "!");
            }
        } else {
            if ((location = location.replaceAll("!", "")).length() == 0) {
                location = null;
            }
            this.overwriteCustomParameter(LOCATION, location);
        }
    }

    public boolean hasRestrictLocation() {
        String location = this.getCustomParameterValue(LOCATION);
        return location != null && location.endsWith("!");
    }

    public String getCountryRestriction() {
        String restriction = this.getCustomParameterValue(RESTRICTION);
        if (restriction == null) {
            return null;
        }
        return COUNTRY_CODE_PATTERN.matcher(restriction).matches() ? restriction : null;
    }

    public void setCountryRestriction(String countryCode) {
        if (countryCode != null && !COUNTRY_CODE_PATTERN.matcher(countryCode).matches()) {
            throw new IllegalArgumentException("Invalid country code: " + countryCode);
        }
        this.overwriteCustomParameter(RESTRICTION, countryCode);
    }

    public String getIpRestriction() {
        String restriction = this.getCustomParameterValue(RESTRICTION);
        if (restriction == null) {
            return null;
        }
        return IP_V4_PATTERN.matcher(restriction).matches() ? restriction : null;
    }

    public void setIpRestriction(String ip) {
        if (ip != null && !IP_V4_PATTERN.matcher(ip).matches()) {
            throw new IllegalArgumentException("Invalid IP v4 address: " + ip);
        }
        this.overwriteCustomParameter(RESTRICTION, ip);
    }

    void overwriteCustomParameter(String name, String value) {
        List customParams = this.getCustomParameters();
        for (Query.CustomParameter existingValue : this.getCustomParameters(name)) {
            customParams.remove(existingValue);
        }
        if (value != null) {
            customParams.add(new Query.CustomParameter(name, value));
        }
    }

    String getCustomParameterValue(String parameterName) {
        List customParams = this.getCustomParameters(parameterName);
        if (customParams.isEmpty()) {
            return null;
        }
        return ((Query.CustomParameter)customParams.get(0)).getValue();
    }

    public Uploader getUploader() {
        String stringValue = this.getCustomParameterValue(UPLOADER);
        return Uploader.fromParameterValue(stringValue);
    }

    public void setUploader(Uploader uploader) {
        this.overwriteCustomParameter(UPLOADER, uploader == null ? null : uploader.toParameterValue());
    }

    public static enum Uploader {
        PARTNER("partner");

        private final String value;
        private static Map<String, Uploader> PARAMETER_TO_UPLOADER;

        private Uploader(String value) {
            this.value = value;
        }

        public String toParameterValue() {
            return this.value;
        }

        public static Uploader fromParameterValue(String value) {
            if (value == null) {
                return null;
            }
            Uploader uploader = PARAMETER_TO_UPLOADER.get(value);
            if (uploader == null) {
                throw new IllegalStateException("Cannot convert uploader value: " + value);
            }
            return uploader;
        }

        static {
            HashMap<String, Uploader> map = new HashMap<String, Uploader>();
            for (Uploader uploader : Uploader.values()) {
                map.put(uploader.toParameterValue(), uploader);
            }
            PARAMETER_TO_UPLOADER = Collections.unmodifiableMap(map);
        }
    }

    public static enum SafeSearch {
        NONE("none"),
        MODERATE("moderate"),
        STRICT("strict");

        private final String value;
        private static Map<String, SafeSearch> PARAMETER_TO_SAFESEARCH;

        private SafeSearch(String value) {
            this.value = value;
        }

        public String toParameterValue() {
            return this.value;
        }

        public static SafeSearch fromParameterValue(String value) {
            if (value == null) {
                return null;
            }
            SafeSearch safeSearch = PARAMETER_TO_SAFESEARCH.get(value);
            if (safeSearch == null) {
                throw new IllegalStateException("Cannot convert safeSearch value: " + value);
            }
            return safeSearch;
        }

        static {
            HashMap<String, SafeSearch> map = new HashMap<String, SafeSearch>();
            for (SafeSearch safeSearch : SafeSearch.values()) {
                map.put(safeSearch.toParameterValue(), safeSearch);
            }
            PARAMETER_TO_SAFESEARCH = Collections.unmodifiableMap(map);
        }
    }

    public static enum OrderBy {
        RELEVANCE("relevance"),
        UPDATED("updated"),
        VIEW_COUNT("viewCount"),
        RATING("rating"),
        PUBLISHED("published");

        private final String value;
        private static Map<String, OrderBy> PARAMETER_TO_ORDERBY;

        private OrderBy(String value) {
            this.value = value;
        }

        public String toParameterValue() {
            return this.value;
        }

        public static OrderBy fromParameterValue(String value) {
            if (value == null) {
                return null;
            }
            OrderBy orderBy = PARAMETER_TO_ORDERBY.get(value);
            if (orderBy == null) {
                throw new IllegalStateException("Cannot convert orderBy value: " + value);
            }
            return orderBy;
        }

        static {
            HashMap<String, OrderBy> map = new HashMap<String, OrderBy>();
            for (OrderBy orderBy : OrderBy.values()) {
                map.put(orderBy.toParameterValue(), orderBy);
            }
            PARAMETER_TO_ORDERBY = Collections.unmodifiableMap(map);
        }
    }

    public static enum Time {
        TODAY("today"),
        THIS_WEEK("this_week"),
        THIS_MONTH("this_month"),
        ALL_TIME("all_time");

        private final String value;
        private static Map<String, Time> PARAMETER_TO_TIME;

        private Time(String value) {
            this.value = value;
        }

        public String toParameterValue() {
            return this.value;
        }

        public static Time fromParameterValue(String value) {
            if (value == null) {
                return null;
            }
            Time time = PARAMETER_TO_TIME.get(value);
            if (time == null) {
                throw new IllegalStateException("Cannot convert time value: " + value);
            }
            return time;
        }

        static {
            HashMap<String, Time> map = new HashMap<String, Time>();
            for (Time time : Time.values()) {
                map.put(time.toParameterValue(), time);
            }
            PARAMETER_TO_TIME = Collections.unmodifiableMap(map);
        }
    }
}

