/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import com.google.gdata.data.youtube.EntryUtils;

@Kind.Term(value="http://gdata.youtube.com/schemas/2007#complaint")
public class ComplaintEntry
extends BaseEntry<ComplaintEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/complaint-reasons.cat"};

    public ComplaintEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#complaint");
    }

    public ComplaintEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#complaint");
    }

    public void addVideoUrl(String url) {
        Link link = new Link();
        link.setRel("related");
        link.setType(ILink.Type.ATOM);
        link.setHref(url);
        this.getLinks().add(link);
    }

    public String getVideoUrl() {
        Link link = this.getLink("related", ILink.Type.ATOM);
        return link == null ? null : link.getHref();
    }

    public void setComment(String comment) {
        this.setContent((TextConstruct)(comment == null ? null : new PlainTextConstruct(comment)));
    }

    public String getComment() {
        if (this.getContent() instanceof TextContent) {
            return ((TextContent)this.getContent()).getContent().getPlainText();
        }
        return null;
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declareArbitraryXmlExtension(BaseEntry.class);
    }
}

