/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Category;
import com.google.gdata.data.extensions.FeedLink;
import java.util.Iterator;
import java.util.Set;

class EntryUtils {
    static void setKind(BaseEntry<?> entry, String newKind) {
        EntryUtils.removeKindCategory(entry.getCategories().iterator());
        EntryUtils.addKindCategory(entry.getCategories(), newKind);
    }

    static void setKind(BaseFeed<?, ?> feed, String newKind) {
        EntryUtils.removeKindCategory(feed.getCategories().iterator());
        EntryUtils.addKindCategory(feed.getCategories(), newKind);
    }

    private static void removeKindCategory(Iterator<Category> iter) {
        while (iter.hasNext()) {
            Category category = iter.next();
            if (!"http://schemas.google.com/g/2005#kind".equals(category.getScheme())) continue;
            iter.remove();
        }
    }

    private static void addKindCategory(Set<Category> categories, String kind) {
        categories.add(new Category("http://schemas.google.com/g/2005#kind", kind));
    }

    static FeedLink<?> getFeedLink(BaseEntry<?> entry, String rel) {
        for (FeedLink feedLink : entry.getRepeatingExtension(FeedLink.class)) {
            if (!rel.equals(feedLink.getRel())) continue;
            return feedLink;
        }
        return null;
    }

    private EntryUtils() {
        throw new IllegalStateException("");
    }
}

