/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.extensions.FeedLink;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.youtube.YtCountHint;
import com.google.gdata.data.youtube.YtDescription;
import com.google.gdata.data.youtube.YtPrivate;

public abstract class FeedLinkEntry<T extends BaseEntry>
extends BaseEntry<T> {
    FeedLinkEntry() {
    }

    FeedLinkEntry(BaseEntry<?> base) {
        super(base);
    }

    public FeedLink<?> getFeedLink() {
        return (FeedLink)this.getExtension(FeedLink.class);
    }

    public void setFeedLink(FeedLink<?> feedLink) {
        if (feedLink == null) {
            this.removeExtension(FeedLink.class);
        } else {
            this.setExtension((Extension)feedLink);
        }
    }

    public String getFeedUrl() {
        if (this.getContent() instanceof OutOfLineContent) {
            return ((OutOfLineContent)this.getContent()).getUri();
        }
        FeedLink<?> feedLink = this.getFeedLink();
        if (feedLink != null) {
            return feedLink.getHref();
        }
        return null;
    }

    public Integer getCountHint() {
        YtCountHint countHint = (YtCountHint)this.getExtension(YtCountHint.class);
        if (countHint != null) {
            return countHint.getValue();
        }
        FeedLink<?> feedLink = this.getFeedLink();
        if (feedLink != null) {
            return feedLink.getCountHint();
        }
        return null;
    }

    public void setCountHint(Integer hint) {
        if (hint == null) {
            this.removeExtension(YtCountHint.class);
        } else {
            this.setExtension((Extension)new YtCountHint(hint));
        }
    }

    public MediaThumbnail getThumbnail() {
        return (MediaThumbnail)this.getExtension(MediaThumbnail.class);
    }

    public void setThumbnail(MediaThumbnail thumbnail) {
        if (thumbnail == null) {
            this.removeExtension(MediaThumbnail.class);
        } else {
            this.setExtension(thumbnail);
        }
    }

    @Deprecated
    public String getDescription() {
        YtDescription description = (YtDescription)this.getExtension(YtDescription.class);
        return description == null ? null : description.getContent();
    }

    @Deprecated
    public void setDescription(String description) {
        if (description == null) {
            this.removeExtension(YtDescription.class);
        } else {
            this.setExtension((Extension)new YtDescription(description));
        }
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        Class<?> concreteClass = ((Object)((Object)this)).getClass();
        ExtensionDescription thumbnailDescription = MediaThumbnail.getDefaultDescription();
        thumbnailDescription.setRepeatable(false);
        extProfile.declare(concreteClass, thumbnailDescription);
        extProfile.declare(concreteClass, YtPrivate.class);
        extProfile.declare(concreteClass, YtDescription.class);
        ExtensionDescription feedLinkDescription = FeedLink.getDefaultDescription();
        feedLinkDescription.setRepeatable(false);
        extProfile.declare(concreteClass, feedLinkDescription);
        extProfile.declare(concreteClass, YtCountHint.class);
        extProfile.declareArbitraryXmlExtension(concreteClass);
    }
}

