/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.PlaylistEntry;
import com.google.gdata.data.youtube.YouTubeMediaGroup;
import com.google.gdata.data.youtube.YtPlaylistId;
import com.google.gdata.data.youtube.YtPrivate;

@Kind.Term(value="http://gdata.youtube.com/schemas/2007#playlist")
public class PlaylistFeed
extends BaseFeed<PlaylistFeed, PlaylistEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/tags.cat"};

    public PlaylistFeed() {
        super(PlaylistEntry.class);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#playlist");
    }

    public PlaylistFeed(BaseFeed<?, ?> base) {
        super(PlaylistEntry.class, base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#playlist");
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declareFeedExtension(YtPrivate.class);
        extProfile.declareFeedExtension(YouTubeMediaGroup.class);
        extProfile.declare(PlaylistFeed.class, YtPlaylistId.class);
        new YouTubeMediaGroup().declareExtensions(extProfile);
        BatchUtils.declareExtensions((ExtensionProfile)extProfile);
    }

    public String getPlaylistId() {
        YtPlaylistId playlistId = (YtPlaylistId)this.getExtension(YtPlaylistId.class);
        return playlistId == null ? null : playlistId.getPlaylistId();
    }

    public void setPlaylistId(String playlistId) {
        if (playlistId != null) {
            this.addExtension((Extension)new YtPlaylistId(playlistId));
        } else {
            this.removeExtension(YtPlaylistId.class);
        }
    }

    public boolean isPrivate() {
        return this.getExtension(YtPrivate.class) != null;
    }

    public void setPrivate(boolean value) {
        if (value) {
            this.setExtension((Extension)new YtPrivate());
        } else {
            this.removeExtension(YtPrivate.class);
        }
    }

    public YouTubeMediaGroup getMediaGroup() {
        return (YouTubeMediaGroup)this.getExtension(YouTubeMediaGroup.class);
    }

    public YouTubeMediaGroup getOrCreateMediaGroup() {
        YouTubeMediaGroup group = this.getMediaGroup();
        if (group == null) {
            group = new YouTubeMediaGroup();
            this.setExtension(group);
        }
        return group;
    }
}

