/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.FeedLinkEntry;
import com.google.gdata.data.youtube.YtPlaylistId;
import com.google.gdata.data.youtube.YtPrivate;

@Kind.Term(value="http://gdata.youtube.com/schemas/2007#playlistLink")
public class PlaylistLinkEntry
extends FeedLinkEntry<PlaylistLinkEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/tags.cat"};

    public PlaylistLinkEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#playlistLink");
    }

    public PlaylistLinkEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#playlistLink");
    }

    public void setPrivate(boolean value) {
        if (value) {
            this.setExtension((Extension)new YtPrivate());
        } else {
            this.removeExtension(YtPrivate.class);
        }
    }

    public boolean isPrivate() {
        return this.getExtension(YtPrivate.class) != null;
    }

    public String getPlaylistId() {
        YtPlaylistId playlistId = (YtPlaylistId)this.getExtension(YtPlaylistId.class);
        return playlistId == null ? null : playlistId.getPlaylistId();
    }

    public void setPlaylistId(String playlistId) {
        if (playlistId != null) {
            this.addExtension((Extension)new YtPlaylistId(playlistId));
        } else {
            this.removeExtension(YtPlaylistId.class);
        }
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(PlaylistLinkEntry.class, YtPlaylistId.class);
    }
}

