/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.PubControl;
import com.google.gdata.data.extensions.Comments;
import com.google.gdata.data.extensions.FeedLink;
import com.google.gdata.data.extensions.Rating;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import com.google.gdata.data.geo.impl.GmlPoint;
import com.google.gdata.data.geo.impl.GmlPos;
import com.google.gdata.data.media.MediaEntry;
import com.google.gdata.data.media.mediarss.MediaRssNamespace;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.YouTubeMediaGroup;
import com.google.gdata.data.youtube.YouTubeNamespace;
import com.google.gdata.data.youtube.YtIncomplete;
import com.google.gdata.data.youtube.YtLocation;
import com.google.gdata.data.youtube.YtNoEmbed;
import com.google.gdata.data.youtube.YtPublicationState;
import com.google.gdata.data.youtube.YtRacy;
import com.google.gdata.data.youtube.YtRating;
import com.google.gdata.data.youtube.YtRecorded;
import com.google.gdata.data.youtube.YtStatistics;
import com.google.gdata.data.youtube.YtToken;
import com.google.gdata.util.Namespaces;
import java.util.List;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="video")
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#video")
public class VideoEntry
extends MediaEntry<VideoEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/categories.cat", "http://gdata.youtube.com/schemas/2007/keywords.cat", "http://gdata.youtube.com/schemas/2007/developertags.cat"};

    public VideoEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#video");
    }

    public VideoEntry(BaseEntry<?> original) {
        super(original);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#video");
    }

    public VideoEntry(String id) {
        this();
        this.setId(id);
    }

    public void setStatistics(YtStatistics stats) {
        if (stats == null) {
            this.removeExtension(YtStatistics.class);
        } else {
            this.setExtension((Extension)stats);
        }
    }

    public YtStatistics getStatistics() {
        return (YtStatistics)this.getExtension(YtStatistics.class);
    }

    public boolean isEmbeddable() {
        YtNoEmbed noEmbed = (YtNoEmbed)this.getExtension(YtNoEmbed.class);
        return noEmbed == null;
    }

    public void setEmbeddable(boolean embeddable) {
        if (embeddable) {
            this.removeExtension(YtNoEmbed.class);
        } else {
            this.setExtension((Extension)new YtNoEmbed());
        }
    }

    @Deprecated
    public void setRacy(boolean racy) {
        if (racy) {
            this.setExtension((Extension)new YtRacy());
        } else {
            this.removeExtension(YtRacy.class);
        }
    }

    @Deprecated
    public boolean isRacy() {
        YtRacy racy = (YtRacy)this.getExtension(YtRacy.class);
        return racy != null;
    }

    public void setRecorded(DateTime date) {
        if (date == null) {
            this.removeExtension(YtRecorded.class);
        } else {
            this.setExtension((Extension)new YtRecorded(date));
        }
    }

    public DateTime getRecorded() {
        YtRecorded recorded = (YtRecorded)this.getExtension(YtRecorded.class);
        return recorded == null ? null : recorded.getDate();
    }

    public void setGeoCoordinates(GeoRssWhere where) {
        if (where == null) {
            this.removeExtension(GeoRssWhere.class);
        } else {
            this.setExtension((Extension)where);
        }
    }

    public GeoRssWhere getGeoCoordinates() {
        return (GeoRssWhere)this.getExtension(GeoRssWhere.class);
    }

    public String getLocation() {
        YtLocation tag = (YtLocation)this.getExtension(YtLocation.class);
        return tag == null ? null : tag.getContent();
    }

    public void setLocation(String location) {
        if (location == null) {
            this.removeExtension(YtLocation.class);
        } else {
            this.setExtension((Extension)new YtLocation(location));
        }
    }

    public List<FeedLink> getFeedLinks() {
        return this.getRepeatingExtension(FeedLink.class);
    }

    public Comments getComments() {
        return (Comments)this.getExtension(Comments.class);
    }

    public void setComments(Comments comments) {
        if (comments == null) {
            this.removeExtension(Comments.class);
        } else {
            this.setExtension(comments);
        }
    }

    public Link getVideoResponsesLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#video.responses", ILink.Type.ATOM);
    }

    public Link getRatingLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#video.ratings", ILink.Type.ATOM);
    }

    public Link getComplaintsLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#video.complaints", ILink.Type.ATOM);
    }

    public Link getRelatedVideosLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#video.related", ILink.Type.ATOM);
    }

    public Rating getRating() {
        return (Rating)this.getExtension(Rating.class);
    }

    public void setRating(Rating rating) {
        if (rating == null) {
            this.removeExtension(Rating.class);
        } else {
            this.setExtension((Extension)rating);
        }
    }

    public YtRating getYtRating() {
        return (YtRating)this.getExtension(YtRating.class);
    }

    public void setYtRating(YtRating rating) {
        if (rating == null) {
            this.removeExtension(YtRating.class);
        } else {
            this.setExtension((Extension)rating);
        }
    }

    public void setPublicationState(YtPublicationState state) {
        PubControl control = this.getPubControl();
        if (state == null) {
            if (control != null) {
                control.removeExtension(YtPublicationState.class);
                if (!control.isDraft() && control.getExtensions().isEmpty()) {
                    this.setPubControl(null);
                }
            }
        } else {
            if (control == null) {
                control = new PubControl();
                this.setPubControl(control);
            }
            control.setExtension((Extension)state);
        }
    }

    public YtPublicationState getPublicationState() {
        PubControl control = this.getPubControl();
        return control == null ? null : (YtPublicationState)control.getExtension(YtPublicationState.class);
    }

    public YouTubeMediaGroup getMediaGroup() {
        return (YouTubeMediaGroup)this.getExtension(YouTubeMediaGroup.class);
    }

    public YouTubeMediaGroup getOrCreateMediaGroup() {
        YouTubeMediaGroup group = this.getMediaGroup();
        if (group == null) {
            group = new YouTubeMediaGroup();
            this.setExtension(group);
        }
        return group;
    }

    public void setYtIncomplete(boolean ytIncomplete) {
        PubControl control = this.getPubControl();
        if (!ytIncomplete) {
            if (control != null) {
                control.removeExtension(YtIncomplete.class);
                if (control.getExtensions().isEmpty()) {
                    this.setPubControl(null);
                }
            }
        } else {
            if (control == null) {
                control = new PubControl();
                this.setPubControl(control);
            }
            control.setExtension((Extension)new YtIncomplete());
            control.setDraft(Boolean.valueOf(true));
        }
    }

    public boolean isYtIncomplete() {
        PubControl control = this.getPubControl();
        return control != null && control.getExtension(YtIncomplete.class) != null;
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(PubControl.class, YtPublicationState.class);
        extProfile.declare(VideoEntry.class, Comments.getDefaultDescription());
        extProfile.declare(VideoEntry.class, Rating.getDefaultDescription(false));
        extProfile.declareAdditionalNamespace(Namespaces.gNs);
        extProfile.declareAdditionalNamespace(YouTubeNamespace.NS);
        extProfile.declare(VideoEntry.class, YtRacy.class);
        extProfile.declare(VideoEntry.class, YtRecorded.class);
        extProfile.declare(VideoEntry.class, YtStatistics.class);
        extProfile.declare(VideoEntry.class, YtNoEmbed.class);
        extProfile.declare(VideoEntry.class, YtLocation.class);
        extProfile.declare(VideoEntry.class, YtRating.class);
        extProfile.declare(VideoEntry.class, YouTubeMediaGroup.class);
        new YouTubeMediaGroup().declareExtensions(extProfile);
        extProfile.declareAdditionalNamespace(MediaRssNamespace.NS);
        extProfile.declare(VideoEntry.class, GeoRssWhere.getDefaultDescription((boolean)false));
        extProfile.declareAdditionalNamespace(com.google.gdata.data.geo.Namespaces.GEO_RSS_NAMESPACE);
        extProfile.declare(GeoRssWhere.class, GmlPoint.getDefaultDescription((boolean)false));
        extProfile.declare(GmlPoint.class, GmlPos.getDefaultDescription((boolean)false));
        extProfile.declareAdditionalNamespace(com.google.gdata.data.geo.Namespaces.GML_NAMESPACE);
        extProfile.declare(Link.class, YtToken.class);
        extProfile.declareArbitraryXmlExtension(VideoEntry.class);
    }
}

