/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.fmrc.FmrcImpl;
import ucar.nc2.dt.fmrc.ForecastModelRunCollection;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheNOP;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvDatasetFmrc
extends InvCatalogRef {
    private static Logger logger = LoggerFactory.getLogger(InvDatasetFmrc.class);
    private static final String FMRC = "fmrc.ncd";
    private static final String BEST = "best.ncd";
    private static final String RUNS = "runs";
    private static final String RUN_NAME = "RUN_";
    private static final String FORECAST = "forecast";
    private static final String FORECAST_NAME = "ConstantForecast_";
    private static final String OFFSET = "offset";
    private static final String OFFSET_NAME = "Offset_";
    private static final String TITLE_RUNS = "Forecast Model Run";
    private static final String TITLE_OFFSET = "Constant Forecast Offset";
    private static final String TITLE_FORECAST = "Constant Forecast Date";
    private static final String SCAN = "files";
    private static FileCache fileCache = new FileCacheNOP();
    private volatile boolean madeDatasets = false;
    private volatile boolean madeFmrc = false;
    private final String path;
    private final boolean runsOnly;
    private InventoryParams params;
    private String dodsService;
    private ForecastModelRunCollection fmrc;
    private InvCatalogImpl catalog;
    private InvCatalogImpl catalogRuns;
    private InvCatalogImpl catalogOffsets;
    private InvCatalogImpl catalogForecasts;
    private InvDatasetScan scan;

    public InvDatasetFmrc(InvDatasetImpl parent, String name, String path, boolean runsOnly) {
        super(parent, name, "/thredds/catalog/" + path + "/catalog.xml");
        this.path = path;
        this.runsOnly = runsOnly;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRunsOnly() {
        return this.runsOnly;
    }

    public InvDatasetScan getRawFileScan() {
        if (!this.madeDatasets) {
            this.getDatasets();
        }
        return this.scan;
    }

    public InventoryParams getFmrcInventoryParams() {
        return this.params;
    }

    public File getFile(String remaining) {
        if (null == this.params) {
            return null;
        }
        int pos = remaining.indexOf(SCAN);
        StringBuilder fname = new StringBuilder(this.params.location);
        if (!this.params.location.endsWith("/")) {
            fname.append("/");
        }
        fname.append(pos > -1 ? remaining.substring(pos + SCAN.length() + 1) : remaining);
        return new File(fname.toString());
    }

    public void setFmrcInventoryParams(String location, String def, String suffix, String olderThanS, String subdirs) {
        this.params = new InventoryParams();
        this.params.location = location;
        this.params.def = def;
        this.params.suffix = suffix;
        boolean bl = this.params.subdirs = subdirs != null && subdirs.equalsIgnoreCase("true");
        if (olderThanS != null) {
            try {
                TimeUnit tu = new TimeUnit(olderThanS);
                this.params.lastModifiedLimit = (long)(1000.0 * tu.getValueInSeconds());
            }
            catch (Exception e) {
                logger.error("Invalid TimeUnit = " + olderThanS);
                throw new IllegalArgumentException("Invalid TimeUnit = " + olderThanS);
            }
        }
    }

    @Override
    public boolean hasAccess() {
        return false;
    }

    @Override
    public boolean hasNestedDatasets() {
        return true;
    }

    public InvCatalogImpl makeCatalog(String match, String orgPath, URI baseURI) {
        logger.debug("FMRC make catalog for " + match + " " + baseURI);
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalog(baseURI);
            }
            if (match.equals(RUNS)) {
                return this.makeCatalogRuns(baseURI);
            }
            if (match.equals(OFFSET)) {
                return this.makeCatalogOffsets(baseURI);
            }
            if (match.equals(FORECAST)) {
                return this.makeCatalogForecasts(baseURI);
            }
            if (match.equals(SCAN)) {
                return this.makeCatalogScan(orgPath, baseURI);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, (Throwable)e);
            return null;
        }
    }

    @Override
    public List<InvDataset> getDatasets() {
        if (!this.madeDatasets) {
            ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
            if (this.runsOnly) {
                InvCatalogRef ds = new InvCatalogRef(this, TITLE_RUNS, this.getCatalogHref(RUNS));
                ((InvDatasetImpl)ds).finish();
                datasets.add(ds);
            } else {
                String id = this.getID();
                if (id == null) {
                    id = this.getPath();
                }
                InvDatasetImpl ds = new InvDatasetImpl(this, "Forecast Model Run Collection (2D time coordinates)");
                String name = this.getName() + "_" + FMRC;
                name = StringUtil.replace((String)name, (char)' ', (String)"_");
                ds.setUrlPath(this.path + "/" + name);
                ds.setID(id + "/" + name);
                ThreddsMetadata tm = ds.getLocalMetadata();
                tm.addDocumentation("summary", "Forecast Model Run Collection (2D time coordinates).");
                ds.getLocalMetadataInheritable().setServiceName(this.dodsService);
                ds.finish();
                datasets.add(ds);
                ds = new InvDatasetImpl(this, "Best Time Series");
                name = this.getName() + "_" + BEST;
                name = StringUtil.replace((String)name, (char)' ', (String)"_");
                ds.setUrlPath(this.path + "/" + name);
                ds.setID(id + "/" + name);
                tm = ds.getLocalMetadata();
                tm.addDocumentation("summary", "Best time series, taking the data from the most recent run available.");
                ds.finish();
                datasets.add(ds);
                ds = new InvCatalogRef(this, TITLE_RUNS, this.getCatalogHref(RUNS));
                ds.finish();
                datasets.add(ds);
                ds = new InvCatalogRef(this, TITLE_OFFSET, this.getCatalogHref(OFFSET));
                ds.finish();
                datasets.add(ds);
                ds = new InvCatalogRef(this, TITLE_FORECAST, this.getCatalogHref(FORECAST));
                ds.finish();
                datasets.add(ds);
                if (this.params != null) {
                    InvDatasetFeatureCollection.ScanFilter filter = new InvDatasetFeatureCollection.ScanFilter(Pattern.compile(".*" + this.params.suffix), this.params.lastModifiedLimit);
                    this.scan = new InvDatasetScan((InvCatalogImpl)this.getParentCatalog(), (InvDatasetImpl)this, "File_Access", this.path + "/" + SCAN, this.params.location, filter, true, "true", false, null, null, null);
                    ThreddsMetadata tmi = this.scan.getLocalMetadataInheritable();
                    tmi.setServiceName("fileServices");
                    tmi.addDocumentation("summary", "Individual data file, which comprise the Forecast Model Run Collection.");
                    this.scan.finish();
                    datasets.add(this.scan);
                }
            }
            this.datasets = datasets;
            this.madeDatasets = true;
        }
        this.finish();
        return this.datasets;
    }

    private String getCatalogHref(String what) {
        return "/thredds/catalog/" + this.path + "/" + what + "/catalog.xml";
    }

    private synchronized boolean checkIfChanged() throws IOException {
        boolean changed;
        boolean bl = changed = this.madeFmrc && this.fmrc.sync();
        if (changed) {
            this.catalog = null;
            this.catalogRuns = null;
            this.catalogOffsets = null;
            this.catalogForecasts = null;
        }
        return changed;
    }

    private InvCatalogImpl makeCatalog(URI baseURI) throws IOException, URISyntaxException {
        if (this.catalog == null || this.checkIfChanged()) {
            DateRange dateRange;
            ThreddsMetadata.GeospatialCoverage gc;
            ThreddsMetadata.Variables vars;
            String id;
            InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
            URI myURI = baseURI.resolve(this.getXlinkHref());
            InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getFullName(), parentCatalog.getVersion(), myURI);
            InvDatasetImpl top = new InvDatasetImpl(this);
            top.setParent(null);
            InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
            if (parent != null) {
                top.transferMetadata(parent, true);
            }
            if ((id = this.getID()) == null) {
                id = this.getPath();
            }
            top.setID(id);
            this.makeFmrc();
            ThreddsMetadata tmi = top.getLocalMetadataInheritable();
            if (tmi.getVariables().size() == 0 && (vars = MetadataExtractor.extractVariables(this, this.fmrc.getGridDataset())) != null) {
                tmi.addVariables(vars);
            }
            if (tmi.getGeospatialCoverage() == null && (gc = MetadataExtractor.extractGeospatial(this.fmrc.getGridDataset())) != null) {
                tmi.setGeospatialCoverage(gc);
            }
            if (tmi.getTimeCoverage() == null && (dateRange = MetadataExtractor.extractDateRange(this.fmrc.getGridDataset())) != null) {
                tmi.setTimeCoverage(dateRange);
            }
            if (null != this.params) {
                ThreddsMetadata tm = top.getLocalMetadata();
                InvDocumentation doc = new InvDocumentation();
                String path = this.getPath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                doc.setXlinkHref("/thredds/modelInventory/" + path);
                doc.setXlinkTitle("Available Inventory");
                tm.addDocumentation(doc);
            }
            mainCatalog.addDataset(top);
            List<InvService> serviceLocal = this.getServicesLocal();
            for (InvService service : parentCatalog.getServices()) {
                if (serviceLocal.contains(service)) continue;
                mainCatalog.addService(service);
            }
            this.findDODSService(parentCatalog.getServices());
            for (InvDataset ds : this.getDatasets()) {
                top.addDataset((InvDatasetImpl)ds);
            }
            mainCatalog.finish();
            this.catalog = mainCatalog;
        }
        return this.catalog;
    }

    private void findDODSService(List<InvService> services) {
        for (InvService service : services) {
            if (this.dodsService == null && service.getServiceType() == ServiceType.OPENDAP) {
                this.dodsService = service.getName();
                return;
            }
            if (service.getServiceType() != ServiceType.COMPOUND) continue;
            this.findDODSService(service.getServices());
        }
    }

    private InvCatalogImpl makeCatalogRuns(URI baseURI) throws IOException {
        if (this.catalogRuns == null || this.checkIfChanged()) {
            InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
            URI myURI = baseURI.resolve(this.getCatalogHref(RUNS));
            InvCatalogImpl runCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
            InvDatasetImpl top = new InvDatasetImpl(this);
            top.setParent(null);
            top.transferMetadata((InvDatasetImpl)this.getParent(), true);
            top.setName(TITLE_RUNS);
            runCatalog.addDataset(top);
            ArrayList<InvService> services = new ArrayList<InvService>(this.getServicesLocal());
            InvService service = this.getServiceDefault();
            if (service != null && !services.contains(service)) {
                runCatalog.addService(service);
            }
            for (InvDatasetImpl ds : this.makeRunDatasets()) {
                top.addDataset(ds);
            }
            runCatalog.finish();
            this.catalogRuns = runCatalog;
        }
        return this.catalogRuns;
    }

    private InvCatalogImpl makeCatalogOffsets(URI baseURI) throws IOException {
        if (this.catalogOffsets == null || this.checkIfChanged()) {
            InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
            URI myURI = baseURI.resolve(this.getCatalogHref(OFFSET));
            InvCatalogImpl offCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
            InvDatasetImpl top = new InvDatasetImpl(this);
            top.setParent(null);
            top.transferMetadata((InvDatasetImpl)this.getParent(), true);
            top.setName(TITLE_OFFSET);
            offCatalog.addDataset(top);
            List<InvService> services = this.getServicesLocal();
            InvService service = this.getServiceDefault();
            if (service != null && !services.contains(service)) {
                offCatalog.addService(service);
            }
            for (InvDatasetImpl ds : this.makeOffsetDatasets()) {
                top.addDataset(ds);
            }
            offCatalog.finish();
            this.catalogOffsets = offCatalog;
        }
        return this.catalogOffsets;
    }

    private InvCatalogImpl makeCatalogForecasts(URI baseURI) throws IOException {
        if (this.catalogForecasts == null || this.checkIfChanged()) {
            InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
            URI myURI = baseURI.resolve(this.getCatalogHref(FORECAST));
            InvCatalogImpl foreCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
            InvDatasetImpl top = new InvDatasetImpl(this);
            top.setParent(null);
            top.transferMetadata((InvDatasetImpl)this.getParent(), true);
            top.setName(TITLE_FORECAST);
            foreCatalog.addDataset(top);
            List<InvService> services = this.getServicesLocal();
            InvService service = this.getServiceDefault();
            if (service != null && !services.contains(service)) {
                foreCatalog.addService(service);
            }
            for (InvDatasetImpl ds : this.makeForecastDatasets()) {
                top.addDataset(ds);
            }
            foreCatalog.finish();
            this.catalogForecasts = foreCatalog;
        }
        return this.catalogForecasts;
    }

    private InvCatalogImpl makeCatalogScan(String orgPath, URI baseURI) {
        if (!this.madeDatasets) {
            this.getDatasets();
        }
        return this.scan.makeCatalogForDirectory(orgPath, baseURI);
    }

    private synchronized void makeFmrc() throws IOException {
        if (this.madeFmrc) {
            this.checkIfChanged();
            return;
        }
        Element ncml = this.getNcmlElement();
        NetcdfDataset ncd = NcMLReader.readNcML(this.path, ncml, null);
        ncd.setFileCache(fileCache);
        this.fmrc = new FmrcImpl(ncd);
        this.madeFmrc = true;
    }

    private List<InvDatasetImpl> makeRunDatasets() throws IOException {
        this.makeFmrc();
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        DateFormatter formatter = new DateFormatter();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Date runDate : this.fmrc.getRunDates()) {
            String name = this.getName() + "_" + RUN_NAME + formatter.toDateTimeStringISO(runDate);
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + RUNS + "/" + name);
            nested.setID(id + "/" + RUNS + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from Run " + name);
            datasets.add(nested);
        }
        Collections.reverse(datasets);
        return datasets;
    }

    private List<InvDatasetImpl> makeOffsetDatasets() throws IOException {
        this.makeFmrc();
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Double offset : this.fmrc.getForecastOffsets()) {
            String name = this.getName() + "_" + OFFSET_NAME + offset + "hr";
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + OFFSET + "/" + name);
            nested.setID(id + "/" + OFFSET + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from the " + offset + " hour forecasts, across different model runs.");
            datasets.add(nested);
        }
        return datasets;
    }

    private List<InvDatasetImpl> makeForecastDatasets() throws IOException {
        this.makeFmrc();
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        DateFormatter formatter = new DateFormatter();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Date forecastDate : this.fmrc.getForecastDates()) {
            String name = this.getName() + "_" + FORECAST_NAME + formatter.toDateTimeStringISO(forecastDate);
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + FORECAST + "/" + name);
            nested.setID(id + "/" + FORECAST + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data with the same forecast date, " + name + ", across different model runs.");
            datasets.add(nested);
        }
        return datasets;
    }

    public NetcdfDataset getDataset(String path) throws IOException {
        String name;
        int pos = path.indexOf("/");
        String type = pos > -1 ? path.substring(0, pos) : path;
        String string = name = pos > -1 ? path.substring(pos + 1) : "";
        if (type.equals(SCAN) && this.params != null) {
            String filename = this.params.location + (this.params.location.endsWith("/") ? "" : "/") + name;
            return NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
        }
        this.makeFmrc();
        NetcdfDataset result = null;
        String location = path;
        if (path.endsWith(FMRC)) {
            result = this.fmrc.getFmrcDataset();
        } else if (path.endsWith(BEST)) {
            result = this.fmrc.getBestTimeSeries();
        } else {
            location = name;
            if (type.equals(OFFSET)) {
                int pos1 = name.indexOf(OFFSET_NAME);
                int pos2 = name.indexOf("hr");
                if (pos1 < 0 || pos2 < 0) {
                    return null;
                }
                String id = name.substring(pos1 + OFFSET_NAME.length(), pos2);
                double hour = Double.parseDouble(id);
                result = this.fmrc.getForecastOffsetDataset(hour);
            } else if (type.equals(RUNS)) {
                int pos1 = name.indexOf(RUN_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = name.substring(pos1 + RUN_NAME.length());
                DateFormatter formatter = new DateFormatter();
                Date date = formatter.getISODate(id);
                result = this.fmrc.getRunTimeDataset(date);
            } else if (type.equals(FORECAST)) {
                int pos1 = name.indexOf(FORECAST_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = name.substring(pos1 + FORECAST_NAME.length());
                DateFormatter formatter = new DateFormatter();
                Date date = formatter.getISODate(id);
                result = this.fmrc.getForecastTimeDataset(date);
            }
        }
        if (null != result) {
            result.setLocation(location);
        }
        return result;
    }

    public class InventoryParams {
        public String location;
        public String def;
        public String suffix;
        public boolean subdirs;
        public long lastModifiedLimit = 0L;

        public String toString() {
            return "def=" + this.def + " location=" + this.location + " suffix=" + this.suffix + " lastModifiedLimit=" + this.lastModifiedLimit + " subdirs=" + this.subdirs;
        }
    }
}

