/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_1;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.Request;
import thredds.wcs.v1_0_0_1.WcsDataset;
import thredds.wcs.v1_0_0_1.WcsException;
import thredds.wcs.v1_0_0_1.WcsRangeField;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ogc.EPSG_OGC_CF_Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WcsCoverage {
    private static Logger log = LoggerFactory.getLogger(WcsCoverage.class);
    private GridDatatype coverage;
    private WcsDataset dataset;
    private GridCoordSystem coordSys;
    private String nativeCRS;
    private String defaultRequestCrs;
    private List<Request.Format> supportedCoverageFormatList;
    private WcsRangeField range;
    private static DiskCache2 diskCache = null;

    public WcsCoverage(GridDatatype coverage, WcsDataset dataset) {
        WcsRangeField.Axis vertAxis;
        this.dataset = dataset;
        if (this.dataset == null) {
            log.error("WcsCoverage(): non-null dataset required.");
            throw new IllegalArgumentException("Non-null dataset required.");
        }
        this.coverage = coverage;
        if (this.coverage == null) {
            log.error("WcsCoverage(): non-null coverage required.");
            throw new IllegalArgumentException("Non-null coverage required.");
        }
        this.coordSys = coverage.getCoordinateSystem();
        if (this.coordSys == null) {
            log.error("WcsCoverage(): Coverage must have non-null coordinate system.");
            throw new IllegalArgumentException("Non-null coordinate system required.");
        }
        this.nativeCRS = EPSG_OGC_CF_Helper.getWcs1_0CrsId((Projection)this.coordSys.getProjection());
        this.defaultRequestCrs = "OGC:CRS84";
        this.supportedCoverageFormatList = new ArrayList<Request.Format>();
        this.supportedCoverageFormatList.add(Request.Format.GeoTIFF);
        this.supportedCoverageFormatList.add(Request.Format.GeoTIFF_Float);
        this.supportedCoverageFormatList.add(Request.Format.NetCDF3);
        CoordinateAxis1D zaxis = this.coordSys.getVerticalAxis();
        if (zaxis != null) {
            ArrayList<String> vals = new ArrayList<String>();
            int z = 0;
            while ((long)z < zaxis.getSize()) {
                vals.add(zaxis.getCoordName(z).trim());
                ++z;
            }
            vertAxis = new WcsRangeField.Axis("Vertical", zaxis.getName(), zaxis.getDescription(), zaxis.isNumeric(), vals);
        } else {
            vertAxis = null;
        }
        this.range = new WcsRangeField(this.getName(), this.getLabel(), this.getDescription(), vertAxis);
    }

    GridDatatype getGridDatatype() {
        return this.coverage;
    }

    public String getName() {
        return this.coverage.getName();
    }

    public String getLabel() {
        return this.coverage.getDescription();
    }

    public String getDescription() {
        return this.coverage.getInfo();
    }

    public GridCoordSystem getCoordinateSystem() {
        return this.coordSys;
    }

    public boolean hasMissingData() {
        return this.coverage.hasMissingData();
    }

    public String getDefaultRequestCrs() {
        return this.defaultRequestCrs;
    }

    public String getNativeCrs() {
        return this.nativeCRS;
    }

    public List<Request.Format> getSupportedCoverageFormatList() {
        return this.supportedCoverageFormatList;
    }

    public boolean isSupportedCoverageFormat(Request.Format covFormat) {
        return this.supportedCoverageFormatList.contains((Object)covFormat);
    }

    public WcsRangeField getRangeField() {
        return this.range;
    }

    public Range getRangeSetAxisRange(double minValue, double maxValue) {
        if (minValue > maxValue) {
            log.error("getRangeSetAxisRange(): Min is greater than max <" + minValue + ", " + maxValue + ">.");
            throw new IllegalArgumentException("Min is greater than max <" + minValue + ", " + maxValue + ">.");
        }
        CoordinateAxis1D zaxis = this.coordSys.getVerticalAxis();
        if (zaxis != null) {
            int minIndex = zaxis.findCoordElement(minValue);
            int maxIndex = zaxis.findCoordElement(maxValue);
            if (minIndex == -1 || maxIndex == -1) {
                return null;
            }
            try {
                return new Range(minIndex, maxIndex);
            }
            catch (InvalidRangeException e) {
                return null;
            }
        }
        return null;
    }

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    private static DiskCache2 getDiskCache() {
        if (diskCache == null) {
            log.error("getDiskCache(): Disk cache has not been set.");
            throw new IllegalStateException("Disk cache must be set before calling GetCoverage.getDiskCache().");
        }
        return diskCache;
    }

    public File writeCoverageDataToFile(Request.Format format, LatLonRect bboxLatLonRect, VerticalRange verticalRange, DateRange timeRange) throws WcsException {
        Range zRange = null;
        try {
            zRange = verticalRange != null ? verticalRange.getRange(this.coordSys) : null;
        }
        catch (InvalidRangeException e) {
            log.error("writeCoverageDataToFile(): Failed to subset coverage <" + this.coverage.getName() + "> along vertical range <" + verticalRange + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.CoverageNotDefined, "Vertical", "Failed to subset coverage [" + this.coverage.getName() + "] along vertical range.");
        }
        Range tRange = null;
        if (timeRange != null) {
            CoordinateAxis1DTime timeAxis = this.coordSys.getTimeAxis1D();
            DateType requestStartTime = timeRange.getStart();
            DateType requestEndTime = timeRange.getEnd();
            int startIndex = timeAxis.findTimeIndexFromDate(requestStartTime.getDate());
            int endIndex = timeAxis.findTimeIndexFromDate(requestEndTime.getDate());
            if (startIndex < 0 || (long)startIndex > timeAxis.getSize() - 1L || endIndex < 0 || (long)endIndex > timeAxis.getSize() - 1L) {
                String availStart = timeAxis.getDateRange().getStart().toDateTimeStringISO();
                String availEnd = timeAxis.getDateRange().getEnd().toDateTimeStringISO();
                String msg = "Requested temporal range [" + requestStartTime.toDateTimeStringISO() + " - " + requestEndTime.toDateTimeStringISO() + "] not in available range [" + availStart + " - " + availEnd + "].";
                log.debug("writeCoverageDataToFile(): " + msg);
                throw new WcsException(WcsException.Code.CoverageNotDefined, "Time", msg);
            }
            try {
                tRange = new Range(startIndex, endIndex);
            }
            catch (InvalidRangeException e) {
                log.error("writeCoverageDataToFile(): Failed to subset coverage [" + this.coverage.getName() + "] along time axis [" + timeRange + "]: " + e.getMessage());
                throw new WcsException(WcsException.Code.CoverageNotDefined, "Time", "Failed to subset coverage [" + this.coverage.getName() + "] along time axis [" + timeRange + "].");
            }
        }
        try {
            File dir;
            if (format == Request.Format.GeoTIFF || format == Request.Format.GeoTIFF_Float) {
                dir = new File(WcsCoverage.getDiskCache().getRootDirectory());
                File tifFile = File.createTempFile("WCS", ".tif", dir);
                if (log.isDebugEnabled()) {
                    log.debug("writeCoverageDataToFile(): tifFile=" + tifFile.getPath());
                }
                try {
                    GridDatatype subset = this.coverage.makeSubset(tRange, zRange, bboxLatLonRect, 1, 1, 1);
                    Array data = subset.readDataSlice(0, 0, -1, -1);
                    GeotiffWriter writer = new GeotiffWriter(tifFile.getPath());
                    writer.writeGrid(this.dataset.getDataset(), subset, data, format == Request.Format.GeoTIFF);
                    writer.close();
                }
                catch (InvalidRangeException e) {
                    log.error("writeCoverageDataToFile(): Failed to subset coverage <" + this.coverage.getName() + "> along time axis <" + timeRange + ">: " + e.getMessage());
                    throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Failed to subset coverage [" + this.coverage.getName() + "].");
                }
                catch (IOException e) {
                    log.error("writeCoverageDataToFile(): Failed to write file for requested coverage <" + this.coverage.getName() + ">: " + e.getMessage());
                    throw new WcsException(WcsException.Code.UNKNOWN, "", "Problem creating coverage [" + this.coverage.getName() + "].");
                }
                return tifFile;
            }
            if (format == Request.Format.NetCDF3) {
                dir = new File(WcsCoverage.getDiskCache().getRootDirectory());
                File ncFile = File.createTempFile("WCS", ".nc", dir);
                if (log.isDebugEnabled()) {
                    log.debug("writeCoverageDataToFile(): ncFile=" + ncFile.getPath());
                }
                NetcdfCFWriter writer = new NetcdfCFWriter();
                writer.makeFile(ncFile.getPath(), this.dataset.getDataset(), Collections.singletonList(this.coverage.getName()), bboxLatLonRect, 1, zRange, timeRange, 1, true);
                return ncFile;
            }
            log.error("writeCoverageDataToFile(): Unsupported response encoding format [" + (Object)((Object)format) + "].");
            throw new WcsException(WcsException.Code.InvalidFormat, "Format", "Unsupported response encoding format [" + (Object)((Object)format) + "].");
        }
        catch (InvalidRangeException e) {
            log.error("writeCoverageDataToFile(): Failed to subset coverage <" + this.coverage.getName() + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Failed to subset coverage [" + this.coverage.getName() + "].");
        }
        catch (IOException e) {
            log.error("writeCoverageDataToFile(): Failed to create or write temporary file for requested coverage <" + this.coverage.getName() + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.UNKNOWN, "", "Problem creating coverage [" + this.coverage.getName() + "].");
        }
    }

    public static class VerticalRange {
        private double min;
        private double max;
        private int stride;
        private boolean singlePoint = false;

        public VerticalRange(double point, int stride) {
            this(point, point, stride);
            this.singlePoint = true;
        }

        public VerticalRange(double minimum, double maximum, int stride) {
            if (minimum > maximum) {
                log.error("VerticalRange(): Minimum <" + minimum + "> is greater than maximum <" + maximum + ">.");
                throw new IllegalArgumentException("VerticalRange minimum <" + minimum + "> greater than maximum <" + maximum + ">.");
            }
            if (stride < 1) {
                log.error("VerticalRange(): stride <" + stride + "> less than one (1 means all points).");
                throw new IllegalArgumentException("VerticalRange stride <" + stride + "> less than one (1 means all points).");
            }
            this.min = minimum;
            this.max = maximum;
            this.stride = stride;
        }

        public double getMinimum() {
            return this.min;
        }

        public double getMaximum() {
            return this.max;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean isSinglePoint() {
            return this.singlePoint;
        }

        public String toString() {
            return "[min=" + this.min + ",max=" + this.max + ",stride=" + this.stride + "]";
        }

        public Range getRange(GridCoordSystem gcs) throws InvalidRangeException {
            if (gcs == null) {
                log.error("getRange(): GridCoordSystem must be non-null.");
                throw new IllegalArgumentException("GridCoordSystem must be non-null.");
            }
            CoordinateAxis1D vertAxis = gcs.getVerticalAxis();
            if (vertAxis == null) {
                log.error("getRange(): GridCoordSystem must have vertical axis.");
                throw new IllegalArgumentException("GridCoordSystem must have vertical axis.");
            }
            if (!vertAxis.isNumeric()) {
                log.error("getRange(): GridCoordSystem must have numeric vertical axis to support min/max range.");
                throw new IllegalArgumentException("GridCoordSystem must have numeric vertical axis to support min/max range.");
            }
            int minIndex = vertAxis.findCoordElement(this.min);
            int maxIndex = vertAxis.findCoordElement(this.max);
            if (minIndex == -1 || maxIndex == -1) {
                log.error("getRange(): GridCoordSystem vertical axis does not contain min/max points.");
                throw new IllegalArgumentException("GridCoordSystem vertical axis does not contain min/max points.");
            }
            if (vertAxis.getPositive().equalsIgnoreCase("down")) {
                return new Range(maxIndex, minIndex, this.stride);
            }
            return new Range(minIndex, maxIndex, this.stride);
        }
    }
}

