/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.ProjectionImpl;

public class Orthographic
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "orthographic";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", Double.NaN);
        ucar.unidata.geoloc.projection.Orthographic proj = new ucar.unidata.geoloc.projection.Orthographic(lat0, lon0);
        return new ProjectionCT(ctv.getShortName(), "FGDC", (ProjectionImpl)proj);
    }
}

