/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.ProjectionImpl;

public class RotatedPole
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "rotated_latitude_longitude";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon = this.readAttributeDouble(ctv, "grid_north_pole_longitude", Double.NaN);
        double lat = this.readAttributeDouble(ctv, "grid_north_pole_latitude", Double.NaN);
        ucar.unidata.geoloc.projection.RotatedPole proj = new ucar.unidata.geoloc.projection.RotatedPole(lat, lon);
        return new ProjectionCT(ctv.getShortName(), "FGDC", (ProjectionImpl)proj);
    }
}

