/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;

public class Dorade2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    protected DateUnit dateUnits;
    private NetcdfDataset ncd;
    float[] elev;
    float[] aziv;
    float[] disv;
    float[] lonv;
    float[] altv;
    float[] latv;
    double[] timv;
    float ranv;
    float cellv;
    float angv;
    float nyqv;
    float rangv;
    float contv;
    float rgainv;
    float bwidthv;

    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && (format = ds.findAttValueIgnoreCase(null, "Format", null)).equals("Unidata/netCDF/Dorade");
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new Dorade2Dataset(ncd);
    }

    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public Dorade2Dataset() {
    }

    public Dorade2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ncd = ds;
        this.desc = "dorade radar dataset";
        try {
            this.elev = (float[])this.ncd.findVariable("elevation").read().get1DJavaArray(Float.TYPE);
            this.aziv = (float[])this.ncd.findVariable("azimuth").read().get1DJavaArray(Float.TYPE);
            this.altv = (float[])this.ncd.findVariable("altitudes_1").read().get1DJavaArray(Float.TYPE);
            this.lonv = (float[])this.ncd.findVariable("longitudes_1").read().get1DJavaArray(Float.TYPE);
            this.latv = (float[])this.ncd.findVariable("latitudes_1").read().get1DJavaArray(Float.TYPE);
            this.disv = (float[])this.ncd.findVariable("distance_1").read().get1DJavaArray(Float.TYPE);
            this.timv = (double[])this.ncd.findVariable("rays_time").read().get1DJavaArray(Double.TYPE);
            this.angv = this.ncd.findVariable("Fixed_Angle").readScalarFloat();
            this.nyqv = this.ncd.findVariable("Nyquist_Velocity").readScalarFloat();
            this.rangv = this.ncd.findVariable("Unambiguous_Range").readScalarFloat();
            this.contv = this.ncd.findVariable("Radar_Constant").readScalarFloat();
            this.rgainv = this.ncd.findVariable("rcvr_gain").readScalarFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setStartDate();
        this.setEndDate();
    }

    public String getRadarID() {
        return this.ncd.findGlobalAttribute("radar_name").getStringValue();
    }

    public String getRadarName() {
        return "Dorade Radar";
    }

    public String getDataFormat() {
        return "DORADE";
    }

    public EarthLocation getCommonOrigin() {
        if (this.isStationary()) {
            return new EarthLocationImpl((double)this.latv[0], (double)this.lonv[0], (double)this.elev[0]);
        }
        return null;
    }

    public boolean isStationary() {
        String t = this.ncd.findGlobalAttribute("IsStationary").getStringValue();
        return t.equals("1");
    }

    public boolean isVolume() {
        return false;
    }

    protected void setEarthLocation() {
        if (this.isStationary()) {
            this.origin = new EarthLocationImpl((double)this.latv[0], (double)this.lonv[0], (double)this.elev[0]);
        }
        this.origin = null;
    }

    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int rnk = var.getRank();
        if (rnk == 2) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(this, vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new Dorade2Variable(nds, v, v0);
    }

    public List getDataVariables() {
        return this.dataVariables;
    }

    protected void setStartDate() {
        Date da = new Date((long)this.timv[0]);
        String start_datetime = da.toString();
        if (start_datetime != null) {
            this.startDate = da;
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    protected void setEndDate() {
        Date da = new Date((long)this.timv[this.timv.length - 1]);
        String end_datetime = da.toString();
        if (end_datetime != null) {
            this.endDate = da;
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    protected void setTimeUnits() throws Exception {
        List<CoordinateAxis> axes = this.ncd.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    public List getAttributes() {
        return this.ncd.getRootGroup().getAttributes();
    }

    public DateUnit getTimeUnits() {
        return this.dateUnits;
    }

    public void getTimeUnits(DateUnit dateUnits) {
        this.dateUnits = dateUnits;
    }

    public void clearDatasetMemory() {
        List rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radVar : rvars) {
            radVar.clearVariableMemory();
        }
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        int nsweep = rv.getNumSweeps();
        if (nsweep != 1) {
            // empty if block
        }
        RadialDatasetSweep.Sweep sw = rv.getSweep(0);
        int nrays = sw.getRadialNumber();
        float[] ddd = sw.readData();
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            float[] d = sw.readData(i);
            float azi = sw.getAzimuth(i);
            float ele = sw.getElevation(i);
            double t = sw.getTime(i);
            Date da = new Date((long)t);
            String start_datetime = da.toString();
            float dis = sw.getRangeToFirstGate();
            float beamW = sw.getBeamWidth();
            float gsize = sw.getGateSize();
            float la = (float)sw.getOrigin(i).getLatitude();
            float lo = (float)sw.getOrigin(i).getLongitude();
            float al = (float)sw.getOrigin(i).getAltitude();
        }
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/dorade/swp.1020511015815.SP0L.573.1.2_SUR_v1";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn, null, new StringBuilder());
        String st = rds.getStartDate().toString();
        String et = rds.getEndDate().toString();
        if (rds.isStationary()) {
            System.out.println("*** radar is stationary\n");
        }
        List<VariableSimpleIF> rvars = rds.getDataVariables();
        RadialDatasetSweep.RadialVariable vDM = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("DM");
        Dorade2Dataset.testRadialVariable(vDM);
        for (int i = 0; i < rvars.size(); ++i) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)rvars.get(i);
            Dorade2Dataset.testRadialVariable(rv);
        }
    }

    private class Dorade2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        ArrayList sweeps;
        int nsweeps;
        String name;
        float ele;
        float azi;
        float alt;
        float lon;
        float lat;

        public int getNumSweeps() {
            return 1;
        }

        public RadialDatasetSweep.Sweep getSweep(int nsw) {
            return (RadialDatasetSweep.Sweep)this.sweeps.get(nsw);
        }

        private Dorade2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            super(Dorade2Dataset.this, v.getName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.nsweeps = 0;
            this.name = v.getName();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            this.sweeps.add(new Dorade2Sweep(v0, 0, nrays, ngates));
        }

        public String toString() {
            return this.name;
        }

        public float[] readAllData() throws IOException {
            Array allData;
            RadialDatasetSweep.Sweep spn = (RadialDatasetSweep.Sweep)this.sweeps.get(0);
            Variable v = spn.getsweepVar();
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        public void clearVariableMemory() {
        }

        private class Dorade2Sweep
        implements RadialDatasetSweep.Sweep {
            int nrays;
            int ngates;
            double meanElevation = Double.NaN;
            Variable sweepVar;
            int sweepno;

            Dorade2Sweep(Variable v, int sweepno, int rays, int gates) {
                this.sweepVar = v;
                this.nrays = rays;
                this.ngates = gates;
                this.sweepno = sweepno;
            }

            public Variable getsweepVar() {
                return this.sweepVar;
            }

            public RadialDatasetSweep.Type getType() {
                return null;
            }

            public float getLon(int ray) {
                return Dorade2Dataset.this.lonv[ray];
            }

            public int getGateNumber() {
                return this.ngates;
            }

            public int getRadialNumber() {
                return this.nrays;
            }

            public int getSweepIndex() {
                return 0;
            }

            public float[] readData() throws IOException {
                return Dorade2Variable.this.readAllData();
            }

            public float[] readData(int ray) throws IOException {
                Array rayData;
                int[] shape = this.sweepVar.getShape();
                int[] origi = new int[this.sweepVar.getRank()];
                shape[0] = 1;
                origi[0] = ray;
                try {
                    rayData = this.sweepVar.read(origi, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])rayData.get1DJavaArray(Float.TYPE);
            }

            public float getBeamWidth() {
                try {
                    Dorade2Dataset.this.bwidthv = Dorade2Dataset.this.ncd.findVariable("bm_width").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2Dataset.this.bwidthv;
            }

            public float getNyquistFrequency() {
                return 0.0f;
            }

            public float getRangeToFirstGate() {
                try {
                    Dorade2Dataset.this.ranv = Dorade2Dataset.this.ncd.findVariable("Range_to_First_Cell").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2Dataset.this.ranv;
            }

            public float getGateSize() {
                try {
                    Dorade2Dataset.this.cellv = Dorade2Dataset.this.ncd.findVariable("Cell_Spacing").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2Dataset.this.cellv;
            }

            public float getMeanElevation() {
                int[] shapeRadial = new int[]{this.nrays};
                Array data = Array.factory(Float.class, shapeRadial, (Object)Dorade2Dataset.this.elev);
                this.meanElevation = MAMath.sumDouble(data) / (double)data.getSize();
                return (float)this.meanElevation;
            }

            public float getElevation(int ray) {
                return Dorade2Dataset.this.elev[ray];
            }

            public float[] getElevation() {
                return Dorade2Dataset.this.elev;
            }

            public float getAzimuth(int ray) {
                return Dorade2Dataset.this.aziv[ray];
            }

            public float[] getAzimuth() {
                return Dorade2Dataset.this.aziv;
            }

            public float getTime() {
                return (float)Dorade2Dataset.this.timv[0];
            }

            public float getTime(int ray) {
                return (float)Dorade2Dataset.this.timv[ray];
            }

            public EarthLocation getOrigin(int ray) {
                return new EarthLocationImpl((double)Dorade2Dataset.this.latv[ray], (double)Dorade2Dataset.this.lonv[ray], (double)Dorade2Dataset.this.altv[ray]);
            }

            public float getMeanAzimuth() {
                if (this.getType() != null) {
                    return Dorade2Variable.this.azi;
                }
                return 0.0f;
            }

            public Date getStartingTime() {
                return Dorade2Dataset.this.startDate;
            }

            public Date getEndingTime() {
                return Dorade2Dataset.this.endDate;
            }

            public void clearSweepMemory() {
            }
        }
    }
}

