/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StationHelper {
    private List<Station> stations = new ArrayList<Station>();
    private Map<String, Station> stationHash = new HashMap<String, Station>();
    private boolean debug = false;
    private LatLonRect rect;

    public void addStation(Station s) {
        this.stations.add(s);
        this.stationHash.put(s.getName(), s);
    }

    public void setStations(List<Station> nstations) {
        this.stations = new ArrayList<Station>();
        this.stationHash = new HashMap<String, Station>();
        for (Station s : nstations) {
            this.addStation(s);
        }
    }

    public LatLonRect getBoundingBox() {
        if (this.rect == null) {
            if (this.stations.size() == 0) {
                return null;
            }
            Station s = this.stations.get(0);
            LatLonPointImpl llpt = new LatLonPointImpl();
            llpt.set(s.getLatitude(), s.getLongitude());
            this.rect = new LatLonRect((LatLonPoint)llpt, 0.001, 0.001);
            if (this.debug) {
                System.out.println("start=" + s.getLatitude() + " " + s.getLongitude() + " rect= " + this.rect.toString2());
            }
            for (int i = 1; i < this.stations.size(); ++i) {
                s = this.stations.get(i);
                llpt.set(s.getLatitude(), s.getLongitude());
                this.rect.extend((LatLonPoint)llpt);
                if (!this.debug) continue;
                System.out.println("add=" + s.getLatitude() + " " + s.getLongitude() + " rect= " + this.rect.toString2());
            }
        }
        if (this.rect.crossDateline() && this.rect.getWidth() > 350.0) {
            double lat_min = this.rect.getLowerLeftPoint().getLatitude();
            double deltaLat = this.rect.getUpperLeftPoint().getLatitude() - lat_min;
            this.rect = new LatLonRect((LatLonPoint)new LatLonPointImpl(lat_min, -180.0), deltaLat, 360.0);
        }
        return this.rect;
    }

    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        if (boundingBox == null) {
            return this.stations;
        }
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<Station> result = new ArrayList<Station>();
        for (Station s : this.stations) {
            latlonPt.set(s.getLatitude(), s.getLongitude());
            if (!boundingBox.contains((LatLonPoint)latlonPt)) continue;
            result.add(s);
        }
        return result;
    }

    public Station getStation(String name) {
        return this.stationHash.get(name);
    }

    public List<Station> getStations() {
        return this.stations;
    }

    public List<Station> getStations(List<String> stnNames) {
        ArrayList<Station> result = new ArrayList<Station>(stnNames.size());
        for (String ss : stnNames) {
            Station s = this.stationHash.get(ss);
            if (s == null) continue;
            result.add(s);
        }
        return result;
    }
}

