/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class CdmRemoteFeatureDataset {
    private static boolean debug = true;
    private static boolean showXML = false;

    public static FeatureDataset factory(FeatureType wantFeatureType, String endpoint) throws IOException {
        FeatureType ft;
        if (endpoint.startsWith("cdmremote:")) {
            endpoint = endpoint.substring("cdmremote:".length());
        }
        Document doc = CdmRemoteFeatureDataset.getCapabilities(endpoint);
        Element root = doc.getRootElement();
        Element elem = root.getChild("featureDataset");
        String fType = elem.getAttribute("type").getValue();
        String uri = elem.getAttribute("url").getValue();
        if (debug) {
            System.out.printf("CdmRemoteFeatureDataset endpoint %s%n ftype= %s uri=%s%n", endpoint, fType, uri);
        }
        if ((ft = FeatureType.getType(fType)) == null || ft == FeatureType.NONE || ft == FeatureType.GRID) {
            CdmRemote ncremote = new CdmRemote(uri);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncremote, null);
            return new GridDataset(ncd);
        }
        List<VariableSimpleIF> dataVars = FeatureDatasetPointXML.getDataVariables(doc);
        LatLonRect bb = FeatureDatasetPointXML.getSpatialExtent(doc);
        DateRange dr = FeatureDatasetPointXML.getTimeSpan(doc);
        return new PointDatasetRemote(ft, uri, dataVars, bb, dr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getCapabilities(String endpoint) throws IOException {
        Document doc;
        block6: {
            HttpMethod method = null;
            try {
                try {
                    method = CdmRemote.sendQuery(endpoint, "req=capabilities");
                    InputStream in = method.getResponseBodyAsStream();
                    SAXBuilder builder = new SAXBuilder(false);
                    doc = builder.build(in);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                Object var6_6 = null;
                if (method == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (method != null) {
                    method.releaseConnection();
                }
                throw throwable;
            }
            method.releaseConnection();
        }
        if (showXML) {
            System.out.printf("*** endpoint = %s %n", endpoint);
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.printf("*** CdmRemoteFeatureDataset/showParsedXML = %n %s %n", xmlOut.outputString(doc));
        }
        return doc;
    }

    public static void main(String[] args) throws IOException {
        String endpoint = "http://localhost:8080/thredds/cdmremote/idd/metar/ncdecodedLocalHome";
        FeatureDatasetPoint fd = (FeatureDatasetPoint)CdmRemoteFeatureDataset.factory(FeatureType.ANY, endpoint);
        FeatureCollection fc = fd.getPointFeatureCollectionList().get(0);
        System.out.printf("Result= %s %n %s %n", fd, fc);
    }
}

