/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.XMLEntityResolver;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.radial.StationRadarCollectionImpl;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateType;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDSRadarDatasetCollection
extends StationRadarCollectionImpl {
    protected HashMap<String, Station> stationHMap;
    private List<String> radarTimeSpan;
    private LatLonRect radarRegion;
    private String dsc_location;
    private List<Product> radarProducts;
    private String summary;
    protected static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4");
    private URI docURI;

    public static TDSRadarDatasetCollection factory(InvDataset ds, String dsc_location, StringBuffer errlog) throws IOException, URISyntaxException {
        return TDSRadarDatasetCollection.factory(ds.getDocumentation("summary"), dsc_location, errlog);
    }

    public static TDSRadarDatasetCollection factory(String desc, String dsc_location, StringBuffer errlog) throws IOException {
        Document doc = null;
        XMLEntityResolver jaxp = new XMLEntityResolver(true);
        SAXBuilder builder = jaxp.getSAXBuilder();
        try {
            doc = builder.build(dsc_location);
        }
        catch (JDOMException e) {
            errlog.append(e.toString());
        }
        Element qcElem = doc.getRootElement();
        Namespace ns = qcElem.getNamespace();
        return new TDSRadarDatasetCollection(desc, dsc_location, qcElem, ns, errlog);
    }

    private TDSRadarDatasetCollection(String desc, String dsc_location, Element elem, Namespace ns, StringBuffer errlog) throws IOException {
        Element serviceElem = this.readElements(elem, "service");
        Element dsElem = this.readElements(elem, "dataset");
        Element metaElem = this.readElements(dsElem, "metadata");
        String sts = dsc_location.replaceFirst("dataset.xml", "stations.xml");
        HashMap stationHMap = this.readRadarStations(sts);
        LatLonRect radarRegion = this.readSelectRegion(metaElem, ns);
        List<String> radarTimeSpan = this.readSelectTime(metaElem, ns);
        List<Product> productList = this.readSelectVariable(metaElem, ns);
        String summary = this.readSelectDocument(metaElem, ns);
        if (stationHMap == null) {
            errlog.append("TDSRadarDatasetCollection must have station selected");
            return;
        }
        if (radarRegion == null) {
            errlog.append("TDSRadarDatasetCollection must have region selected");
            return;
        }
        if (radarTimeSpan == null) {
            errlog.append("TDSRadarDatasetCollection must have time span selected");
            return;
        }
        this.desc = desc;
        this.dsc_location = dsc_location;
        this.radarProducts = productList;
        this.summary = summary;
        this.stationHMap = stationHMap;
        this.radarRegion = radarRegion;
        this.radarTimeSpan = radarTimeSpan;
        this.startDate = DateUnit.getStandardOrISO(radarTimeSpan.get(0));
        this.endDate = DateUnit.getStandardOrISO(radarTimeSpan.get(1));
        try {
            this.timeUnit = new DateUnit("hours since 1991-01-01T00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap readRadarStations(String stsXML_location) throws IOException {
        Document doc = null;
        XMLEntityResolver jaxp = new XMLEntityResolver(true);
        SAXBuilder builder = jaxp.getSAXBuilder();
        HashMap<String, Station> stations = new HashMap<String, Station>();
        try {
            doc = builder.build(stsXML_location);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        Element rootElem = doc.getRootElement();
        List children = rootElem.getChildren();
        for (Element child : children) {
            Station s = this.readStation(child);
            if (null == s) continue;
            stations.put(s.getName(), s);
        }
        return stations;
    }

    public Element readElements(Element elem, String eleName) {
        List children = elem.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            if (!childName.equals(eleName)) continue;
            return child;
        }
        return null;
    }

    private Station readStation(Element elem) {
        String name = elem.getAttributeValue("id");
        Element desc = elem.getChild("name");
        String descv = desc.getValue();
        Element lat = elem.getChild("latitude");
        String latv = lat.getValue();
        Element lon = elem.getChild("longitude");
        String lonv = lon.getValue();
        Element alt = elem.getChild("elevation");
        String altv = alt.getValue();
        StationImpl station = new StationImpl(name, descv, "", Double.parseDouble(latv), Double.parseDouble(lonv), Double.parseDouble(altv));
        return station;
    }

    public LatLonRect readSelectRegion(Element elem, Namespace ns) {
        Element region = elem.getChild("LatLonBox", ns);
        Element north = region.getChild("north", ns);
        String nv = north.getValue();
        Element south = region.getChild("south", ns);
        String sv = south.getValue();
        Element east = region.getChild("east", ns);
        String ev = east.getValue();
        Element west = region.getChild("west", ns);
        String wv = west.getValue();
        LatLonPointImpl p1 = new LatLonPointImpl(Double.valueOf(sv).doubleValue(), Double.valueOf(wv).doubleValue());
        LatLonPointImpl p2 = new LatLonPointImpl(Double.valueOf(nv).doubleValue(), Double.valueOf(ev).doubleValue());
        LatLonRect llr = new LatLonRect((LatLonPoint)p1, (LatLonPoint)p2);
        return llr;
    }

    public List<String> readSelectTime(Element elem, Namespace ns) {
        Element region = elem.getChild("TimeSpan", ns);
        List regionInfo = region.getChildren();
        Element start = region.getChild("start", ns);
        String sv = start.getValue();
        Element end = region.getChild("end", ns);
        String ev = end.getValue();
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(sv);
        ll.add(ev);
        return ll;
    }

    public List<Product> readSelectVariable(Element elem, Namespace ns) {
        ArrayList<Product> varlist = new ArrayList<Product>();
        Element v = elem.getChild("Variables", ns);
        List varInfo = v.getChildren();
        for (Element p : varInfo) {
            Product s;
            String id = p.getAttributeValue("name");
            if (id.contains("/")) {
                String[] c = id.split("/");
                s = new Product(c[0], c[1]);
                varlist.add(s);
                continue;
            }
            String name = p.getAttributeValue("vocabulary_name");
            s = new Product(id, name);
            varlist.add(s);
        }
        return varlist;
    }

    private String readSelectDocument(Element elem, Namespace ns) {
        Element doc = elem.getChild("documentation", ns);
        return doc.getValue();
    }

    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
    }

    @Override
    public String getTitle() {
        return this.summary;
    }

    @Override
    public String getLocation() {
        return this.dsc_location;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public LatLonRect getRadarsBoundingBox() {
        return this.radarRegion;
    }

    public List getRadarTimeSpan() {
        return this.radarTimeSpan;
    }

    public List getRadarProducts() {
        return this.radarProducts;
    }

    @Override
    public boolean checkStationProduct(String sName, Product product) {
        for (Product s : this.radarProducts) {
            if (!s.equals((Object)product)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkStationProduct(Product product) {
        return this.checkStationProduct(null, product);
    }

    @Override
    public int getStationProductCount(String sName) {
        return this.radarProducts.size();
    }

    @Override
    public List<Station> getStations() throws IOException {
        return this.getRadarStations();
    }

    public List<Station> getRadarStations() {
        ArrayList<Station> slist = new ArrayList<Station>();
        Iterator<Station> it = this.stationHMap.values().iterator();
        while (it.hasNext()) {
            slist.add(it.next());
        }
        return slist;
    }

    public Station getRadarStation(String sName) {
        return this.stationHMap.get(sName);
    }

    @Override
    public List<Station> getStations(CancelTask cancel) throws IOException {
        return this.getStations(null, cancel);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        return this.getStations(boundingBox, null);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        Collection<Station> sl = this.stationHMap.values();
        ArrayList<Station> dsl = new ArrayList<Station>();
        if (!boundingBox.containedIn(this.radarRegion)) {
            return null;
        }
        for (Station s : sl) {
            if (boundingBox.contains(s.getLatLon())) {
                dsl.add(s);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return dsl;
    }

    public RadialDatasetSweep getRadarDataset(String stnName, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, absTime);
        if (invdata == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        ThreddsDataFactory tdFactory = new ThreddsDataFactory();
        ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(invdata, null);
        return (RadialDatasetSweep)result.featureDataset;
    }

    public RadialDatasetSweep getRadarDataset(String stnName, String productID, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, productID, absTime);
        if (invdata == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        ThreddsDataFactory tdFactory = new ThreddsDataFactory();
        ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(invdata, null);
        return (RadialDatasetSweep)result.featureDataset;
    }

    public URI getRadarDatasetURI(String stnName, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, absTime);
        List<InvAccess> acess = invdata.getAccess();
        InvAccess ia = acess.get(0);
        URI ui = ia.getStandardUri();
        if (ui == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        return ui;
    }

    private InvDataset queryRadarStation(String stnName, Date absTime) throws IOException {
        return this.queryRadarStation(stnName, (String)null, absTime);
    }

    private InvDataset queryRadarStation(String stnName, String productID, Date absTime) throws IOException {
        URI catalogURI;
        String stime = DateUtil.getTimeAsISO8601((Date)absTime).replaceAll("GMT", "");
        StringBuilder queryb = new StringBuilder();
        String baseURI = this.dsc_location.replaceFirst("/dataset.xml", "?");
        queryb.append(baseURI);
        queryb.append("&stn=" + stnName);
        if (productID != null) {
            queryb.append("&var=" + productID);
        }
        if (absTime == null) {
            queryb.append("&time=present");
        } else {
            queryb.append("&time=" + stime);
        }
        try {
            catalogURI = new URI(queryb.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("** MalformedURLException on URL <>\n" + e.getMessage() + "\n");
        }
        InvCatalogFactory factory = new InvCatalogFactory("default", false);
        InvCatalogImpl catalog = factory.readXML(catalogURI);
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            throw new IOException("Invalid catalog <" + catalogURI + ">\n" + buff.toString());
        }
        List<InvDataset> datasets = catalog.getDatasets();
        InvDataset idata = datasets.get(0);
        List<InvDataset> dsets = idata.getDatasets();
        InvDataset tdata = dsets.get(0);
        return tdata;
    }

    public URI getRadarDatasetURI(String stnName, String productID, Date absTime) throws IOException {
        if (productID == null) {
            return this.getRadarDatasetURI(stnName, absTime);
        }
        InvDataset invdata = this.queryRadarStation(stnName, productID, absTime);
        List<InvAccess> acess = invdata.getAccess();
        InvAccess ia = acess.get(0);
        URI ui = ia.getStandardUri();
        if (ui == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        return ui;
    }

    private TDSRadarDatasetInfo queryRadarStation(String stnName, Date start, Date end) throws IOException {
        return this.queryRadarStation(stnName, null, start, end);
    }

    private TDSRadarDatasetInfo queryRadarStation(String stnName, String productID, Date start, Date end) throws IOException {
        URI catalogURI;
        String stime;
        StringBuilder queryb = new StringBuilder();
        String baseURI = this.dsc_location.replaceFirst("/dataset.xml", "?");
        queryb.append(baseURI);
        queryb.append("&stn=" + stnName);
        if (productID != null) {
            queryb.append("&var=" + productID);
        }
        if (start == null && end == null) {
            queryb.append("&time=present");
        } else if (end == null) {
            stime = DateUtil.getTimeAsISO8601((Date)start).replaceAll("GMT", "");
            queryb.append("&time_start=" + stime);
            queryb.append("&time_end=present");
        } else {
            stime = DateUtil.getTimeAsISO8601((Date)start).replaceAll("GMT", "");
            String etime = DateUtil.getTimeAsISO8601((Date)end).replaceAll("GMT", "");
            queryb.append("&time_start=" + stime);
            queryb.append("&time_end=" + etime);
        }
        try {
            catalogURI = new URI(queryb.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("** MalformedURLException on URL <>\n" + e.getMessage() + "\n");
        }
        InvCatalogFactory factory = new InvCatalogFactory("default", false);
        InvCatalogImpl catalog = factory.readXML(catalogURI);
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            throw new IOException("Invalid catalog <" + catalogURI + ">\n" + buff.toString());
        }
        List<InvDataset> datasets = catalog.getDatasets();
        InvDataset idata = datasets.get(0);
        List<InvDataset> dsets = idata.getDatasets();
        ArrayList<Date> absTimeList = new ArrayList<Date>();
        ArrayList<DatasetURIInfo> dURIList = new ArrayList<DatasetURIInfo>();
        ArrayList<InvDatasetInfo> dInvList = new ArrayList<InvDatasetInfo>();
        for (InvDataset tdata : dsets) {
            List<InvAccess> acess = tdata.getAccess();
            List<DateType> dates = tdata.getDates();
            InvAccess ia = acess.get(0);
            URI d = ia.getStandardUri();
            Date date = dates.get(0).getDate();
            absTimeList.add(date);
            dURIList.add(new DatasetURIInfo(d, date));
            dInvList.add(new InvDatasetInfo(tdata, date));
        }
        TDSRadarDatasetInfo dri = new TDSRadarDatasetInfo(absTimeList, dURIList, dInvList);
        return dri;
    }

    public List getRadarStationURIs(String stnName, Date start, Date end) throws IOException {
        TDSRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        List<DatasetURIInfo> uList = dri.getURIList();
        ArrayList<URI> datasetsURI = new ArrayList<URI>();
        for (DatasetURIInfo du : uList) {
            datasetsURI.add(du.uri);
        }
        return datasetsURI;
    }

    public List getRadarStationDatasets(String stnName, Date start, Date end) throws IOException {
        ArrayList<FeatureDataset> datasetList = new ArrayList<FeatureDataset>();
        TDSRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        List<InvDatasetInfo> iList = dri.getInvList();
        for (InvDatasetInfo iv : iList) {
            InvDataset tdata = iv.inv;
            ThreddsDataFactory tdFactory = new ThreddsDataFactory();
            ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(tdata, null);
            datasetList.add(result.featureDataset);
        }
        return datasetList;
    }

    public List<Date> getRadarStationTimes(String stnName, Date start, Date end) throws IOException {
        return this.getRadarStationTimes(stnName, null, start, end);
    }

    public List<Date> getRadarStationTimes(String stnName, String productID, Date start, Date end) throws IOException {
        TDSRadarDatasetInfo dri = this.queryRadarStation(stnName, productID, start, end);
        return dri.getTimeList();
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    private List queryRadarStationRTimes(String stn) throws IOException {
        return this.radarTimeSpan;
    }

    public List getDataURIs(String sName, DateSelection dateInfo) throws IOException {
        return this.getDataURIs(sName, dateInfo, null);
    }

    public List getData(String sName, DateSelection dateInfo) throws IOException {
        return this.getData(sName, dateInfo, null);
    }

    public List getData(String sName, DateSelection dateSelect, CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        TDSRadarDatasetInfo dri = this.queryRadarStation(sName, dateSelect.getStartFixedDate(), dateSelect.getEndFixedDate());
        ArrayList<FeatureDataset> datasetList = new ArrayList<FeatureDataset>();
        List datasetINVs = dateSelect.apply(dri.getInvList());
        for (InvDatasetInfo ifo : datasetINVs) {
            InvDataset tdata = ifo.inv;
            ThreddsDataFactory tdFactory = new ThreddsDataFactory();
            ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(tdata, null);
            datasetList.add(result.featureDataset);
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return datasetList;
    }

    public List<URI> getDataURIs(String sName, DateSelection dateSelect, CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        TDSRadarDatasetInfo dri = this.queryRadarStation(sName, dateSelect.getStartFixedDate(), dateSelect.getEndFixedDate());
        List datasetsURIs = dateSelect.apply(dri.getURIList());
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (DatasetURIInfo ufo : datasetsURIs) {
            URI u = ufo.uri;
            uriList.add(u);
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return uriList;
    }

    public static long roundTo(long roundTo, long seconds) {
        int roundToSeconds = (int)roundTo;
        if (roundToSeconds == 0) {
            return seconds;
        }
        return seconds - (long)((int)seconds % roundToSeconds);
    }

    public static void main(String[] args) throws IOException {
        StringBuffer errlog = new StringBuffer();
        String ds_location = null;
        TDSRadarDatasetCollection dsc = null;
        List<Station> stns = null;
        ds_location = "http://motherlode.ucar.edu:9080/thredds/radarServer/nexrad/level3/CCS039/dataset.xml";
        dsc = TDSRadarDatasetCollection.factory("test", ds_location, errlog);
        System.out.println(" errs= " + errlog);
        stns = dsc.getStations();
        System.out.println(" nstns= " + stns.size());
        stns = dsc.getStations();
        System.out.println(" nstns= " + stns.size());
        Station stn = dsc.getRadarStation("DVN");
        System.out.println("stn = " + stn);
        List tl = dsc.getRadarTimeSpan();
        Date ts1 = DateUnit.getStandardOrISO("1998-06-28T01:01:21Z");
        Date ts2 = DateUnit.getStandardOrISO("1998-07-30T19:01:21Z");
        List pd = dsc.getRadarProducts();
        List<Date> tlist = dsc.getRadarStationTimes(stn.getName(), "BREF1", ts1, ts2);
        int sz = tlist.size();
        for (int i = 0; i < 3; ++i) {
            Date ts0 = tlist.get(i);
            RadialDatasetSweep rds = dsc.getRadarDataset(stn.getName(), "BREF1", ts0);
            boolean tt = false;
        }
        Date ts0 = tlist.get(0);
        URI stURL = dsc.getRadarDatasetURI(stn.getName(), "BREF1", ts0);
        assert (null != stURL);
        DateSelection dateS = new DateSelection(ts1, ts2);
        dateS.setInterval(3600000.0);
        dateS.setRoundTo(3600000.0);
        dateS.setPreRange(500000.0);
        dateS.setPostRange(500000.0);
        for (int i = 0; i < stns.size(); ++i) {
            stn = stns.get(i);
            List<Date> times = dsc.getRadarStationTimes(stn.getName(), new Date(System.currentTimeMillis() - 50065408L), new Date(System.currentTimeMillis()));
            if (times.size() > 0) {
                System.err.println(stn + " times:" + times.size() + " " + times.get(0) + " - " + times.get(times.size() - 1));
                continue;
            }
            System.err.println(stn + " no times");
        }
        List jList = dsc.getDataURIs("KABX", dateS);
        assert (null != jList);
        List mList = dsc.getData("KABX", dateS, null);
        assert (null != mList);
        Date ts = tlist.get(1);
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String st = isoDateTimeFormat.format(ts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TDSRadarDatasetInfo {
        private List absTimeList;
        private List datasetInfoList;
        private List invDatasetList;

        public TDSRadarDatasetInfo() {
        }

        public TDSRadarDatasetInfo(List absTimeList, List datasetInfoList, List invDatasetList) {
            this.absTimeList = absTimeList;
            this.datasetInfoList = datasetInfoList;
            this.invDatasetList = invDatasetList;
        }

        public List<Date> getTimeList() {
            return this.absTimeList;
        }

        public List<DatasetURIInfo> getURIList() {
            return this.datasetInfoList;
        }

        public List<InvDatasetInfo> getInvList() {
            return this.invDatasetList;
        }
    }

    public class InvDatasetInfo
    implements DatedThing {
        private InvDataset inv = null;
        private Date date = null;

        public InvDatasetInfo(InvDataset u, Date date) {
            this.inv = u;
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public class DatasetURIInfo
    implements DatedThing {
        private URI uri = null;
        private Date date = null;

        public DatasetURIInfo(URI u, Date date) {
            this.uri = u;
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

