/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil;

public class DiskCache2 {
    public static int CACHEPATH_POLICY_ONE_DIRECTORY = 0;
    public static int CACHEPATH_POLICY_NESTED_DIRECTORY = 1;
    public static int CACHEPATH_POLICY_NESTED_TRUNCATE = 2;
    private int cachePathPolicy;
    private String cachePathPolicyParam = null;
    private String root = null;
    private int persistMinutes;
    private Timer timer;
    private Logger cacheLog = LoggerFactory.getLogger((String)"cacheLogger");

    public DiskCache2(String root, boolean reletiveToHome, int persistMinutes, int scourEveryMinutes) {
        this.persistMinutes = persistMinutes;
        if (reletiveToHome) {
            String home = System.getProperty("nj22.cachePersistRoot");
            if (home == null) {
                home = System.getProperty("user.home");
            }
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            if (!home.endsWith("/")) {
                home = home + "/";
            }
            root = home + root;
        }
        this.setRootDirectory(root);
        if (scourEveryMinutes > 0) {
            this.timer = new Timer("DiskCache-" + root);
            Calendar c = Calendar.getInstance();
            c.add(12, scourEveryMinutes);
            this.timer.scheduleAtFixedRate((TimerTask)new CacheScourTask(), c.getTime(), 60000L * (long)scourEveryMinutes);
        }
    }

    public void exit() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setLogger(Logger cacheLog) {
        this.cacheLog = cacheLog;
    }

    public void setRootDirectory(String cacheDir) {
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        this.root = StringUtil.replace((String)cacheDir, (char)'\\', (String)"/");
        File dir = new File(this.root);
        dir.mkdirs();
        if (!dir.exists()) {
            this.cacheLog.error("Failed to create directory " + this.root);
        }
    }

    public String getRootDirectory() {
        return this.root;
    }

    public File getCacheFile(String fileLocation) {
        File f = new File(this.makeCachePath(fileLocation));
        if (this.cachePathPolicy == CACHEPATH_POLICY_NESTED_DIRECTORY) {
            File dir = f.getParentFile();
            dir.mkdirs();
        }
        return f;
    }

    public synchronized File createUniqueFile(String prefix, String suffix) {
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random random = new Random(System.currentTimeMillis());
        File result = new File(this.getRootDirectory(), prefix + Integer.toString(random.nextInt()) + suffix);
        while (result.exists()) {
            result = new File(this.getRootDirectory(), prefix + Integer.toString(random.nextInt()) + suffix);
        }
        return result;
    }

    public void setCachePathPolicy(int cachePathPolicy, String cachePathPolicyParam) {
        this.cachePathPolicy = cachePathPolicy;
        this.cachePathPolicyParam = cachePathPolicyParam;
    }

    public void setPolicy(int cachePathPolicy) {
        this.cachePathPolicy = cachePathPolicy;
    }

    private String makeCachePath(String fileLocation) {
        File file;
        File parent;
        String cachePath = StringUtil.remove((String)fileLocation, (int)58);
        cachePath = StringUtil.remove((String)cachePath, (int)63);
        cachePath = StringUtil.remove((String)cachePath, (int)61);
        if ((cachePath = StringUtil.replace((String)cachePath, (char)'\\', (String)"/")).startsWith("/")) {
            cachePath = cachePath.substring(1);
        }
        if (cachePath.endsWith("/")) {
            cachePath = cachePath.substring(0, cachePath.length() - 1);
        }
        if (this.cachePathPolicy == CACHEPATH_POLICY_ONE_DIRECTORY) {
            cachePath = StringUtil.replace((String)cachePath, (char)'/', (String)"-");
        } else if (this.cachePathPolicy == CACHEPATH_POLICY_NESTED_TRUNCATE) {
            int pos = cachePath.indexOf(this.cachePathPolicyParam);
            if (pos >= 0) {
                cachePath = cachePath.substring(pos + this.cachePathPolicyParam.length());
            }
            if (cachePath.startsWith("/")) {
                cachePath = cachePath.substring(1);
            }
        }
        if (this.cachePathPolicy != CACHEPATH_POLICY_ONE_DIRECTORY && !(parent = (file = new File(this.root + cachePath)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        return this.root + cachePath;
    }

    public void showCache(PrintStream pw) {
        File[] files;
        pw.println("Cache files");
        pw.println("Size   LastModified       Filename");
        File dir = new File(this.root);
        for (File file : files = dir.listFiles()) {
            String org = null;
            try {
                org = URLDecoder.decode(file.getName(), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            pw.println(" " + file.length() + " " + new Date(file.lastModified()) + " " + org);
        }
    }

    public void cleanCache(File dir, StringBuilder sbuff, boolean isRoot) {
        long now = System.currentTimeMillis();
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalStateException("DiskCache2: not a directory or I/O error on dir=" + dir.getAbsolutePath());
        }
        if (!isRoot && files.length == 0) {
            long duration = now - dir.lastModified();
            if ((duration /= 60000L) > (long)this.persistMinutes) {
                dir.delete();
                if (sbuff != null) {
                    sbuff.append(" deleted ").append(dir.getPath()).append(" last= ").append(new Date(dir.lastModified())).append("\n");
                }
            }
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.cleanCache(file, sbuff, false);
                continue;
            }
            long duration = now - file.lastModified();
            if ((duration /= 60000L) <= (long)this.persistMinutes) continue;
            file.delete();
            if (sbuff == null) continue;
            sbuff.append(" deleted ").append(file.getPath()).append(" last= ").append(new Date(file.lastModified())).append("\n");
        }
    }

    static void make(DiskCache2 dc, String filename) throws IOException {
        File want = dc.getCacheFile(filename);
        System.out.println("make=" + want.getPath() + "; exists = " + want.exists());
        if (!want.exists()) {
            want.createNewFile();
        }
        System.out.println(" canRead= " + want.canRead() + " canWrite = " + want.canWrite() + " lastMod = " + new Date(want.lastModified()));
        try {
            String enc = URLEncoder.encode(filename, "UTF8");
            System.out.println(" original=" + URLDecoder.decode(enc, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        DiskCache2 dc = new DiskCache2("C:/TEMP/test/", false, 0, 0);
        dc.setRootDirectory("C:/temp/chill/");
        DiskCache2.make(dc, "C:/junk.txt");
        DiskCache2.make(dc, "C:/some/enchanted/evening/joots+3478.txt");
        DiskCache2.make(dc, "http://www.unidata.ucar.edu/some/enc hanted/eve'ning/nowrite.gibberish");
        dc.showCache(System.out);
        StringBuilder sbuff = new StringBuilder();
        dc.cleanCache(new File(dc.getRootDirectory()), sbuff, true);
        System.out.println(sbuff);
    }

    private class CacheScourTask
    extends TimerTask {
        CacheScourTask() {
        }

        public void run() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("CacheScourTask on").append(DiskCache2.this.root).append("\n");
            DiskCache2.this.cleanCache(new File(DiskCache2.this.root), sbuff, true);
            sbuff.append("----------------------\n");
            if (DiskCache2.this.cacheLog != null) {
                DiskCache2.this.cacheLog.info(sbuff.toString());
            }
        }
    }
}

