/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.query;

import org.alfresco.error.AlfrescoRuntimeException;

/**
 * Exception generated by failures to execute canned queries.
 * 
 * @author Derek Hulley
 * @since 4.0
 */
public class CannedQueryException extends AlfrescoRuntimeException
{
    private static final long serialVersionUID = -4985399145374964458L;

    /**
     * @param msg           the message
     */
    public CannedQueryException(String msg)
    {
        super(msg);
    }

    /**
     * @param msg           the message
     * @param cause         the exception cause
     */
    public CannedQueryException(String msg, Throwable cause)
    {
        super(msg, cause);
    }

    /**
     * @param msgId         the message id
     * @param msgParams     the message parameters
     */
    public CannedQueryException(String msgId, Object[] msgParams)
    {
        super(msgId, msgParams);
    }

    /**
     * @param msgId         the message id
     * @param msgParams     the message parameters
     * @param cause         the exception cause
     */
    public CannedQueryException(String msgId, Object[] msgParams, Throwable cause)
    {
        super(msgId, msgParams, cause);
    }
}
