/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServices;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

/**
 * GUID Object Reference. This class decodes node 'paths' generated by links.lib.atom.ftl. These are not the same as
 * CMIS object IDs.
 * 
 * @author davidc
 */
public class NodeIdReference extends AbstractObjectReference
{
    private String id;
    private String[] reference;

    /**
     * Construct
     * 
     * @param cmisServices
     * @param repo
     * @param id
     */
    public NodeIdReference(CMISServices cmisServices, CMISRepositoryReference repo, String id)
    {
        super(cmisServices, repo);

        this.id = id;

        StoreRef storeRef = repo.getStoreRef();
        String[] idParts = this.id.split("/");
        reference = new String[2 + idParts.length];
        reference[0] = storeRef.getProtocol();
        reference[1] = storeRef.getIdentifier();
        System.arraycopy(idParts, 0, reference, 2, idParts.length);
    }

    /*
     * (non-Javadoc)
     * @see org.alfresco.cmis.CMISObjectReference#getNodeRef()
     */
    public NodeRef getNodeRef()
    {
        return cmisServices.getNode("node", reference);
    }

    /**
     * @return  id
     */
    public String getId()
    {
        return id;
    }
    
    @Override
    public String toString()
    {
        return "NodeIdReference[storeRef=" + repo.getStoreRef() + ",id=" + id + "]";
    }

}
